/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.ui.FontRenderer;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FontChooser
extends JPanel {
    private Font selectedFont;
    protected Font[] displayFonts;
    protected DefaultComboBoxModel fontFaceModel;
    protected JComboBox face;

    public FontChooser() {
        this((Font)null);
    }

    public FontChooser(Font def) {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts(), def);
    }

    public FontChooser(Font[] srcFonts, Font def) {
        this.displayFonts = srcFonts;
        this.fontFaceModel = new DefaultComboBoxModel<Font>(this.displayFonts);
        this.face = new JComboBox(this.fontFaceModel);
        this.face.setRenderer(new FontRenderer());
        this.face.addItemListener(new FontFaceSelectionListener());
        this.selectedFont = def == null ? new Font("dialog", 0, 1) : def.deriveFont(1.0f);
        this.face.setSelectedItem(this.selectedFont);
        this.add(this.face);
    }

    public JComboBox getFaceComboBox() {
        return this.face;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    private class FontFaceSelectionListener
    implements ItemListener {
        private FontFaceSelectionListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JComboBox source = (JComboBox)e.getItemSelectable();
                FontChooser.this.selectedFont = (Font)source.getSelectedItem();
            }
        }
    }
}

