/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.ValueDisplayer;
import cytoscape.visual.ui.VizMapUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultPanel
extends JPanel
implements ChangeListener {
    private VisualMappingManager vmm;
    private ValueDisplayer backColor;
    private VizMapUI parentDialog;

    public DefaultPanel(VizMapUI parentDialog, VisualMappingManager vmm) {
        super(false);
        this.parentDialog = parentDialog;
        this.vmm = vmm;
        VisualStyle vs = vmm.getVisualStyle();
        GlobalAppearanceCalculator gCalc = vs.getGlobalAppearanceCalculator();
        gCalc.addChangeListener(this);
        vmm.addChangeListener(this);
        this.addColorButton();
    }

    private void addColorButton() {
        GridBagGroup def = new GridBagGroup();
        def.panel = this;
        this.setLayout(def.gridbag);
        MiscGB.pad(def.constraints, 2, 2);
        MiscGB.inset(def.constraints, 3);
        VisualStyle vs = this.vmm.getVisualStyle();
        GlobalAppearanceCalculator gCalc = vs.getGlobalAppearanceCalculator();
        Color initColor = gCalc.getDefaultBackgroundColor();
        this.backColor = ValueDisplayer.getDisplayFor(this.parentDialog, "Background Color", initColor);
        this.backColor.addItemListener(new BackColorListener());
        JButton backColorBut = new JButton("Background Color");
        backColorBut.addActionListener(this.backColor.getInputListener());
        MiscGB.insert(def, (Component)backColorBut, 0, 0);
        MiscGB.insert(def, (Component)this.backColor, 1, 0);
    }

    public void stateChanged(ChangeEvent e) {
        VisualStyle vs = this.vmm.getVisualStyle();
        GlobalAppearanceCalculator gCalc = vs.getGlobalAppearanceCalculator();
        Color color = gCalc.getDefaultBackgroundColor();
        this.backColor.setBackground(color);
        this.repaint();
    }

    private class BackColorListener
    implements ItemListener {
        private BackColorListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Color newBG = (Color)DefaultPanel.this.backColor.getValue();
                VisualStyle vs = DefaultPanel.this.vmm.getVisualStyle();
                vs.getGlobalAppearanceCalculator().setDefaultBackgroundColor(newBG);
            }
        }
    }
}

