/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.discrete;

import cytoscape.CyNetwork;
import cytoscape.data.GraphObjAttributes;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.discrete.RandomColorListener;
import cytoscape.visual.mappings.discrete.ValueChangeListener;
import cytoscape.visual.ui.ValueDisplayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DiscreteUI
extends JPanel
implements ChangeListener {
    private static final String USER_MSG = "Define Discrete Mapping";
    private JDialog parentDialog;
    private CyNetwork network;
    private String attrName;
    private TreeSet mappedKeys;
    private DiscreteMapping dm;
    private Object defaultObject;
    private byte mapType;
    private JPanel buttonPanel;
    private JScrollPane listScrollPane;
    private HashMap buttonPositions;

    public DiscreteUI(JDialog parentDialog, CyNetwork network, String attrName, Object defaultObject, byte mapType, DiscreteMapping dm) {
        this.parentDialog = parentDialog;
        this.network = network;
        this.mappedKeys = new TreeSet();
        this.attrName = attrName;
        this.defaultObject = defaultObject;
        this.mapType = mapType;
        this.dm = dm;
        this.buttonPositions = new HashMap();
        dm.addChangeListener(this);
        this.loadKeys(network);
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        if (this.attrName == null) {
            JLabel label = new JLabel("Attribute is not set.");
            label.setHorizontalAlignment(0);
            this.add((Component)label, "Center");
            return;
        }
        if (this.mappedKeys == null || this.mappedKeys.size() == 0) {
            JLabel label = new JLabel("Mapping for this attribute is not supported.");
            label.setHorizontalAlignment(0);
            this.add((Component)label, "Center");
            return;
        }
        int numKeys = this.mappedKeys.size();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(numKeys, 2));
        Iterator iterator = this.mappedKeys.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object keyObject = iterator.next();
            Object currentMapping = this.dm.getMapValue(keyObject);
            JButton mapButton = new JButton(keyObject.toString());
            ValueDisplayer valueDisplayer = this.getMapValue(currentMapping);
            this.buttonPanel.add((Component)mapButton, index);
            this.buttonPanel.add((Component)valueDisplayer, ++index);
            valueDisplayer.addItemListener(new ValueChangeListener(this.dm, keyObject));
            this.buttonPositions.put(keyObject, new Integer(index++));
            mapButton.addActionListener(valueDisplayer.getInputListener());
        }
        if (this.dm.getRangeClass().getName().equals("java.awt.Color")) {
            JButton button = new JButton("Seed Mapping with Random Colors");
            button.addActionListener(new RandomColorListener(this.dm, this.mappedKeys));
            this.add((Component)button, "South");
        }
        this.resetScrollPane(this.buttonPanel);
    }

    public void stateChanged(ChangeEvent e) {
        Object lastKey = this.dm.getLastKeyModified();
        if (lastKey != null) {
            Object value = this.dm.getMapValue(lastKey);
            ValueDisplayer newValueDisplayer = ValueDisplayer.getDisplayFor(this.parentDialog, USER_MSG, value);
            Integer pos = (Integer)this.buttonPositions.get(lastKey);
            if (pos != null) {
                this.swapValueDisplayer(newValueDisplayer, pos, lastKey);
            }
        }
    }

    void swapValueDisplayer(ValueDisplayer valueDisplayer, int position, Object keyObject) {
        this.buttonPanel.remove(position);
        this.buttonPanel.add((Component)valueDisplayer, position);
        valueDisplayer.addItemListener(new ValueChangeListener(this.dm, keyObject));
        this.remove(this.listScrollPane);
        this.resetScrollPane(this.buttonPanel);
    }

    private ValueDisplayer getMapValue(Object currentMapping) {
        ValueDisplayer mapValue = currentMapping == null ? ValueDisplayer.getBlankDisplayFor(this.parentDialog, USER_MSG, this.defaultObject) : ValueDisplayer.getDisplayFor(this.parentDialog, USER_MSG, currentMapping);
        return mapValue;
    }

    private void loadKeys(CyNetwork network) {
        if (network == null) {
            return;
        }
        GraphObjAttributes attrs = this.mapType == 0 ? network.getEdgeAttributes() : network.getNodeAttributes();
        HashMap mapAttrs = attrs.getAttribute(this.attrName);
        if (mapAttrs == null) {
            return;
        }
        List<Class> acceptedClasses = Arrays.asList(this.dm.getAcceptedDataClasses());
        Class mapAttrClass = attrs.getClass(this.attrName);
        if (mapAttrClass == null || !acceptedClasses.contains(mapAttrClass)) {
            return;
        }
        this.loadKeySet(mapAttrs);
    }

    private void loadKeySet(HashMap mapAttrs) {
        Iterator keyIter = mapAttrs.values().iterator();
        while (keyIter.hasNext()) {
            Object o = keyIter.next();
            if (o instanceof List) {
                List list = (List)o;
                for (int i = 0; i < list.size(); ++i) {
                    Object vo = list.get(i);
                    if (this.mappedKeys.contains(vo)) continue;
                    this.mappedKeys.add(vo);
                }
                continue;
            }
            if (this.mappedKeys.contains(o)) continue;
            this.mappedKeys.add(o);
        }
    }

    private void resetScrollPane(JPanel internalPanel) {
        this.listScrollPane = new JScrollPane(internalPanel, 20, 31);
        this.add((Component)this.listScrollPane, "Center");
        Dimension d = this.listScrollPane.getPreferredSize();
        int prefHeight = (int)d.getHeight();
        if (prefHeight > 200) {
            prefHeight = 200;
        }
        this.listScrollPane.setPreferredSize(new Dimension((int)d.getWidth() + 10, prefHeight));
        if (this.parentDialog != null) {
            this.parentDialog.pack();
            this.parentDialog.validate();
            this.parentDialog.repaint();
        }
    }
}

