/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.discrete;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DiscreteRangeCalculator {
    private TreeMap map;
    private String attrName;

    public DiscreteRangeCalculator(TreeMap map, String attrName) {
        this.map = map;
        this.attrName = attrName;
    }

    public Object calculateRangeValue(Map attrBundle) {
        if (attrBundle == null || this.attrName == null) {
            return null;
        }
        Object attrValue = attrBundle.get(this.attrName);
        if (attrValue == null) {
            return null;
        }
        try {
            if (attrValue instanceof List) {
                Iterator attrValueIt = ((List)attrValue).iterator();
                while (attrValueIt.hasNext()) {
                    Object attrSubValue = attrValueIt.next();
                    if (this.map.get(attrSubValue) == null) continue;
                    return this.map.get(attrSubValue);
                }
                return null;
            }
            return this.map.get(attrValue);
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

