/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.CyNetwork;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.ValueParser;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class PassThroughMapping
implements ObjectMapping {
    Class rangeClass;
    String attrName;

    public PassThroughMapping(Object defaultObj, byte mapType) {
        this(defaultObj);
    }

    public PassThroughMapping(Object defaultObj) {
        this.rangeClass = defaultObj.getClass();
    }

    public PassThroughMapping(Object defaultObj, String attrName) {
        this.rangeClass = defaultObj.getClass();
        this.setControllingAttributeName(attrName, null, false);
    }

    public Object clone() {
        PassThroughMapping miniMe;
        try {
            miniMe = (PassThroughMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Critical error in PassThroughMapping - was not cloneable");
            e.printStackTrace();
            return null;
        }
        miniMe.attrName = new String(this.attrName);
        return miniMe;
    }

    public Class getRangeClass() {
        return this.rangeClass;
    }

    public Class[] getAcceptedDataClasses() {
        Class[] ret = new Class[]{Object.class};
        return ret;
    }

    public String getControllingAttributeName() {
        return this.attrName;
    }

    public void setControllingAttributeName(String attrName, CyNetwork network, boolean preserveMapping) {
        this.attrName = attrName;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public JPanel getUI(JDialog parent, CyNetwork network) {
        JPanel p = new JPanel();
        JLabel l1 = new JLabel("This is a passthrough mapping;");
        JLabel l2 = new JLabel("it has no user-editable parameters.");
        p.setLayout(new GridLayout(2, 1));
        p.add(l1);
        p.add(l2);
        return p;
    }

    public Object calculateRangeValue(Map attrBundle) {
        if (attrBundle == null || this.attrName == null) {
            return null;
        }
        Object attrValue = attrBundle.get(this.attrName);
        if (attrValue == null) {
            return null;
        }
        if (attrValue instanceof List) {
            Iterator attrValueIt = ((List)attrValue).iterator();
            while (attrValueIt.hasNext()) {
                Object attrSubValue = attrValueIt.next();
                if (!this.rangeClass.isInstance(attrSubValue)) continue;
                return attrSubValue;
            }
        }
        if (this.rangeClass.isInstance(attrValue)) {
            return attrValue;
        }
        if (this.rangeClass.equals(String.class)) {
            String stringConvert = attrValue.toString();
            if (stringConvert.length() > 20) {
                stringConvert = stringConvert.substring(0, 20) + "...";
            }
            return stringConvert;
        }
        return null;
    }

    public void applyProperties(Properties props, String baseKey, ValueParser parser) {
        String contKey = baseKey + ".controller";
        String contValue = props.getProperty(contKey);
        if (contValue != null) {
            this.setControllingAttributeName(contValue, null, false);
        }
    }

    public Properties getProperties(String baseKey) {
        Properties newProps = new Properties();
        String contKey = baseKey + ".controller";
        String contValue = this.getControllingAttributeName();
        newProps.setProperty(contKey, contValue);
        return newProps;
    }
}

