/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.CyNetwork;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.FlatInterpolator;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.mappings.continuous.ContinuousMappingReader;
import cytoscape.visual.mappings.continuous.ContinuousMappingWriter;
import cytoscape.visual.mappings.continuous.ContinuousRangeCalculator;
import cytoscape.visual.mappings.continuous.ContinuousUI;
import cytoscape.visual.parsers.ValueParser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class ContinuousMapping
extends SubjectBase
implements ObjectMapping {
    Object defaultObj;
    Class rangeClass;
    String attrName;
    Interpolator interpolator;
    private byte mapType;
    private ArrayList points = new ArrayList();

    public ContinuousMapping(Object defaultObj, byte mapType) throws IllegalArgumentException {
        this.rangeClass = defaultObj.getClass();
        this.defaultObj = defaultObj;
        this.mapType = mapType;
        if (mapType != 0 && mapType != 1) {
            throw new IllegalArgumentException("Unknown mapping type " + mapType);
        }
        this.interpolator = Color.class.isAssignableFrom(this.rangeClass) ? new LinearNumberToColorInterpolator() : (Number.class.isAssignableFrom(this.rangeClass) ? new LinearNumberToNumberInterpolator() : new FlatInterpolator());
    }

    public Object clone() {
        int i;
        ContinuousMapping clone = new ContinuousMapping(this.defaultObj, this.mapType);
        for (i = 0; i < this.observers.size(); ++i) {
            clone.addChangeListener((ChangeListener)this.observers.get(i));
        }
        for (i = 0; i < this.points.size(); ++i) {
            ContinuousMappingPoint cmp = (ContinuousMappingPoint)this.points.get(i);
            ContinuousMappingPoint cmpClone = (ContinuousMappingPoint)cmp.clone();
            clone.addPoint(cmpClone.getValue(), cmpClone.getRange());
        }
        return clone;
    }

    public ArrayList getAllPoints() {
        return this.points;
    }

    public void addPoint(double value, BoundaryRangeValues brv) {
        ContinuousMappingPoint cmp = new ContinuousMappingPoint(value, brv);
        this.points.add(cmp);
    }

    public void removePoint(int index) {
        this.points.remove(index);
    }

    public int getPointCount() {
        return this.points.size();
    }

    public ContinuousMappingPoint getPoint(int index) {
        return (ContinuousMappingPoint)this.points.get(index);
    }

    public void applyProperties(Properties props, String baseKey, ValueParser parser) {
        ContinuousMappingReader reader = new ContinuousMappingReader(props, baseKey, parser);
        this.points = reader.getPoints();
        this.attrName = reader.getControllingAttributeName();
        this.interpolator = reader.getInterpolator();
    }

    public Properties getProperties(String baseKey) {
        ContinuousMappingWriter writer = new ContinuousMappingWriter(this.points, baseKey, this.attrName, this.interpolator);
        Properties newProps = writer.getProperties();
        return newProps;
    }

    public Class getRangeClass() {
        return this.rangeClass;
    }

    public Class[] getAcceptedDataClasses() {
        Class[] ret = new Class[]{Number.class};
        return ret;
    }

    public String getControllingAttributeName() {
        return this.attrName;
    }

    public void setControllingAttributeName(String attrName, CyNetwork network, boolean preserveMapping) {
        this.attrName = attrName;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    public JPanel getUI(JDialog dialog, CyNetwork network) {
        ContinuousUI ui = new ContinuousUI(dialog, this.defaultObj, network, this);
        return ui;
    }

    public Object calculateRangeValue(Map attrBundle) {
        ContinuousRangeCalculator calc = new ContinuousRangeCalculator(this.points, this.interpolator, attrBundle);
        Object object = calc.calculateRangeValue(this.attrName);
        return object;
    }
}

