/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.calculators.NodeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.DoubleParser;
import giny.model.Node;
import java.util.HashMap;
import java.util.Properties;

public class GenericNodeSizeCalculator
extends NodeCalculator
implements NodeSizeCalculator {
    public GenericNodeSizeCalculator(String name, ObjectMapping m) {
        super(name, m);
        Double d = new Double(0.0);
        Class<?> c = d.getClass();
        if (!c.isAssignableFrom(m.getRangeClass())) {
            String s = "Invalid Calculator: Expected class " + c.toString() + ", got " + m.getRangeClass().toString();
            throw new ClassCastException(s);
        }
    }

    public GenericNodeSizeCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new DoubleParser(), new Double(0.0));
    }

    public double calculateNodeSize(Node node, CyNetwork network) {
        String canonicalName = network.getNodeAttributes().getCanonicalName(node);
        HashMap attrBundle = network.getNodeAttributes().getAttributes(canonicalName);
        Object rangeValue = super.getMapping().calculateRangeValue(attrBundle);
        if (rangeValue != null) {
            return ((Number)rangeValue).doubleValue();
        }
        return -1.0;
    }
}

