/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.calculators.NodeCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.DoubleParser;
import giny.model.Node;
import java.util.HashMap;
import java.util.Properties;

public class GenericNodeFontSizeCalculator
extends NodeCalculator
implements NodeFontSizeCalculator {
    public GenericNodeFontSizeCalculator(String name, ObjectMapping m) {
        super(name, m);
        if (!Number.class.isAssignableFrom(m.getRangeClass())) {
            throw new ClassCastException("Invalid Calculator: Expected class Number, got " + m.getRangeClass().toString());
        }
    }

    public GenericNodeFontSizeCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new DoubleParser(), new Double(12.0));
    }

    public float calculateNodeFontSize(Node node, CyNetwork network) {
        String canonicalName = network.getNodeAttributes().getCanonicalName(node);
        HashMap attrBundle = network.getNodeAttributes().getAttributes(canonicalName);
        Object rangeValue = super.getMapping().calculateRangeValue(attrBundle);
        if (rangeValue != null) {
            return ((Number)rangeValue).floatValue();
        }
        return -1.0f;
    }
}

