/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.calculators.NodeCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.FontParser;
import giny.model.Node;
import java.awt.Font;
import java.util.HashMap;
import java.util.Properties;

public class GenericNodeFontFaceCalculator
extends NodeCalculator
implements NodeFontFaceCalculator {
    public GenericNodeFontFaceCalculator(String name, ObjectMapping m) {
        super(name, m);
        if (!Font.class.isAssignableFrom(m.getRangeClass())) {
            throw new ClassCastException("Invalid Calculator: Expected class Font, got " + m.getRangeClass().toString());
        }
    }

    public GenericNodeFontFaceCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new FontParser(), new Font(null, 0, 12));
    }

    public Font calculateNodeFontFace(Node node, CyNetwork network) {
        String canonicalName = network.getNodeAttributes().getCanonicalName(node);
        HashMap attrBundle = network.getNodeAttributes().getAttributes(canonicalName);
        return (Font)super.getMapping().calculateRangeValue(attrBundle);
    }
}

