/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.LineType;
import cytoscape.visual.calculators.EdgeCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.LineTypeParser;
import giny.model.Edge;
import java.util.HashMap;
import java.util.Properties;

public class GenericEdgeLineTypeCalculator
extends EdgeCalculator
implements EdgeLineTypeCalculator {
    public GenericEdgeLineTypeCalculator(String name, ObjectMapping m) {
        super(name, m);
        Class<?> c = null;
        c = LineType.LINE_1.getClass();
        if (!c.isAssignableFrom(m.getRangeClass())) {
            String s = "Invalid Calculator: Expected class " + c.toString() + ", got " + m.getRangeClass().toString();
            throw new ClassCastException(s);
        }
    }

    public GenericEdgeLineTypeCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new LineTypeParser(), LineType.LINE_1);
    }

    public LineType calculateEdgeLineType(Edge edge, CyNetwork network) {
        String canonicalName = network.getEdgeAttributes().getCanonicalName(edge);
        HashMap attrBundle = network.getEdgeAttributes().getAttributes(canonicalName);
        return (LineType)super.getMapping().calculateRangeValue(attrBundle);
    }
}

