/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.calculators.EdgeCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.DoubleParser;
import giny.model.Edge;
import java.util.HashMap;
import java.util.Properties;

public class GenericEdgeFontSizeCalculator
extends EdgeCalculator
implements EdgeFontSizeCalculator {
    public GenericEdgeFontSizeCalculator(String name, ObjectMapping m) {
        super(name, m);
        if (!Number.class.isAssignableFrom(m.getRangeClass())) {
            throw new ClassCastException("Invalid Calculator: Expected class Font, got " + m.getRangeClass().toString());
        }
    }

    public GenericEdgeFontSizeCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new DoubleParser(), new Double(12.0));
    }

    public float calculateEdgeFontSize(Edge edge, CyNetwork network) {
        String canonicalName = network.getEdgeAttributes().getCanonicalName(edge);
        HashMap attrBundle = network.getEdgeAttributes().getAttributes(canonicalName);
        Object rangeValue = super.getMapping().calculateRangeValue(attrBundle);
        if (rangeValue != null) {
            return ((Number)rangeValue).floatValue();
        }
        return -1.0f;
    }
}

