/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.calculators.EdgeCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.FontParser;
import giny.model.Edge;
import java.awt.Font;
import java.util.HashMap;
import java.util.Properties;

public class GenericEdgeFontFaceCalculator
extends EdgeCalculator
implements EdgeFontFaceCalculator {
    public GenericEdgeFontFaceCalculator(String name, ObjectMapping m) {
        super(name, m);
        if (!Font.class.isAssignableFrom(m.getRangeClass())) {
            throw new ClassCastException("Invalid Calculator: Expected class Font, got " + m.getRangeClass().toString());
        }
    }

    public GenericEdgeFontFaceCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new FontParser(), new Font(null, 0, 12));
    }

    public Font calculateEdgeFontFace(Edge edge, CyNetwork network) {
        String canonicalName = network.getEdgeAttributes().getCanonicalName(edge);
        HashMap attrBundle = network.getEdgeAttributes().getAttributes(canonicalName);
        return (Font)super.getMapping().calculateRangeValue(attrBundle);
    }
}

