/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.calculators.EdgeCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.ColorParser;
import giny.model.Edge;
import java.awt.Color;
import java.util.HashMap;
import java.util.Properties;

public class GenericEdgeColorCalculator
extends EdgeCalculator
implements EdgeColorCalculator {
    public GenericEdgeColorCalculator(String name, ObjectMapping m) {
        super(name, m);
        Color color = new Color(0, 0, 0);
        Class<?> c = color.getClass();
        if (!c.isAssignableFrom(m.getRangeClass())) {
            String s = "Invalid Calculator: Expected class " + c.toString() + ", got " + m.getRangeClass().toString();
            throw new ClassCastException(s);
        }
    }

    public GenericEdgeColorCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new ColorParser(), Color.WHITE);
    }

    public Color calculateEdgeColor(Edge edge, CyNetwork network) {
        String canonicalName = network.getEdgeAttributes().getCanonicalName(edge);
        HashMap attrBundle = network.getEdgeAttributes().getAttributes(canonicalName);
        return (Color)super.getMapping().calculateRangeValue(attrBundle);
    }
}

