/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.Arrow;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.ArrowParser;
import giny.model.Edge;
import java.util.HashMap;
import java.util.Properties;

public class GenericEdgeArrowCalculator
extends EdgeCalculator
implements EdgeArrowCalculator {
    public GenericEdgeArrowCalculator(String name, ObjectMapping m) {
        super(name, m);
        Class<?> c = null;
        c = Arrow.NONE.getClass();
        if (!c.isAssignableFrom(m.getRangeClass())) {
            String s = "Invalid Calculator: Expected class " + c.toString() + ", got " + m.getRangeClass().toString();
            throw new ClassCastException(s);
        }
    }

    public GenericEdgeArrowCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new ArrowParser(), Arrow.NONE);
    }

    public Arrow calculateEdgeArrow(Edge edge, CyNetwork network) {
        String canonicalName = network.getEdgeAttributes().getCanonicalName(edge);
        HashMap attrBundle = network.getEdgeAttributes().getAttributes(canonicalName);
        return (Arrow)super.getMapping().calculateRangeValue(attrBundle);
    }
}

