/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.visual.calculators.Calculator;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class CalculatorFactory {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Calculator newCalculator(String name, Properties calcProps, String baseKey, String intClassName) {
        String errString = "CalculatorFactory: error processing baseKey " + baseKey;
        Class calcClass = Calculator.class;
        Class<?> intClass = null;
        try {
            intClass = Class.forName(intClassName);
        }
        catch (Exception e) {
            System.err.println(errString);
            String s = "    could not get Class object for class name: " + intClassName;
            System.err.println(s);
            return null;
        }
        if (!$assertionsDisabled && intClass == null) {
            throw new AssertionError();
        }
        if (!calcClass.isAssignableFrom(intClass)) {
            System.err.println(errString);
            String s = "    requested interface " + intClassName + " is not a subinterface of Calculator";
            System.err.println(s);
            return null;
        }
        String className = calcProps.getProperty(baseKey + ".class");
        if (className == null) {
            System.err.println(errString);
            String s = "    expected property key '" + baseKey + ".class' identifying class to construct";
            System.err.println(s);
            return null;
        }
        Class<?> realClass = null;
        try {
            realClass = Class.forName(className);
        }
        catch (Exception e) {
            System.err.println(errString);
            String s = "    class not found: " + className;
            System.err.println(s);
            return null;
        }
        if (!$assertionsDisabled && realClass == null) {
            throw new AssertionError();
        }
        if (!intClass.isAssignableFrom(realClass)) {
            System.err.println(errString);
            String s = "    requested class " + className + " does not implement interface " + intClassName;
            System.err.println(s);
            return null;
        }
        Constructor<?> constructor = null;
        try {
            Class[] parameterTypes = new Class[]{String.class, Properties.class, String.class};
            constructor = realClass.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            System.err.println(errString);
            String s = "    no suitable constructor found in class " + className;
            System.err.println(s);
            return null;
        }
        catch (SecurityException se) {
            System.err.println(errString);
            String s = "    could not access constructors for class " + className;
            System.err.println(s);
            return null;
        }
        if (!$assertionsDisabled && constructor == null) {
            throw new AssertionError();
        }
        Calculator calculator = null;
        try {
            Object[] params = new Object[]{name, calcProps, baseKey};
            calculator = (Calculator)constructor.newInstance(params);
        }
        catch (Exception e) {
            System.err.println(errString);
            String s = "    unable to construct an instance of class " + className;
            System.err.println(s);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        return calculator;
    }

    public static Properties getProperties(Calculator c, String baseKey) {
        if (c == null) {
            return null;
        }
        Properties newProps = c.getProperties(baseKey);
        String classKey = baseKey + ".class";
        String className = c.getClass().getName();
        newProps.setProperty(classKey, className);
        return newProps;
    }

    static {
        $assertionsDisabled = !CalculatorFactory.class.desiredAssertionStatus();
    }
}

