/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.data.GraphObjAttributes;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.MappingFactory;
import cytoscape.visual.mappings.ObjectMapping;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractCalculator
implements Calculator {
    protected Vector mappings = new Vector(4, 2);
    protected Vector acceptedDataClasses = new Vector(4, 2);
    protected String name;
    private int dupeCount = 0;
    protected List changeListeners = new Vector(1, 1);
    protected transient ChangeEvent changeEvent;

    public AbstractCalculator(String name, ObjectMapping m) {
        this.name = name;
        this.addMapping(m);
    }

    public void addMapping(ObjectMapping m) {
        this.mappings.add(m);
        this.acceptedDataClasses.add(m.getAcceptedDataClasses());
    }

    public ObjectMapping getMapping() {
        return (ObjectMapping)this.mappings.get(0);
    }

    public Vector getMappings() {
        return this.mappings;
    }

    public ObjectMapping getMapping(int i) {
        return (ObjectMapping)this.mappings.get(i);
    }

    public int getDupeCount() {
        return this.dupeCount;
    }

    public Object clone() throws CloneNotSupportedException {
        int dupeCountIndex;
        AbstractCalculator clonedCalc = (AbstractCalculator)super.clone();
        String dupeFreeName = this.dupeCount != 0 ? ((dupeCountIndex = this.name.lastIndexOf(new Integer(this.dupeCount).toString())) == -1 ? new String(this.name) : this.name.substring(0, dupeCountIndex)) : new String(this.name);
        clonedCalc.name = dupeFreeName;
        clonedCalc.mappings = new Vector(this.mappings.size(), 2);
        for (int i = 0; i < this.mappings.size(); ++i) {
            ObjectMapping m = this.getMapping(i);
            clonedCalc.mappings.add(m.clone());
        }
        ++clonedCalc.dupeCount;
        return clonedCalc;
    }

    public final String toString() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public Properties getProperties(String baseKey) {
        String mapBaseKey = baseKey + ".mapping";
        ObjectMapping m = this.getMapping(0);
        return MappingFactory.getProperties(m, mapBaseKey);
    }

    void updateAttribute(String attrName, CyNetwork network) {
        this.updateAttribute(attrName, network, 0);
    }

    void updateAttribute(String attrName, CyNetwork network, ObjectMapping m) throws IllegalArgumentException {
        int mapIndex = this.mappings.indexOf(m);
        if (mapIndex == -1) {
            throw new IllegalArgumentException(m.getClass().getName() + " " + m.toString() + " is not contained in calculator " + this.toString());
        }
        this.updateAttribute(attrName, network, mapIndex);
    }

    void updateAttribute(String attrName, CyNetwork network, int mIndex) throws ArrayIndexOutOfBoundsException {
        ObjectMapping m = (ObjectMapping)this.mappings.get(mIndex);
        m.setControllingAttributeName(attrName, network, false);
    }

    public abstract JPanel getUI(JDialog var1, CyNetwork var2);

    protected JPanel getUI(GraphObjAttributes attr, JDialog parent, CyNetwork network) {
        return new CalculatorUI(attr, parent, network);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireStateChanged() {
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            ChangeListener listener = (ChangeListener)this.changeListeners.get(i);
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            listener.stateChanged(this.changeEvent);
        }
    }

    protected class CalculatorUI
    extends JPanel {
        protected GridBagGroup myGBG = new GridBagGroup(this);

        public CalculatorUI(GraphObjAttributes attr, JDialog parent, CyNetwork network) {
            Object[] attrNames = attr.getAttributeNames();
            Arrays.sort(attrNames);
            int yPos = 0;
            int i = 0;
            while (i < AbstractCalculator.this.mappings.size()) {
                Object[] validAttr;
                MiscGB.insert(this.myGBG, (Component)new JLabel("Map Attribute:", 4), 0, yPos);
                MiscGB.insert(this.myGBG, Box.createHorizontalStrut(5), 1, yPos);
                ObjectMapping m = (ObjectMapping)AbstractCalculator.this.mappings.get(i);
                Class[] okClass = (Class[])AbstractCalculator.this.acceptedDataClasses.get(i);
                if (okClass != null) {
                    Vector<Object> validAttrV = new Vector<Object>(attrNames.length);
                    block1: for (int j = 0; j < attrNames.length; ++j) {
                        Class attrClass = attr.getClass((String)attrNames[j]);
                        for (int k = 0; k < okClass.length; ++k) {
                            if (!okClass[k].isAssignableFrom(attrClass)) continue;
                            validAttrV.add(attrNames[j]);
                            continue block1;
                        }
                    }
                    validAttr = validAttrV.toArray(new String[0]);
                } else {
                    validAttr = attrNames;
                }
                JComboBox<Object> attrBox = new JComboBox<Object>(validAttr);
                String selectedAttr = m.getControllingAttributeName();
                attrBox.setSelectedIndex(-1);
                attrBox.setSelectedItem(selectedAttr);
                MiscGB.insert(this.myGBG, attrBox, 2, yPos, 1, 1, 1, 0, 2);
                JPanel mapperUI = m.getUI(parent, network);
                attrBox.addItemListener(new AttributeSelectorListener(parent, network, i, ++yPos, mapperUI));
                MiscGB.insert(this.myGBG, mapperUI, 0, yPos, 3, 1, 2, 2, 1);
                ++i;
                ++yPos;
            }
        }

        protected class AttributeSelectorListener
        implements ItemListener {
            private CyNetwork network;
            private int mapIndex;
            private int yPos;
            private JPanel mapperUI;
            private JDialog parent;

            protected AttributeSelectorListener(JDialog parent, CyNetwork network, int mapIndex, int yPos, JPanel mapperUI) {
                this.parent = parent;
                this.network = network;
                this.mapIndex = mapIndex;
                this.yPos = yPos;
                this.mapperUI = mapperUI;
            }

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JComboBox c = (JComboBox)e.getItemSelectable();
                    String attrName = (String)c.getSelectedItem();
                    AbstractCalculator.this.updateAttribute(attrName, this.network, this.mapIndex);
                    CalculatorUI.this.remove(this.mapperUI);
                    this.mapperUI = ((ObjectMapping)((CalculatorUI)CalculatorUI.this).AbstractCalculator.this.mappings.get(this.mapIndex)).getUI(this.parent, this.network);
                    MiscGB.insert(CalculatorUI.this.myGBG, this.mapperUI, 0, this.yPos, 3, 1, 2, 2, 1);
                    this.parent.validate();
                }
            }
        }
    }

    protected class MappingListener
    implements ChangeListener {
        protected MappingListener() {
        }

        public void stateChanged(ChangeEvent e) {
        }
    }
}

