/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import java.util.Vector;

public class VisualStyle
implements Cloneable {
    String name = "default";
    NodeAppearanceCalculator nodeAC;
    EdgeAppearanceCalculator edgeAC;
    GlobalAppearanceCalculator globalAC;
    protected int dupeCount = 0;

    public int getDupeCount() {
        return this.dupeCount;
    }

    public Vector checkConflictingCalculator(Calculator c) {
        Vector<String> conflicts = new Vector<String>();
        conflicts.add(this.name);
        if (c instanceof NodeColorCalculator) {
            if (this.nodeAC.getNodeFillColorCalculator() == c) {
                conflicts.add("Node Fill Color");
            }
            if (this.nodeAC.getNodeBorderColorCalculator() == c) {
                conflicts.add("Node Border Color");
            }
        } else if (c instanceof NodeLineTypeCalculator) {
            if (this.nodeAC.getNodeLineTypeCalculator() == c) {
                conflicts.add("Node Line Type");
            }
        } else if (c instanceof NodeShapeCalculator) {
            if (this.nodeAC.getNodeShapeCalculator() == c) {
                conflicts.add("Node Shape");
            }
        } else if (c instanceof NodeSizeCalculator) {
            if (this.nodeAC.getNodeWidthCalculator() == c) {
                conflicts.add("Node Width");
            }
            if (this.nodeAC.getNodeHeightCalculator() == c) {
                if (this.nodeAC.getNodeSizeLocked()) {
                    conflicts.add("Node Size");
                } else {
                    conflicts.add("Node Height");
                }
            }
        } else if (c instanceof NodeLabelCalculator) {
            if (this.nodeAC.getNodeLabelCalculator() == c) {
                conflicts.add("Node Label");
            }
        } else if (c instanceof NodeToolTipCalculator) {
            if (this.nodeAC.getNodeToolTipCalculator() == c) {
                conflicts.add("Node Tooltip");
            }
        } else if (c instanceof NodeFontFaceCalculator) {
            if (this.nodeAC.getNodeFontFaceCalculator() == c) {
                conflicts.add("Node Font Face");
            }
        } else if (c instanceof NodeFontSizeCalculator) {
            if (this.nodeAC.getNodeFontSizeCalculator() == c) {
                conflicts.add("Node Font Size");
            }
        } else if (c instanceof EdgeColorCalculator) {
            if (this.edgeAC.getEdgeColorCalculator() == c) {
                conflicts.add("Edge Color");
            }
        } else if (c instanceof EdgeLineTypeCalculator) {
            if (this.edgeAC.getEdgeLineTypeCalculator() == c) {
                conflicts.add("Edge Line Type");
            }
        } else if (c instanceof EdgeArrowCalculator) {
            if (this.edgeAC.getEdgeSourceArrowCalculator() == c) {
                conflicts.add("Edge Source Arrow");
            }
            if (this.edgeAC.getEdgeTargetArrowCalculator() == c) {
                conflicts.add("Edge Target Arrow");
            }
        } else if (c instanceof EdgeLabelCalculator) {
            if (this.edgeAC.getEdgeLabelCalculator() == c) {
                conflicts.add("Edge Label");
            }
        } else if (c instanceof EdgeToolTipCalculator) {
            if (this.edgeAC.getEdgeToolTipCalculator() == c) {
                conflicts.add("Edge Tooltip");
            }
        } else if (c instanceof EdgeFontFaceCalculator) {
            if (this.edgeAC.getEdgeFontFaceCalculator() == c) {
                conflicts.add("Edge Font Face");
            }
        } else if (c instanceof EdgeFontSizeCalculator && this.edgeAC.getEdgeFontSizeCalculator() == c) {
            conflicts.add("Edge Font Size");
        }
        return conflicts;
    }

    public Object clone() throws CloneNotSupportedException {
        int dupeCountIndex;
        VisualStyle copy = (VisualStyle)super.clone();
        String dupeFreeName = this.dupeCount != 0 ? ((dupeCountIndex = this.name.lastIndexOf(new Integer(this.dupeCount).toString())) == -1 ? new String(this.name) : this.name.substring(0, dupeCountIndex)) : new String(this.name);
        copy.name = dupeFreeName;
        ++copy.dupeCount;
        copy.nodeAC = (NodeAppearanceCalculator)this.nodeAC.clone();
        copy.edgeAC = (EdgeAppearanceCalculator)this.edgeAC.clone();
        copy.globalAC = (GlobalAppearanceCalculator)this.globalAC.clone();
        return copy;
    }

    public VisualStyle(String name) {
        this.setName(name);
        this.setNodeAppearanceCalculator(new NodeAppearanceCalculator());
        this.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator());
        this.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator());
    }

    public VisualStyle(String name, NodeAppearanceCalculator nac, EdgeAppearanceCalculator eac, GlobalAppearanceCalculator gac) {
        this.setName(name);
        this.setNodeAppearanceCalculator(nac);
        this.setEdgeAppearanceCalculator(eac);
        this.setGlobalAppearanceCalculator(gac);
    }

    public VisualStyle(VisualStyle toCopy) {
        if (toCopy == null) {
            return;
        }
        this.setName(toCopy.getName());
        this.setNodeAppearanceCalculator(new NodeAppearanceCalculator(toCopy.getNodeAppearanceCalculator()));
        this.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator(toCopy.getEdgeAppearanceCalculator()));
        this.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator(toCopy.getGlobalAppearanceCalculator()));
    }

    public VisualStyle(VisualStyle toCopy, String newName) {
        if (newName == null) {
            String s = "Unexpected null name in VisualStyle constructor";
            throw new NullPointerException(s);
        }
        this.setName(newName);
        if (toCopy == null) {
            return;
        }
        this.setNodeAppearanceCalculator(new NodeAppearanceCalculator(toCopy.getNodeAppearanceCalculator()));
        this.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator(toCopy.getEdgeAppearanceCalculator()));
        this.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator(toCopy.getGlobalAppearanceCalculator()));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String setName(String n) {
        String tmp = this.name;
        this.name = n;
        return tmp;
    }

    public NodeAppearanceCalculator getNodeAppearanceCalculator() {
        return this.nodeAC;
    }

    public NodeAppearanceCalculator setNodeAppearanceCalculator(NodeAppearanceCalculator nac) {
        NodeAppearanceCalculator tmp = this.nodeAC;
        this.nodeAC = nac == null ? new NodeAppearanceCalculator() : nac;
        return tmp;
    }

    public EdgeAppearanceCalculator getEdgeAppearanceCalculator() {
        return this.edgeAC;
    }

    public EdgeAppearanceCalculator setEdgeAppearanceCalculator(EdgeAppearanceCalculator eac) {
        EdgeAppearanceCalculator tmp = this.edgeAC;
        this.edgeAC = eac == null ? new EdgeAppearanceCalculator() : eac;
        return tmp;
    }

    public GlobalAppearanceCalculator getGlobalAppearanceCalculator() {
        return this.globalAC;
    }

    public GlobalAppearanceCalculator setGlobalAppearanceCalculator(GlobalAppearanceCalculator gac) {
        GlobalAppearanceCalculator tmp = this.globalAC;
        this.globalAC = gac == null ? new GlobalAppearanceCalculator() : gac;
        return tmp;
    }
}

