/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearance;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.ShapeNodeRealizer;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.VisualStyle;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.Label;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;

public class VisualMappingManager
extends SubjectBase {
    CyNetworkView networkView;
    CalculatorCatalog catalog;
    VisualStyle visualStyle;
    Logger logger;
    NodeAppearance myNodeApp = new NodeAppearance();
    EdgeAppearance myEdgeApp = new EdgeAppearance();
    GlobalAppearance myGlobalApp = new GlobalAppearance();
    private boolean optimizer = true;

    public VisualMappingManager(CyNetworkView networkView, CalculatorCatalog catalog, VisualStyle vs, Logger logger) {
        this.networkView = networkView;
        this.catalog = catalog;
        this.logger = logger;
        this.setVisualStyle(vs);
    }

    public void setNetworkView(CyNetworkView new_view) {
        this.networkView = new_view;
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public CyNetwork getNetwork() {
        return this.networkView.getNetwork();
    }

    public CalculatorCatalog getCalculatorCatalog() {
        return this.catalog;
    }

    public VisualStyle getVisualStyle() {
        return this.visualStyle;
    }

    public VisualStyle setVisualStyle(VisualStyle vs) {
        if (vs != null) {
            VisualStyle tmp = this.visualStyle;
            this.visualStyle = vs;
            this.fireStateChanged();
            return tmp;
        }
        return this.visualStyle;
    }

    public VisualStyle setVisualStyle(String name) {
        VisualStyle vs = this.catalog.getVisualStyle(name);
        if (vs != null) {
            return this.setVisualStyle(vs);
        }
        return this.visualStyle;
    }

    public void applyNodeAppearances() {
        this.applyNodeAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyNodeAppearances(CyNetwork network, CyNetworkView network_view) {
        NodeAppearanceCalculator nodeAppearanceCalculator = this.visualStyle.getNodeAppearanceCalculator();
        Iterator i = network_view.getNodeViewsIterator();
        while (i.hasNext()) {
            int newShape;
            int existingShape;
            NodeView nodeView = (NodeView)i.next();
            Node node = nodeView.getNode();
            nodeAppearanceCalculator.calculateNodeAppearance(this.myNodeApp, node, network);
            if (!this.optimizer) {
                nodeView.setUnselectedPaint(this.myNodeApp.getFillColor());
                nodeView.setBorderPaint(this.myNodeApp.getBorderColor());
                nodeView.setBorder(this.myNodeApp.getBorderLineType().getStroke());
                nodeView.setHeight(this.myNodeApp.getHeight());
                nodeView.setWidth(this.myNodeApp.getWidth());
                nodeView.setShape(ShapeNodeRealizer.getGinyShape(this.myNodeApp.getShape()));
                nodeView.getLabel().setText(this.myNodeApp.getLabel());
                Label label = nodeView.getLabel();
                label.setFont(this.myNodeApp.getFont());
                continue;
            }
            Paint existingUnselectedColor = nodeView.getUnselectedPaint();
            Color newUnselectedColor = this.myNodeApp.getFillColor();
            if (!((Object)newUnselectedColor).equals(existingUnselectedColor)) {
                nodeView.setUnselectedPaint(newUnselectedColor);
            }
            Paint existingBorderPaint = nodeView.getBorderPaint();
            Color newBorderPaint = this.myNodeApp.getBorderColor();
            if (!((Object)newBorderPaint).equals(existingBorderPaint)) {
                nodeView.setBorderPaint(newBorderPaint);
            }
            Stroke existingBorderType = nodeView.getBorder();
            Stroke newBorderType = this.myNodeApp.getBorderLineType().getStroke();
            if (!newBorderType.equals(existingBorderType)) {
                nodeView.setBorder(newBorderType);
            }
            double existingHeight = nodeView.getHeight();
            double newHeight = this.myNodeApp.getHeight();
            double difference = newHeight - existingHeight;
            if (Math.abs(difference) > 0.1) {
                nodeView.setHeight(newHeight);
            }
            double existingWidth = nodeView.getWidth();
            double newWidth = this.myNodeApp.getWidth();
            difference = newWidth - existingWidth;
            if (Math.abs(difference) > 0.1) {
                nodeView.setWidth(newWidth);
            }
            if ((existingShape = nodeView.getShape()) != (newShape = ShapeNodeRealizer.getGinyShape(this.myNodeApp.getShape()))) {
                nodeView.setShape(newShape);
            }
            Label label = nodeView.getLabel();
            String existingLabel = label.getText();
            String newLabel = this.myNodeApp.getLabel();
            if (!newLabel.equals(existingLabel)) {
                label.setText(newLabel);
            }
            Font existingFont = label.getFont();
            Font newFont = this.myNodeApp.getFont();
            if (newFont.equals(existingFont)) continue;
            label.setFont(newFont);
        }
    }

    public void applyEdgeAppearances() {
        this.applyEdgeAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyEdgeAppearances(CyNetwork network, CyNetworkView network_view) {
        EdgeAppearanceCalculator edgeAppearanceCalculator = this.visualStyle.getEdgeAppearanceCalculator();
        Iterator i = network_view.getEdgeViewsIterator();
        while (i.hasNext()) {
            EdgeView edgeView = (EdgeView)i.next();
            Edge edge = edgeView.getEdge();
            edgeAppearanceCalculator.calculateEdgeAppearance(this.myEdgeApp, edge, network);
            if (!this.optimizer) {
                edgeView.setUnselectedPaint(this.myEdgeApp.getColor());
                edgeView.setStroke(this.myEdgeApp.getLineType().getStroke());
                edgeView.setSourceEdgeEnd(this.myEdgeApp.getSourceArrow().getGinyArrow());
                edgeView.setTargetEdgeEnd(this.myEdgeApp.getTargetArrow().getGinyArrow());
                Label label = edgeView.getLabel();
                label.setText(this.myEdgeApp.getLabel());
                label.setFont(this.myEdgeApp.getFont());
                continue;
            }
            Paint existingUnselectedPaint = edgeView.getUnselectedPaint();
            Color newUnselectedPaint = this.myEdgeApp.getColor();
            if (!((Object)newUnselectedPaint).equals(existingUnselectedPaint)) {
                edgeView.setUnselectedPaint(newUnselectedPaint);
            }
            Stroke existingStroke = edgeView.getStroke();
            Stroke newStroke = this.myEdgeApp.getLineType().getStroke();
            if (!newStroke.equals(existingStroke)) {
                edgeView.setStroke(newStroke);
            }
            int existingSourceEdge = edgeView.getSourceEdgeEnd();
            int newSourceEdge = this.myEdgeApp.getSourceArrow().getGinyArrow();
            if (newSourceEdge != existingSourceEdge) {
                edgeView.setSourceEdgeEnd(newSourceEdge);
            }
            int existingTargetEdge = edgeView.getTargetEdgeEnd();
            int newTargetEdge = this.myEdgeApp.getTargetArrow().getGinyArrow();
            if (newTargetEdge != existingTargetEdge) {
                edgeView.setTargetEdgeEnd(newTargetEdge);
            }
            Label label = edgeView.getLabel();
            String existingText = label.getText();
            String newText = this.myEdgeApp.getLabel();
            if (!newText.equals(existingText)) {
                label.setText(newText);
            }
            Font existingFont = label.getFont();
            Font newFont = this.myEdgeApp.getFont();
            if (newFont.equals(existingFont)) continue;
            label.setFont(newFont);
        }
    }

    public void applyGlobalAppearances() {
        this.applyGlobalAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyGlobalAppearances(CyNetwork network, CyNetworkView network_view) {
        GlobalAppearanceCalculator globalAppearanceCalculator = this.visualStyle.getGlobalAppearanceCalculator();
        globalAppearanceCalculator.calculateGlobalAppearance(this.myGlobalApp, network);
        network_view.setBackgroundPaint(this.myGlobalApp.getBackgroundColor());
    }

    public void applyAppearances() {
        Date start = new Date();
        this.applyNodeAppearances();
        this.applyEdgeAppearances();
        this.applyGlobalAppearances();
        Date stop = new Date();
    }

    public void vizmapNode(NodeView nodeView, CyNetworkView network_view) {
        CyNode node = (CyNode)nodeView.getNode();
        NodeAppearanceCalculator nodeAppearanceCalculator = this.visualStyle.getNodeAppearanceCalculator();
        nodeAppearanceCalculator.calculateNodeAppearance(this.myNodeApp, node, network_view.getNetwork());
        if (!this.optimizer) {
            nodeView.setUnselectedPaint(this.myNodeApp.getFillColor());
            nodeView.setBorderPaint(this.myNodeApp.getBorderColor());
            nodeView.setBorder(this.myNodeApp.getBorderLineType().getStroke());
            nodeView.setHeight(this.myNodeApp.getHeight());
            nodeView.setWidth(this.myNodeApp.getWidth());
            nodeView.setShape(ShapeNodeRealizer.getGinyShape(this.myNodeApp.getShape()));
            nodeView.getLabel().setText(this.myNodeApp.getLabel());
            Label label = nodeView.getLabel();
            label.setFont(this.myNodeApp.getFont());
        } else {
            int newShape;
            int existingShape;
            Paint existingUnselectedColor = nodeView.getUnselectedPaint();
            Color newUnselectedColor = this.myNodeApp.getFillColor();
            if (!((Object)newUnselectedColor).equals(existingUnselectedColor)) {
                nodeView.setUnselectedPaint(newUnselectedColor);
            }
            Paint existingBorderPaint = nodeView.getBorderPaint();
            Color newBorderPaint = this.myNodeApp.getBorderColor();
            if (!((Object)newBorderPaint).equals(existingBorderPaint)) {
                nodeView.setBorderPaint(newBorderPaint);
            }
            Stroke existingBorderType = nodeView.getBorder();
            Stroke newBorderType = this.myNodeApp.getBorderLineType().getStroke();
            if (!newBorderType.equals(existingBorderType)) {
                nodeView.setBorder(newBorderType);
            }
            double existingHeight = nodeView.getHeight();
            double newHeight = this.myNodeApp.getHeight();
            double difference = newHeight - existingHeight;
            if (Math.abs(difference) > 0.1) {
                nodeView.setHeight(newHeight);
            }
            double existingWidth = nodeView.getWidth();
            double newWidth = this.myNodeApp.getWidth();
            difference = newWidth - existingWidth;
            if (Math.abs(difference) > 0.1) {
                nodeView.setWidth(newWidth);
            }
            if ((existingShape = nodeView.getShape()) != (newShape = ShapeNodeRealizer.getGinyShape(this.myNodeApp.getShape()))) {
                nodeView.setShape(newShape);
            }
            Label label = nodeView.getLabel();
            String existingLabel = label.getText();
            String newLabel = this.myNodeApp.getLabel();
            if (!newLabel.equals(existingLabel)) {
                label.setText(newLabel);
            }
            Font existingFont = label.getFont();
            Font newFont = this.myNodeApp.getFont();
            if (!newFont.equals(existingFont)) {
                label.setFont(newFont);
            }
        }
    }

    public void vizmapEdge(EdgeView edgeView, CyNetworkView network_view) {
        CyEdge edge = (CyEdge)edgeView.getEdge();
        EdgeAppearanceCalculator edgeAppearanceCalculator = this.visualStyle.getEdgeAppearanceCalculator();
        edgeAppearanceCalculator.calculateEdgeAppearance(this.myEdgeApp, edge, network_view.getNetwork());
        if (!this.optimizer) {
            edgeView.setUnselectedPaint(this.myEdgeApp.getColor());
            edgeView.setStroke(this.myEdgeApp.getLineType().getStroke());
            edgeView.setSourceEdgeEnd(this.myEdgeApp.getSourceArrow().getGinyArrow());
            edgeView.setTargetEdgeEnd(this.myEdgeApp.getTargetArrow().getGinyArrow());
            Label label = edgeView.getLabel();
            label.setText(this.myEdgeApp.getLabel());
            label.setFont(this.myEdgeApp.getFont());
        } else {
            Paint existingUnselectedPaint = edgeView.getUnselectedPaint();
            Color newUnselectedPaint = this.myEdgeApp.getColor();
            if (!((Object)newUnselectedPaint).equals(existingUnselectedPaint)) {
                edgeView.setUnselectedPaint(newUnselectedPaint);
            }
            Stroke existingStroke = edgeView.getStroke();
            Stroke newStroke = this.myEdgeApp.getLineType().getStroke();
            if (!newStroke.equals(existingStroke)) {
                edgeView.setStroke(newStroke);
            }
            int existingSourceEdge = edgeView.getSourceEdgeEnd();
            int newSourceEdge = this.myEdgeApp.getSourceArrow().getGinyArrow();
            if (newSourceEdge != existingSourceEdge) {
                edgeView.setSourceEdgeEnd(newSourceEdge);
            }
            int existingTargetEdge = edgeView.getTargetEdgeEnd();
            int newTargetEdge = this.myEdgeApp.getTargetArrow().getGinyArrow();
            if (newTargetEdge != existingTargetEdge) {
                edgeView.setTargetEdgeEnd(newTargetEdge);
            }
            Label label = edgeView.getLabel();
            String existingText = label.getText();
            String newText = this.myEdgeApp.getLabel();
            if (!newText.equals(existingText)) {
                label.setText(newText);
            }
            Font existingFont = label.getFont();
            Font newFont = this.myEdgeApp.getFont();
            if (!newFont.equals(existingFont)) {
                label.setFont(newFont);
            }
        }
    }
}

