/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.AbstractCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ObjectMapping;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class PropertiesTester {
    public static void main(String[] args) {
        new PropertiesTester();
    }

    public PropertiesTester() {
        CalculatorCatalog catalog = new CalculatorCatalog();
        Properties props = new Properties();
        try {
            String propsFile = "vizmap.props";
            FileInputStream is = new FileInputStream(propsFile);
            props.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        CalculatorIO.loadCalculators(props, catalog);
        Collection nodeColorCalcs = catalog.getNodeColorCalculators();
        System.out.println("nodeColorCalcs.size() = " + nodeColorCalcs.size());
        this.checkCalculator(catalog.getNodeColorCalculator("testDiscrete"));
        this.checkCalculator(catalog.getNodeColorCalculator("testContinuous"));
        System.out.println();
        Collection nodeLineTypeCalcs = catalog.getNodeLineTypeCalculators();
        System.out.println("nodeLineTypeCalcs.size() = " + nodeLineTypeCalcs.size());
        this.checkCalculator(catalog.getNodeLineTypeCalculator("testDiscrete"));
        this.checkCalculator(catalog.getNodeLineTypeCalculator("testContinuous"));
        System.out.println();
        Collection nodeShapeCalcs = catalog.getNodeShapeCalculators();
        System.out.println("nodeShapeCalcs.size() = " + nodeShapeCalcs.size());
        this.checkCalculator(catalog.getNodeShapeCalculator("testDiscrete"));
        this.checkCalculator(catalog.getNodeShapeCalculator("testContinuous"));
        System.out.println();
        Collection nodeSizeCalcs = catalog.getNodeSizeCalculators();
        System.out.println("nodeSizeCalcs.size() = " + nodeSizeCalcs.size());
        this.checkCalculator(catalog.getNodeSizeCalculator("testDiscrete"));
        this.checkCalculator(catalog.getNodeSizeCalculator("testContinuous"));
        System.out.println();
        Collection nodeLabelCalcs = catalog.getNodeLabelCalculators();
        System.out.println("nodeLabelCalcs.size() = " + nodeLabelCalcs.size());
        this.checkCalculator(catalog.getNodeLabelCalculator("testDiscrete"));
        this.checkCalculator(catalog.getNodeLabelCalculator("testContinuous"));
        this.checkCalculator(catalog.getNodeLabelCalculator("testPassThrough"));
        System.out.println();
        Collection nodeToolTipCalcs = catalog.getNodeToolTipCalculators();
        System.out.println("nodeToolTipCalcs.size() = " + nodeToolTipCalcs.size());
        this.checkCalculator(catalog.getNodeToolTipCalculator("testDiscrete"));
        this.checkCalculator(catalog.getNodeToolTipCalculator("testContinuous"));
        System.out.println();
        Collection nodeFontFaceCalcs = catalog.getNodeFontFaceCalculators();
        System.out.println("nodeFontFaceCalcs.size() = " + nodeFontFaceCalcs.size());
        this.checkCalculator(catalog.getNodeFontFaceCalculator("testDiscrete"));
        this.checkCalculator(catalog.getNodeFontFaceCalculator("testContinuous"));
        System.out.println();
        Collection nodeFontSizeCalcs = catalog.getNodeFontSizeCalculators();
        System.out.println("nodeFontSizeCalcs.size() = " + nodeFontSizeCalcs.size());
        this.checkCalculator(catalog.getNodeFontSizeCalculator("testDiscrete"));
        this.checkCalculator(catalog.getNodeFontSizeCalculator("testContinuous"));
        System.out.println();
        Collection edgeColorCalcs = catalog.getEdgeColorCalculators();
        System.out.println("edgeColorCalcs.size() = " + edgeColorCalcs.size());
        this.checkCalculator(catalog.getEdgeColorCalculator("testDiscrete"));
        this.checkCalculator(catalog.getEdgeColorCalculator("testContinuous"));
        System.out.println();
        Collection edgeLineTypeCalcs = catalog.getEdgeLineTypeCalculators();
        System.out.println("edgeLineTypeCalcs.size() = " + edgeLineTypeCalcs.size());
        this.checkCalculator(catalog.getEdgeLineTypeCalculator("testDiscrete"));
        this.checkCalculator(catalog.getEdgeLineTypeCalculator("testContinuous"));
        System.out.println();
        Collection edgeArrowCalcs = catalog.getEdgeArrowCalculators();
        System.out.println("edgeArrowCalcs.size() = " + edgeArrowCalcs.size());
        this.checkCalculator(catalog.getEdgeArrowCalculator("testDiscrete"));
        this.checkCalculator(catalog.getEdgeArrowCalculator("testContinuous"));
        System.out.println();
        Collection edgeLabelCalcs = catalog.getEdgeLabelCalculators();
        System.out.println("edgeLabelCalcs.size() = " + edgeLabelCalcs.size());
        this.checkCalculator(catalog.getEdgeLabelCalculator("testDiscrete"));
        this.checkCalculator(catalog.getEdgeLabelCalculator("testContinuous"));
        this.checkCalculator(catalog.getEdgeLabelCalculator("testPassThrough"));
        System.out.println();
        Collection edgeToolTipCalcs = catalog.getEdgeToolTipCalculators();
        System.out.println("edgeToolTipCalcs.size() = " + edgeToolTipCalcs.size());
        this.checkCalculator(catalog.getEdgeToolTipCalculator("testDiscrete"));
        this.checkCalculator(catalog.getEdgeToolTipCalculator("testContinuous"));
        System.out.println();
        Collection edgeFontFaceCalcs = catalog.getEdgeFontFaceCalculators();
        System.out.println("edgeFontFaceCalcs.size() = " + edgeFontFaceCalcs.size());
        this.checkCalculator(catalog.getEdgeFontFaceCalculator("testDiscrete"));
        this.checkCalculator(catalog.getEdgeFontFaceCalculator("testContinuous"));
        System.out.println();
        Collection edgeFontSizeCalcs = catalog.getEdgeFontSizeCalculators();
        System.out.println("edgeFontSizeCalcs.size() = " + edgeFontSizeCalcs.size());
        this.checkCalculator(catalog.getEdgeFontSizeCalculator("testDiscrete"));
        this.checkCalculator(catalog.getEdgeFontSizeCalculator("testContinuous"));
        System.out.println();
        Iterator vizStyles = catalog.getVisualStyles().iterator();
        while (vizStyles.hasNext()) {
            VisualStyle style = (VisualStyle)vizStyles.next();
            System.out.println(style.getName());
            System.out.println();
        }
    }

    public void checkCalculator(Calculator c) {
        if (c == null) {
            System.out.println("Oops, got a null calculator");
            return;
        }
        AbstractCalculator gc = (AbstractCalculator)c;
        ObjectMapping m = gc.getMapping();
        System.out.println("controller = " + m.getControllingAttributeName());
        System.out.println("Map = " + m);
    }
}

