/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.util.Misc;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.ShapeNodeRealizer;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.CalculatorFactory;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.parsers.ArrowParser;
import cytoscape.visual.parsers.LineTypeParser;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OldStyleCalculatorIO {
    public static String packageHeader = "cytoscape.visual.calculators.";
    public static String calcName = "oldFormat";
    public static boolean loaded = false;
    private static boolean isDone = false;

    public static void checkForCalculators(Properties props, CalculatorCatalog catalog) {
        boolean found = false;
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("node.fillColor.") && !key.startsWith("node.borderColor.") && !key.startsWith("node.selectedColor.") && !key.startsWith("node.borderLinetype.") && !key.startsWith("node.width.") && !key.startsWith("node.height.") && !key.startsWith("node.shape.") && !key.startsWith("edge.color.") && !key.startsWith("background.color.") && !key.startsWith("edge.linetype.") && !key.startsWith("edge.sourceDecoration.") && !key.startsWith("edge.targetDecoration.")) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        final JFrame frame = new JFrame();
        String lineSep = System.getProperty("line.separator");
        StringBuffer message = new StringBuffer();
        message.append("Your cytoscape.props file contains visual mappings specified");
        message.append(" in an old format.").append(lineSep);
        message.append("Cytoscape can automatically convert these mappings into the");
        message.append(" new format.").append(lineSep);
        message.append("Simply specify a name for this group of visual mappings,");
        message.append(" and Cytoscape").append(lineSep);
        message.append("will save them to your visual mappings");
        message.append(" properties file").append(lineSep);
        message.append("(default: vizmap.props in your home directory).");
        message.append(lineSep).append(lineSep);
        message.append("To avoid seeing this message again, please remove all visual");
        message.append(" mapping").append(lineSep);
        message.append("specifications from your cytoscape.props file.");
        message.append(lineSep);
        JTextArea theText = new JTextArea(message.toString());
        theText.setEditable(false);
        theText.setBorder(BorderFactory.createLineBorder(Color.WHITE, 10));
        JLabel nameLabel = new JLabel("enter a name for these mappings");
        String checkedName = catalog.checkVisualStyleName(calcName);
        if (!calcName.equals(checkedName)) {
            calcName = "";
        }
        final JTextField nameEntry = new JTextField(calcName, 20);
        nameEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                calcName = nameEntry.getText();
            }
        });
        final Properties theProps = props;
        final CalculatorCatalog theCatalog = catalog;
        JButton okButton = new JButton("Convert old visual mapppings");
        okButton.setMargin(new Insets(0, 0, 0, 0));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                calcName = nameEntry.getText();
                if (calcName == null || calcName.equals("")) {
                    String s = "You must specify a name for these mappings.";
                    JOptionPane.showMessageDialog(frame, s, "Bad name", 0);
                } else if (OldStyleCalculatorIO.checkName(theCatalog)) {
                    OldStyleCalculatorIO.loadCalculators(theProps, theCatalog);
                    loaded = true;
                    frame.dispose();
                    OldStyleCalculatorIO.setDone();
                } else {
                    String s = "The name you entered is already in use. Please choose another.";
                    JOptionPane.showMessageDialog(frame, s, "Bad name", 0);
                }
            }
        });
        JButton ignoreButton = new JButton("Ignore old visual mappings");
        ignoreButton.setMargin(new Insets(0, 0, 0, 0));
        ignoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                frame.dispose();
                OldStyleCalculatorIO.setDone();
            }
        });
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new FlowLayout());
        namePanel.add(nameLabel);
        namePanel.add(nameEntry);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(okButton);
        buttonPanel.add(ignoreButton);
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(theText);
        contentPane.add(namePanel);
        contentPane.add(buttonPanel);
        frame.getRootPane().setDefaultButton(okButton);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                OldStyleCalculatorIO.setDone();
            }
        });
        frame.pack();
        frame.show();
        while (!isDone) {
        }
    }

    private static void setDone() {
        isDone = true;
    }

    private static boolean checkName(CalculatorCatalog catalog) {
        VisualStyle vs = catalog.getVisualStyle(calcName);
        return vs == null;
    }

    public static void loadCalculators(Properties props, CalculatorCatalog catalog) {
        String colorInterpolator = "LinearNumberToColorInterpolator";
        String numberInterpolator = "LinearNumberToNumberInterpolator";
        String flatInterpolator = "FlatInterpolator";
        String nodeColorName = "nodeColorCalculator." + calcName;
        String nodeColorClass = packageHeader + "GenericNodeColorCalculator";
        String nodeColorIntClass = NodeColorCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(props, catalog, "node.fillColor", nodeColorName, nodeColorClass, nodeColorIntClass, colorInterpolator);
        String nodeColorName2 = nodeColorName + "2";
        OldStyleCalculatorIO.loadCalculator(props, catalog, "node.borderColor", nodeColorName2, nodeColorClass, nodeColorIntClass, colorInterpolator);
        String nodeLineTypeName = "nodeLineTypeCalculator." + calcName;
        String nodeLineTypeClass = packageHeader + "GenericNodeLineTypeCalculator";
        String nodeLineTypeIntClass = NodeLineTypeCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(props, catalog, "node.borderLinetype", nodeLineTypeName, nodeLineTypeClass, nodeLineTypeIntClass, flatInterpolator);
        String nodeSizeName = "nodeSizeCalculator." + calcName;
        String nodeSizeClass = packageHeader + "GenericNodeSizeCalculator";
        String nodeSizeIntClass = NodeSizeCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(props, catalog, "node.width", nodeSizeName, nodeSizeClass, nodeSizeIntClass, numberInterpolator);
        String nodeSizeName2 = nodeSizeName + "2";
        OldStyleCalculatorIO.loadCalculator(props, catalog, "node.height", nodeSizeName2, nodeSizeClass, nodeSizeIntClass, numberInterpolator);
        String nodeShapeName = "nodeShapeCalculator." + calcName;
        String nodeShapeClass = packageHeader + "GenericNodeShapeCalculator";
        String nodeShapeIntClass = NodeShapeCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(props, catalog, "node.shape", nodeShapeName, nodeShapeClass, nodeShapeIntClass, flatInterpolator);
        String edgeColorName = "edgeColorCalculator." + calcName;
        String edgeColorClass = packageHeader + "GenericEdgeColorCalculator";
        String edgeColorIntClass = EdgeColorCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(props, catalog, "edge.color", edgeColorName, edgeColorClass, edgeColorIntClass, colorInterpolator);
        String edgeLineTypeName = "edgeLineTypeCalculator." + calcName;
        String edgeLineTypeClass = packageHeader + "GenericEdgeLineTypeCalculator";
        String edgeLineTypeIntClass = EdgeLineTypeCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(props, catalog, "edge.linetype", edgeLineTypeName, edgeLineTypeClass, edgeLineTypeIntClass, flatInterpolator);
        String edgeSourceName = "edgeArrowCalculator." + calcName;
        String edgeArrowClass = packageHeader + "GenericEdgeArrowCalculator";
        String edgeArrowIntClass = EdgeArrowCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(props, catalog, "edge.sourceDecoration", edgeSourceName, edgeArrowClass, edgeArrowIntClass, flatInterpolator);
        String edgeTargetName = edgeSourceName + "2";
        OldStyleCalculatorIO.loadCalculator(props, catalog, "edge.targetDecoration", edgeTargetName, edgeArrowClass, edgeArrowIntClass, flatInterpolator);
        VisualStyle vs = new VisualStyle(calcName);
        VisualStyle defVS = catalog.getVisualStyle("default");
        if (defVS == null) {
            defVS = new VisualStyle("default");
            catalog.addVisualStyle(defVS);
        }
        OldStyleCalculatorIO.loadNodeAppearanceCalculator(props, catalog, vs, defVS);
        OldStyleCalculatorIO.loadEdgeAppearanceCalculator(props, catalog, vs, defVS);
        OldStyleCalculatorIO.loadGlobalAppearanceCalculator(props, catalog, vs, defVS);
        catalog.addVisualStyle(vs);
    }

    private static void loadCalculator(Properties props, CalculatorCatalog catalog, String oldBaseKey, String newBaseKey, String className, String intClassName, String interpolator) {
        Properties newProps = OldStyleCalculatorIO.getNewProperties(props, oldBaseKey, newBaseKey, className, interpolator);
        if (newProps == null) {
            return;
        }
        String name = newBaseKey.endsWith("2") ? calcName + "2" : calcName;
        Calculator c = CalculatorFactory.newCalculator(name, newProps, newBaseKey, intClassName);
        if (c != null) {
            CalculatorIO.removeDuplicate(c, catalog);
            catalog.addCalculator(c);
        }
    }

    private static Properties getNewProperties(Properties props, String oldBaseKey, String newBaseKey, String className, String interpolator) {
        Properties newProps = null;
        String controller = props.getProperty(oldBaseKey + ".controller");
        if (controller != null) {
            String header = oldBaseKey + "." + controller;
            String type = props.getProperty(header + ".type");
            if (type == null) {
                return null;
            }
            if (type.equals("discrete")) {
                newProps = OldStyleCalculatorIO.translateDiscrete(props, header, newBaseKey);
            } else if (type.equals("continuous")) {
                newProps = OldStyleCalculatorIO.translateContinuous(props, header, newBaseKey);
                newProps.setProperty(newBaseKey + ".mapping.interpolator", interpolator);
            } else {
                return null;
            }
            newProps.setProperty(newBaseKey + ".class", className);
            newProps.setProperty(newBaseKey + ".mapping.controller", controller);
        }
        return newProps;
    }

    private static Properties translateDiscrete(Properties props, String header, String newBaseKey) {
        Properties newProps = new Properties();
        newProps.setProperty(newBaseKey + ".mapping.type", "DiscreteMapping");
        String mapKey = header + ".map.";
        Enumeration<?> eProps = props.propertyNames();
        while (eProps.hasMoreElements()) {
            String key = (String)eProps.nextElement();
            if (!key.startsWith(mapKey)) continue;
            String subKey = key.substring(mapKey.length());
            String newKey = newBaseKey + ".mapping.map." + subKey;
            String value = props.getProperty(key);
            newProps.setProperty(newKey, value);
        }
        return newProps;
    }

    private static Properties translateContinuous(Properties props, String header, String newBaseKey) {
        int numBV;
        Properties newProps = new Properties();
        newProps.setProperty(newBaseKey + ".mapping.type", "ContinuousMapping");
        String bvNumKey = header + ".boundaryvalues";
        String bvNumString = props.getProperty(bvNumKey);
        newProps.setProperty(newBaseKey + ".mapping.boundaryvalues", bvNumString);
        try {
            numBV = Integer.parseInt(bvNumString);
        }
        catch (NumberFormatException e) {
            return null;
        }
        for (int i = 0; i < numBV; ++i) {
            String bvBase = header + ".bv" + Integer.toString(i);
            String newBvBase = newBaseKey + ".mapping.bv" + Integer.toString(i);
            String dvKey = bvBase + ".domainvalue";
            String dvString = props.getProperty(dvKey);
            newProps.setProperty(newBvBase + ".domainvalue", dvString);
            String lString = props.getProperty(bvBase + ".lesser");
            newProps.setProperty(newBvBase + ".lesser", lString);
            String eString = props.getProperty(bvBase + ".equal");
            newProps.setProperty(newBvBase + ".equal", eString);
            String gString = props.getProperty(bvBase + ".greater");
            newProps.setProperty(newBvBase + ".greater", gString);
        }
        return newProps;
    }

    private static void loadNodeAppearanceCalculator(Properties props, CalculatorCatalog catalog, VisualStyle vs, VisualStyle defVS) {
        NodeShapeCalculator nsh;
        NodeSizeCalculator nh;
        NodeSizeCalculator nw;
        NodeLineTypeCalculator nlt;
        NodeColorCalculator nbc;
        NodeColorCalculator nfc;
        String defaultShapeString;
        String defaultHeightString;
        String defaultWidthString;
        String defaultLineTypeString;
        String defaultBorderColorString;
        NodeAppearanceCalculator nac = vs.getNodeAppearanceCalculator();
        NodeAppearanceCalculator defNAC = defVS.getNodeAppearanceCalculator();
        LineTypeParser ltParser = new LineTypeParser();
        nac.setNodeLabelCalculator(defNAC.getNodeLabelCalculator());
        String defaultNodeFillString = props.getProperty("node.fillColor.default");
        if (defaultNodeFillString != null) {
            nac.setDefaultNodeFillColor(Misc.parseRGBText(defaultNodeFillString));
            defNAC.setDefaultNodeFillColor(Misc.parseRGBText(defaultNodeFillString));
        }
        if ((defaultBorderColorString = props.getProperty("node.borderColor.default")) != null) {
            nac.setDefaultNodeBorderColor(Misc.parseRGBText(defaultBorderColorString));
            defNAC.setDefaultNodeBorderColor(Misc.parseRGBText(defaultBorderColorString));
        }
        if ((defaultLineTypeString = props.getProperty("node.borderLinetype.default")) != null) {
            nac.setDefaultNodeLineType(ltParser.parseLineType(defaultLineTypeString));
            defNAC.setDefaultNodeLineType(ltParser.parseLineType(defaultLineTypeString));
        }
        if ((defaultWidthString = props.getProperty("node.width.default")) != null) {
            try {
                double d = Double.parseDouble(defaultWidthString);
                nac.setDefaultNodeWidth(d);
                defNAC.setDefaultNodeWidth(d);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((defaultHeightString = props.getProperty("node.height.default")) != null) {
            try {
                double d = Double.parseDouble(defaultHeightString);
                nac.setDefaultNodeHeight(d);
                defNAC.setDefaultNodeHeight(d);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((defaultShapeString = props.getProperty("node.shape.default")) != null) {
            nac.setDefaultNodeShape(ShapeNodeRealizer.parseNodeShapeText(defaultShapeString));
            defNAC.setDefaultNodeShape(ShapeNodeRealizer.parseNodeShapeText(defaultShapeString));
        }
        if ((nfc = catalog.getNodeColorCalculator(calcName)) != null) {
            nac.setNodeFillColorCalculator(nfc);
            defNAC.setNodeFillColorCalculator(nfc);
        }
        if ((nbc = catalog.getNodeColorCalculator(calcName + "2")) != null) {
            nac.setNodeBorderColorCalculator(nbc);
            defNAC.setNodeBorderColorCalculator(nbc);
        }
        if ((nlt = catalog.getNodeLineTypeCalculator(calcName)) != null) {
            nac.setNodeLineTypeCalculator(nlt);
            defNAC.setNodeLineTypeCalculator(nlt);
        }
        if ((nw = catalog.getNodeSizeCalculator(calcName)) != null) {
            nac.setNodeWidthCalculator(nw);
            defNAC.setNodeWidthCalculator(nw);
        }
        if ((nh = catalog.getNodeSizeCalculator(calcName + "2")) != null) {
            nac.setNodeHeightCalculator(nh);
            defNAC.setNodeHeightCalculator(nh);
        }
        if ((nsh = catalog.getNodeShapeCalculator(calcName)) != null) {
            nac.setNodeShapeCalculator(nsh);
            defNAC.setNodeShapeCalculator(nsh);
        }
    }

    private static void loadEdgeAppearanceCalculator(Properties props, CalculatorCatalog catalog, VisualStyle vs, VisualStyle defVS) {
        EdgeArrowCalculator eta;
        EdgeArrowCalculator esa;
        EdgeLineTypeCalculator elt;
        EdgeColorCalculator ecc;
        String defaultTargetString;
        String defaultSourceString;
        String defaultLineTypeString;
        EdgeAppearanceCalculator eac = vs.getEdgeAppearanceCalculator();
        EdgeAppearanceCalculator defEAC = defVS.getEdgeAppearanceCalculator();
        LineTypeParser ltParser = new LineTypeParser();
        ArrowParser arrowParser = new ArrowParser();
        String defaultColorString = props.getProperty("edge.color.default");
        if (defaultColorString != null) {
            eac.setDefaultEdgeColor(Misc.parseRGBText(defaultColorString));
            defEAC.setDefaultEdgeColor(Misc.parseRGBText(defaultColorString));
        }
        if ((defaultLineTypeString = props.getProperty("edge.linetype.default")) != null) {
            eac.setDefaultEdgeLineType(ltParser.parseLineType(defaultLineTypeString));
            defEAC.setDefaultEdgeLineType(ltParser.parseLineType(defaultLineTypeString));
        }
        if ((defaultSourceString = props.getProperty("edge.sourceDecoration.default")) != null) {
            eac.setDefaultEdgeSourceArrow(arrowParser.parseArrow(defaultSourceString));
            defEAC.setDefaultEdgeSourceArrow(arrowParser.parseArrow(defaultSourceString));
        }
        if ((defaultTargetString = props.getProperty("edge.targetDecoration.default")) != null) {
            eac.setDefaultEdgeTargetArrow(arrowParser.parseArrow(defaultTargetString));
            defEAC.setDefaultEdgeTargetArrow(arrowParser.parseArrow(defaultTargetString));
        }
        if ((ecc = catalog.getEdgeColorCalculator(calcName)) != null) {
            eac.setEdgeColorCalculator(ecc);
            defEAC.setEdgeColorCalculator(ecc);
        }
        if ((elt = catalog.getEdgeLineTypeCalculator(calcName)) != null) {
            eac.setEdgeLineTypeCalculator(elt);
            defEAC.setEdgeLineTypeCalculator(elt);
        }
        if ((esa = catalog.getEdgeArrowCalculator(calcName)) != null) {
            eac.setEdgeSourceArrowCalculator(esa);
            defEAC.setEdgeSourceArrowCalculator(esa);
        }
        if ((eta = catalog.getEdgeArrowCalculator(calcName + "2")) != null) {
            eac.setEdgeTargetArrowCalculator(eta);
            defEAC.setEdgeTargetArrowCalculator(eta);
        }
    }

    private static void loadGlobalAppearanceCalculator(Properties props, CalculatorCatalog catalog, VisualStyle vs, VisualStyle defVS) {
        String selString;
        GlobalAppearanceCalculator gac = vs.getGlobalAppearanceCalculator();
        GlobalAppearanceCalculator defGAC = defVS.getGlobalAppearanceCalculator();
        String backString = props.getProperty("background.color");
        if (backString != null) {
            gac.setDefaultBackgroundColor(Misc.parseRGBText(backString));
            defGAC.setDefaultBackgroundColor(Misc.parseRGBText(backString));
        }
        if ((selString = props.getProperty("node.selectedColor")) != null) {
            gac.setDefaultSloppySelectionColor(Misc.parseRGBText(selString));
            defGAC.setDefaultSloppySelectionColor(Misc.parseRGBText(selString));
        }
    }
}

