/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.data.GraphObjAttributes;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.DoubleParser;
import cytoscape.visual.parsers.FontParser;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.parsers.NodeShapeParser;
import cytoscape.visual.parsers.ObjectToString;
import giny.model.Node;
import java.awt.Color;
import java.awt.Font;
import java.util.Properties;

public class NodeAppearanceCalculator
implements Cloneable {
    Color defaultNodeFillColor = Color.WHITE;
    Color defaultNodeBorderColor = Color.BLACK;
    LineType defaultNodeLineType = LineType.LINE_1;
    byte defaultNodeShape = 0;
    double defaultNodeWidth = 70.0;
    double defaultNodeHeight = 30.0;
    String defaultNodeLabel = "";
    String defaultNodeToolTip = "";
    Font defaultNodeFont = new Font(null, 0, 12);
    private boolean nodeSizeLocked = true;
    public static final String nodeFillColorBypass = "node.fillColor";
    public static final String nodeBorderColorBypass = "node.borderColor";
    public static final String nodeLineTypeBypass = "node.lineType";
    public static final String nodeShapeBypass = "node.shape";
    public static final String nodeWidthBypass = "node.width";
    public static final String nodeHeightBypass = "node.height";
    public static final String nodeLabelBypass = "node.label";
    public static final String nodeToolTipBypass = "node.toolTip";
    public static final String nodeFontBypass = "node.font";
    NodeColorCalculator nodeFillColorCalculator;
    NodeColorCalculator nodeBorderColorCalculator;
    NodeLineTypeCalculator nodeLineTypeCalculator;
    NodeShapeCalculator nodeShapeCalculator;
    NodeSizeCalculator nodeWidthCalculator;
    NodeSizeCalculator nodeHeightCalculator;
    NodeLabelCalculator nodeLabelCalculator;
    NodeToolTipCalculator nodeToolTipCalculator;
    NodeFontFaceCalculator nodeFontFaceCalculator;
    NodeFontSizeCalculator nodeFontSizeCalculator;

    public Object clone() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Error cloning!");
        }
        return copy;
    }

    public NodeAppearanceCalculator() {
    }

    public NodeAppearanceCalculator(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(name, nacProps, baseKey, catalog);
    }

    public NodeAppearanceCalculator(NodeAppearanceCalculator toCopy) {
        if (toCopy == null) {
            return;
        }
        this.setDefaultNodeFillColor(toCopy.getDefaultNodeFillColor());
        this.setDefaultNodeBorderColor(toCopy.getDefaultNodeBorderColor());
        this.setDefaultNodeLineType(toCopy.getDefaultNodeLineType());
        this.setDefaultNodeShape(toCopy.getDefaultNodeShape());
        this.setDefaultNodeWidth(toCopy.getDefaultNodeWidth());
        this.setDefaultNodeHeight(toCopy.getDefaultNodeHeight());
        this.setDefaultNodeLabel(toCopy.getDefaultNodeLabel());
        this.setDefaultNodeToolTip(toCopy.getDefaultNodeToolTip());
        this.setDefaultNodeFont(toCopy.getDefaultNodeFont());
        this.setNodeSizeLocked(toCopy.getNodeSizeLocked());
        this.setNodeFillColorCalculator(toCopy.getNodeFillColorCalculator());
        this.setNodeBorderColorCalculator(toCopy.getNodeBorderColorCalculator());
        this.setNodeLineTypeCalculator(toCopy.getNodeLineTypeCalculator());
        this.setNodeShapeCalculator(toCopy.getNodeShapeCalculator());
        this.setNodeWidthCalculator(toCopy.getNodeWidthCalculator());
        this.setNodeHeightCalculator(toCopy.getNodeHeightCalculator());
        this.setNodeLabelCalculator(toCopy.getNodeLabelCalculator());
        this.setNodeToolTipCalculator(toCopy.getNodeToolTipCalculator());
        this.setNodeFontFaceCalculator(toCopy.getNodeFontFaceCalculator());
        this.setNodeFontSizeCalculator(toCopy.getNodeFontSizeCalculator());
    }

    public NodeAppearance calculateNodeAppearance(Node node, CyNetwork network) {
        NodeAppearance appr = new NodeAppearance();
        this.calculateNodeAppearance(appr, node, network);
        return appr;
    }

    public void calculateNodeAppearance(NodeAppearance appr, Node node, CyNetwork network) {
        appr.setFillColor(this.calculateNodeFillColor(node, network));
        appr.setBorderColor(this.calculateNodeBorderColor(node, network));
        appr.setBorderLineType(this.calculateNodeLineType(node, network));
        appr.setShape(this.calculateNodeShape(node, network));
        if (this.nodeSizeLocked) {
            double size = this.calculateNodeHeight(node, network);
            appr.setWidth(size);
            appr.setHeight(size);
        } else {
            appr.setWidth(this.calculateNodeWidth(node, network));
            appr.setHeight(this.calculateNodeHeight(node, network));
        }
        appr.setLabel(this.calculateNodeLabel(node, network));
        appr.setToolTip(this.calculateNodeToolTip(node, network));
        appr.setFont(this.calculateNodeFont(node, network));
    }

    public Color getDefaultNodeFillColor() {
        return this.defaultNodeFillColor;
    }

    public void setDefaultNodeFillColor(Color c) {
        if (c != null) {
            this.defaultNodeFillColor = c;
        }
    }

    public NodeColorCalculator getNodeFillColorCalculator() {
        return this.nodeFillColorCalculator;
    }

    public void setNodeFillColorCalculator(NodeColorCalculator c) {
        this.nodeFillColorCalculator = c;
    }

    public Color calculateNodeFillColor(Node node, CyNetwork network) {
        Color c;
        String name;
        if (node == null || network == null) {
            return this.defaultNodeFillColor;
        }
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Object attrValue = nodeAttributes.getValue(nodeFillColorBypass, name = nodeAttributes.getCanonicalName(node));
        if (attrValue instanceof Color) {
            return (Color)attrValue;
        }
        if (attrValue instanceof String && (c = new ColorParser().parseColor((String)attrValue)) != null) {
            return c;
        }
        if (this.nodeFillColorCalculator == null) {
            return this.defaultNodeFillColor;
        }
        c = this.nodeFillColorCalculator.calculateNodeColor(node, network);
        return c == null ? this.defaultNodeFillColor : c;
    }

    public Color getDefaultNodeBorderColor() {
        return this.defaultNodeBorderColor;
    }

    public void setDefaultNodeBorderColor(Color c) {
        if (c != null) {
            this.defaultNodeBorderColor = c;
        }
    }

    public NodeColorCalculator getNodeBorderColorCalculator() {
        return this.nodeBorderColorCalculator;
    }

    public void setNodeBorderColorCalculator(NodeColorCalculator c) {
        this.nodeBorderColorCalculator = c;
    }

    public Color calculateNodeBorderColor(Node node, CyNetwork network) {
        Color c;
        String name;
        if (node == null || network == null) {
            return this.defaultNodeBorderColor;
        }
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Object attrValue = nodeAttributes.getValue(nodeBorderColorBypass, name = nodeAttributes.getCanonicalName(node));
        if (attrValue instanceof Color) {
            return (Color)attrValue;
        }
        if (attrValue instanceof String && (c = new ColorParser().parseColor((String)attrValue)) != null) {
            return c;
        }
        if (this.nodeBorderColorCalculator == null) {
            return this.defaultNodeBorderColor;
        }
        c = this.nodeBorderColorCalculator.calculateNodeColor(node, network);
        return c == null ? this.defaultNodeBorderColor : c;
    }

    public LineType getDefaultNodeLineType() {
        return this.defaultNodeLineType;
    }

    public void setDefaultNodeLineType(LineType lt) {
        if (lt != null) {
            this.defaultNodeLineType = lt;
        }
    }

    public NodeLineTypeCalculator getNodeLineTypeCalculator() {
        return this.nodeLineTypeCalculator;
    }

    public void setNodeLineTypeCalculator(NodeLineTypeCalculator c) {
        this.nodeLineTypeCalculator = c;
    }

    public LineType calculateNodeLineType(Node node, CyNetwork network) {
        LineType lt;
        String name;
        if (node == null || network == null) {
            return this.defaultNodeLineType;
        }
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Object attrValue = nodeAttributes.getValue(nodeLineTypeBypass, name = nodeAttributes.getCanonicalName(node));
        if (attrValue instanceof LineType) {
            return (LineType)attrValue;
        }
        if (attrValue instanceof String && (lt = new LineTypeParser().parseLineType((String)attrValue)) != null) {
            return lt;
        }
        if (this.nodeLineTypeCalculator == null) {
            return this.defaultNodeLineType;
        }
        lt = this.nodeLineTypeCalculator.calculateNodeLineType(node, network);
        return lt == null ? this.defaultNodeLineType : lt;
    }

    public byte getDefaultNodeShape() {
        return this.defaultNodeShape;
    }

    public void setDefaultNodeShape(byte s) {
        if (this.isValidShape(s)) {
            this.defaultNodeShape = s;
        }
    }

    public NodeShapeCalculator getNodeShapeCalculator() {
        return this.nodeShapeCalculator;
    }

    public void setNodeShapeCalculator(NodeShapeCalculator c) {
        this.nodeShapeCalculator = c;
    }

    public byte calculateNodeShape(Node node, CyNetwork network) {
        Byte b;
        byte s;
        byte s2;
        String name;
        if (node == null || network == null) {
            return this.defaultNodeShape;
        }
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Object attrValue = nodeAttributes.getValue(nodeShapeBypass, name = nodeAttributes.getCanonicalName(node));
        if (attrValue instanceof Byte && this.isValidShape(s2 = ((Byte)attrValue).byteValue())) {
            return s2;
        }
        if (attrValue instanceof String && this.isValidShape(s = (b = new NodeShapeParser().parseNodeShape((String)attrValue)).byteValue())) {
            return s;
        }
        if (this.nodeShapeCalculator == null) {
            return this.defaultNodeShape;
        }
        s2 = this.nodeShapeCalculator.calculateNodeShape(node, network);
        return this.isValidShape(s2) ? s2 : this.defaultNodeShape;
    }

    public boolean isValidShape(byte shape) {
        if (shape == 0) {
            return true;
        }
        if (shape == 1) {
            return true;
        }
        if (shape == 2) {
            return true;
        }
        if (shape == 3) {
            return true;
        }
        if (shape == 4) {
            return true;
        }
        if (shape == 5) {
            return true;
        }
        if (shape == 6) {
            return true;
        }
        if (shape == 7) {
            return true;
        }
        if (shape == 8) {
            return true;
        }
        if (shape == 9) {
            return true;
        }
        return shape == 10;
    }

    public double getDefaultNodeWidth() {
        return this.defaultNodeWidth;
    }

    public void setDefaultNodeWidth(double d) {
        if (d > 0.0) {
            this.defaultNodeWidth = d;
        }
    }

    public NodeSizeCalculator getNodeWidthCalculator() {
        return this.nodeWidthCalculator;
    }

    public void setNodeWidthCalculator(NodeSizeCalculator c) {
        this.nodeWidthCalculator = c;
    }

    public double calculateNodeWidth(Node node, CyNetwork network) {
        Double dObj;
        String name;
        if (node == null || network == null) {
            return this.defaultNodeWidth;
        }
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Object attrValue = nodeAttributes.getValue(nodeWidthBypass, name = nodeAttributes.getCanonicalName(node));
        if (attrValue instanceof Double) {
            return (Double)attrValue;
        }
        if (attrValue instanceof String && (dObj = new DoubleParser().parseDouble((String)attrValue)) != null) {
            return dObj;
        }
        if (this.nodeWidthCalculator == null) {
            return this.defaultNodeWidth;
        }
        double d = this.nodeWidthCalculator.calculateNodeSize(node, network);
        return d <= 0.0 ? this.defaultNodeWidth : d;
    }

    public double getDefaultNodeHeight() {
        return this.defaultNodeHeight;
    }

    public void setDefaultNodeHeight(double d) {
        if (d > 0.0) {
            this.defaultNodeHeight = d;
        }
    }

    public NodeSizeCalculator getNodeHeightCalculator() {
        return this.nodeHeightCalculator;
    }

    public void setNodeHeightCalculator(NodeSizeCalculator c) {
        this.nodeHeightCalculator = c;
    }

    public double calculateNodeHeight(Node node, CyNetwork network) {
        Double dObj;
        String name;
        if (node == null || network == null) {
            return this.defaultNodeHeight;
        }
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Object attrValue = nodeAttributes.getValue(nodeHeightBypass, name = nodeAttributes.getCanonicalName(node));
        if (attrValue instanceof Double) {
            return (Double)attrValue;
        }
        if (attrValue instanceof String && (dObj = new DoubleParser().parseDouble((String)attrValue)) != null) {
            return dObj;
        }
        if (this.nodeHeightCalculator == null) {
            return this.defaultNodeHeight;
        }
        double d = this.nodeHeightCalculator.calculateNodeSize(node, network);
        return d <= 0.0 ? this.defaultNodeHeight : d;
    }

    public boolean getNodeSizeLocked() {
        return this.nodeSizeLocked;
    }

    public void setNodeSizeLocked(boolean b) {
        this.nodeSizeLocked = b;
    }

    public String getDefaultNodeLabel() {
        return this.defaultNodeLabel;
    }

    public void setDefaultNodeLabel(String s) {
        if (s != null) {
            this.defaultNodeLabel = s;
        }
    }

    public NodeLabelCalculator getNodeLabelCalculator() {
        return this.nodeLabelCalculator;
    }

    public void setNodeLabelCalculator(NodeLabelCalculator c) {
        this.nodeLabelCalculator = c;
    }

    public String calculateNodeLabel(Node node, CyNetwork network) {
        String name;
        if (node == null || network == null) {
            return this.defaultNodeLabel;
        }
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Object attrValue = nodeAttributes.getValue(nodeLabelBypass, name = nodeAttributes.getCanonicalName(node));
        if (attrValue instanceof String) {
            return (String)attrValue;
        }
        if (this.nodeLabelCalculator == null) {
            return this.defaultNodeLabel;
        }
        String s = this.nodeLabelCalculator.calculateNodeLabel(node, network);
        return s == null ? this.defaultNodeLabel : s;
    }

    public String getDefaultNodeToolTip() {
        return this.defaultNodeToolTip;
    }

    public void setDefaultNodeToolTip(String s) {
        if (s != null) {
            this.defaultNodeToolTip = s;
        }
    }

    public NodeToolTipCalculator getNodeToolTipCalculator() {
        return this.nodeToolTipCalculator;
    }

    public void setNodeToolTipCalculator(NodeToolTipCalculator c) {
        this.nodeToolTipCalculator = c;
    }

    public String calculateNodeToolTip(Node node, CyNetwork network) {
        String name;
        if (node == null || network == null) {
            return this.defaultNodeToolTip;
        }
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Object attrValue = nodeAttributes.getValue(nodeToolTipBypass, name = nodeAttributes.getCanonicalName(node));
        if (attrValue instanceof String) {
            return (String)attrValue;
        }
        if (this.nodeToolTipCalculator == null) {
            return this.defaultNodeToolTip;
        }
        String s = this.nodeToolTipCalculator.calculateNodeToolTip(node, network);
        return s == null ? this.defaultNodeToolTip : s;
    }

    public Font getDefaultNodeFont() {
        return this.defaultNodeFont;
    }

    public void setDefaultNodeFont(Font f) {
        if (f != null) {
            this.defaultNodeFont = f;
        }
    }

    public Font getDefaultNodeFontFace() {
        return this.defaultNodeFont;
    }

    public void setDefaultNodeFontFace(Font f) {
        if (f != null) {
            float fontSize = this.defaultNodeFont.getSize2D();
            this.defaultNodeFont = f.deriveFont(fontSize);
        }
    }

    public NodeFontFaceCalculator getNodeFontFaceCalculator() {
        return this.nodeFontFaceCalculator;
    }

    public void setNodeFontFaceCalculator(NodeFontFaceCalculator c) {
        this.nodeFontFaceCalculator = c;
    }

    public float getDefaultNodeFontSize() {
        return this.defaultNodeFont.getSize2D();
    }

    public void setDefaultNodeFontSize(float f) {
        if ((double)f > 0.0) {
            this.defaultNodeFont = this.defaultNodeFont.deriveFont(f);
        }
    }

    public NodeFontSizeCalculator getNodeFontSizeCalculator() {
        return this.nodeFontSizeCalculator;
    }

    public void setNodeFontSizeCalculator(NodeFontSizeCalculator c) {
        this.nodeFontSizeCalculator = c;
    }

    public Font calculateNodeFont(Node node, CyNetwork network) {
        Font f;
        String name;
        if (node == null || network == null) {
            return this.defaultNodeFont;
        }
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Object attrValue = nodeAttributes.getValue(nodeFontBypass, name = nodeAttributes.getCanonicalName(node));
        if (attrValue instanceof Font) {
            return (Font)attrValue;
        }
        if (attrValue instanceof String && (f = new FontParser().parseFont((String)attrValue)) != null) {
            return f;
        }
        if (this.nodeFontFaceCalculator == null && this.nodeFontSizeCalculator == null) {
            return this.defaultNodeFont;
        }
        float defaultSize = this.defaultNodeFont.getSize2D();
        if (this.nodeFontFaceCalculator == null) {
            float fontSize = this.nodeFontSizeCalculator.calculateNodeFontSize(node, network);
            if (fontSize == -1.0f) {
                fontSize = defaultSize;
            }
            return (f = this.defaultNodeFont.deriveFont(fontSize)) == null ? this.defaultNodeFont : f;
        }
        Font g = this.nodeFontFaceCalculator.calculateNodeFontFace(node, network);
        if (g == null) {
            g = this.defaultNodeFont;
        }
        if (this.nodeFontSizeCalculator == null) {
            f = g.deriveFont(defaultSize);
        } else {
            float fontSize = this.nodeFontSizeCalculator.calculateNodeFontSize(node, network);
            if (fontSize == -1.0f) {
                fontSize = defaultSize;
            }
            f = g.deriveFont(fontSize);
        }
        return f == null ? this.defaultNodeFont : f;
    }

    public String getDescription() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("NodeAppearanceCalculator:" + lineSep);
        sb.append("defaultNodeFillColor = ").append(this.defaultNodeFillColor).append(lineSep);
        sb.append("defaultNodeBorderColor = ").append(this.defaultNodeBorderColor).append(lineSep);
        String nodeLineTypeText = ObjectToString.getStringValue(this.defaultNodeLineType);
        sb.append("defaultNodeLineType = ").append(nodeLineTypeText).append(lineSep);
        Byte nodeShapeByte = new Byte(this.defaultNodeShape);
        String nodeShapeText = ObjectToString.getStringValue(nodeShapeByte);
        sb.append("defaultNodeShape = ").append(nodeShapeText).append(lineSep);
        sb.append("defaultNodeWidth = ").append(this.defaultNodeWidth).append(lineSep);
        sb.append("defaultNodeHeight = ").append(this.defaultNodeHeight).append(lineSep);
        sb.append("defaultNodeLabel = ").append(this.defaultNodeLabel).append(lineSep);
        sb.append("defaultNodeToolTip = ").append(this.defaultNodeToolTip).append(lineSep);
        sb.append("defaultNodeFont = ").append(this.defaultNodeFont).append(lineSep);
        sb.append("nodeSizeLocked = ").append(this.nodeSizeLocked).append(lineSep);
        sb.append("nodeFillColorCalculator = ").append(this.nodeFillColorCalculator).append(lineSep);
        sb.append("nodeBorderColorCalculator = ").append(this.nodeBorderColorCalculator).append(lineSep);
        sb.append("nodeLineTypeCalculator = ").append(this.nodeLineTypeCalculator).append(lineSep);
        sb.append("nodeShapeCalculator = ").append(this.nodeShapeCalculator).append(lineSep);
        sb.append("nodeWidthCalculator = ").append(this.nodeWidthCalculator).append(lineSep);
        sb.append("nodeHeightCalculator = ").append(this.nodeHeightCalculator).append(lineSep);
        sb.append("nodeLabelCalculator = ").append(this.nodeLabelCalculator).append(lineSep);
        sb.append("nodeToolTipCalculator = ").append(this.nodeToolTipCalculator).append(lineSep);
        sb.append("nodeFontFaceCalculator = ").append(this.nodeFontFaceCalculator).append(lineSep);
        sb.append("nodeFontSizeCalculator = ").append(this.nodeFontSizeCalculator).append(lineSep);
        return sb.toString();
    }

    public void applyProperties(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        Font f;
        double d;
        Double dObj;
        byte b;
        Byte bObj;
        LineType lt;
        Color c;
        String value = null;
        value = nacProps.getProperty(baseKey + ".defaultNodeFillColor");
        if (value != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultNodeFillColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeBorderColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultNodeBorderColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeLineType")) != null && (lt = new LineTypeParser().parseLineType(value)) != null) {
            this.setDefaultNodeLineType(lt);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeShape")) != null && (bObj = new NodeShapeParser().parseNodeShape(value)) != null && this.isValidShape(b = bObj.byteValue())) {
            this.setDefaultNodeShape(b);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeWidth")) != null && (dObj = new DoubleParser().parseDouble(value)) != null && (d = dObj.doubleValue()) > 0.0) {
            this.setDefaultNodeWidth(d);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeHeight")) != null && (dObj = new DoubleParser().parseDouble(value)) != null && (d = dObj.doubleValue()) > 0.0) {
            this.setDefaultNodeHeight(d);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeLabel")) != null) {
            this.setDefaultNodeLabel(value);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeToolTip")) != null) {
            this.setDefaultNodeToolTip(value);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeFont")) != null && (f = new FontParser().parseFont(value)) != null) {
            this.setDefaultNodeFont(f);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeSizeLocked")) != null) {
            boolean b2 = Boolean.valueOf(value);
            this.setNodeSizeLocked(b2);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeFillColorCalculator")) != null && !value.equals("null") && (c = catalog.getNodeColorCalculator(value)) != null) {
            this.setNodeFillColorCalculator(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeBorderColorCalculator")) != null && !value.equals("null") && (c = catalog.getNodeColorCalculator(value)) != null) {
            this.setNodeBorderColorCalculator(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeLineTypeCalculator")) != null && !value.equals("null") && (c = catalog.getNodeLineTypeCalculator(value)) != null) {
            this.setNodeLineTypeCalculator(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeShapeCalculator")) != null && !value.equals("null") && (c = catalog.getNodeShapeCalculator(value)) != null) {
            this.setNodeShapeCalculator(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeWidthCalculator")) != null && !value.equals("null") && (c = catalog.getNodeSizeCalculator(value)) != null) {
            this.setNodeWidthCalculator(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeHeightCalculator")) != null && !value.equals("null") && (c = catalog.getNodeSizeCalculator(value)) != null) {
            this.setNodeHeightCalculator(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeLabelCalculator")) != null && !value.equals("null") && (c = catalog.getNodeLabelCalculator(value)) != null) {
            this.setNodeLabelCalculator(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeToolTipCalculator")) != null && !value.equals("null") && (c = catalog.getNodeToolTipCalculator(value)) != null) {
            this.setNodeToolTipCalculator(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeFontFaceCalculator")) != null && !value.equals("null") && (c = catalog.getNodeFontFaceCalculator(value)) != null) {
            this.setNodeFontFaceCalculator(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".nodeFontSizeCalculator")) != null && !value.equals("null") && (c = catalog.getNodeFontSizeCalculator(value)) != null) {
            this.setNodeFontSizeCalculator(c);
        }
    }

    public Properties getProperties(String baseKey) {
        String key = null;
        String value = null;
        Properties newProps = new Properties();
        key = baseKey + ".defaultNodeFillColor";
        value = ObjectToString.getStringValue(this.getDefaultNodeFillColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeBorderColor";
        value = ObjectToString.getStringValue(this.getDefaultNodeBorderColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeLineType";
        value = ObjectToString.getStringValue(this.getDefaultNodeLineType());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeShape";
        Byte nodeShapeByte = new Byte(this.getDefaultNodeShape());
        value = ObjectToString.getStringValue(nodeShapeByte);
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeWidth";
        Double nodeWidthDouble = new Double(this.getDefaultNodeWidth());
        value = ObjectToString.getStringValue(nodeWidthDouble);
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeHeight";
        Double nodeHeightDouble = new Double(this.getDefaultNodeHeight());
        value = ObjectToString.getStringValue(nodeHeightDouble);
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeLabel";
        value = ObjectToString.getStringValue(this.getDefaultNodeLabel());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeToolTip";
        value = ObjectToString.getStringValue(this.getDefaultNodeToolTip());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeFont";
        value = ObjectToString.getStringValue(this.getDefaultNodeFont());
        newProps.setProperty(key, value);
        key = baseKey + ".nodeSizeLocked";
        value = Boolean.toString(this.getNodeSizeLocked());
        newProps.setProperty(key, value);
        Calculator c = null;
        key = baseKey + ".nodeFillColorCalculator";
        c = this.getNodeFillColorCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".nodeBorderColorCalculator";
        c = this.getNodeBorderColorCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".nodeLineTypeCalculator";
        c = this.getNodeLineTypeCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".nodeShapeCalculator";
        c = this.getNodeShapeCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".nodeWidthCalculator";
        c = this.getNodeWidthCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".nodeHeightCalculator";
        c = this.getNodeHeightCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".nodeLabelCalculator";
        c = this.getNodeLabelCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".nodeToolTipCalculator";
        c = this.getNodeToolTipCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".nodeFontFaceCalculator";
        c = this.getNodeFontFaceCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".nodeFontSizeCalculator";
        c = this.getNodeFontSizeCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        return newProps;
    }
}

