/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.GlobalAppearance;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.ObjectToString;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Properties;

public class GlobalAppearanceCalculator
extends SubjectBase
implements Cloneable {
    Color defaultBackgroundColor = Color.WHITE;
    Color defaultSloppySelectionColor = Color.GRAY;
    private ArrayList changeListeners = new ArrayList();

    public Object clone() throws CloneNotSupportedException {
        Object copy = null;
        copy = super.clone();
        return copy;
    }

    public GlobalAppearanceCalculator() {
    }

    public GlobalAppearanceCalculator(GlobalAppearanceCalculator toCopy) {
        if (toCopy == null) {
            return;
        }
        this.setDefaultBackgroundColor(toCopy.getDefaultBackgroundColor());
        this.setDefaultSloppySelectionColor(toCopy.getDefaultSloppySelectionColor());
    }

    public GlobalAppearanceCalculator(String name, Properties gProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(name, gProps, baseKey, catalog);
    }

    public GlobalAppearance calculateGlobalAppearance(CyNetwork network) {
        GlobalAppearance appr = new GlobalAppearance();
        this.calculateGlobalAppearance(appr, network);
        return appr;
    }

    public void calculateGlobalAppearance(GlobalAppearance appr, CyNetwork network) {
        appr.setBackgroundColor(this.calculateBackgroundColor(network));
        appr.setSloppySelectionColor(this.calculateSloppySelectionColor(network));
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        if (c != null) {
            this.defaultBackgroundColor = c;
            this.fireStateChanged();
        }
    }

    public Color calculateBackgroundColor(CyNetwork network) {
        return this.defaultBackgroundColor;
    }

    public Color getDefaultSloppySelectionColor() {
        return this.defaultSloppySelectionColor;
    }

    public void setDefaultSloppySelectionColor(Color c) {
        if (c != null) {
            this.fireStateChanged();
            this.defaultSloppySelectionColor = c;
        }
    }

    public Color calculateSloppySelectionColor(CyNetwork network) {
        return this.defaultSloppySelectionColor;
    }

    public String getDescription() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("GlobalAppearanceCalculator:" + lineSep);
        sb.append("defaultBackgroundColor = ");
        sb.append(this.defaultBackgroundColor).append(lineSep);
        sb.append("defaultSloppySelectionColor = ");
        sb.append(this.defaultSloppySelectionColor).append(lineSep);
        return sb.toString();
    }

    public void applyProperties(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        Color c;
        String value = null;
        value = nacProps.getProperty(baseKey + ".defaultBackgroundColor");
        if (value != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultBackgroundColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultSloppySelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultSloppySelectionColor(c);
        }
    }

    public Properties getProperties(String baseKey) {
        String key = null;
        String value = null;
        Properties newProps = new Properties();
        key = baseKey + ".defaultBackgroundColor";
        value = ObjectToString.getStringValue(this.getDefaultBackgroundColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultSloppySelectionColor";
        value = ObjectToString.getStringValue(this.getDefaultSloppySelectionColor());
        newProps.setProperty(key, value);
        return newProps;
    }
}

