/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.LineType;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.parsers.ArrowParser;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.FontParser;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.parsers.ObjectToString;
import giny.model.Edge;
import java.awt.Color;
import java.awt.Font;
import java.util.Properties;

public class EdgeAppearanceCalculator
implements Cloneable {
    Color defaultEdgeColor = Color.BLACK;
    LineType defaultEdgeLineType = LineType.LINE_1;
    Arrow defaultEdgeSourceArrow = Arrow.NONE;
    Arrow defaultEdgeTargetArrow = Arrow.NONE;
    String defaultEdgeLabel = "";
    String defaultEdgeToolTip = "";
    Font defaultEdgeFont = new Font(null, 0, 10);
    EdgeColorCalculator edgeColorCalculator;
    EdgeLineTypeCalculator edgeLineTypeCalculator;
    EdgeArrowCalculator edgeSourceArrowCalculator;
    EdgeArrowCalculator edgeTargetArrowCalculator;
    EdgeLabelCalculator edgeLabelCalculator;
    EdgeToolTipCalculator edgeToolTipCalculator;
    EdgeFontFaceCalculator edgeFontFaceCalculator;
    EdgeFontSizeCalculator edgeFontSizeCalculator;

    public Object clone() throws CloneNotSupportedException {
        Object copy = null;
        copy = super.clone();
        return copy;
    }

    public EdgeAppearanceCalculator() {
    }

    public EdgeAppearanceCalculator(EdgeAppearanceCalculator toCopy) {
        if (toCopy == null) {
            return;
        }
        this.setDefaultEdgeColor(toCopy.getDefaultEdgeColor());
        this.setDefaultEdgeLineType(toCopy.getDefaultEdgeLineType());
        this.setDefaultEdgeSourceArrow(toCopy.getDefaultEdgeSourceArrow());
        this.setDefaultEdgeTargetArrow(toCopy.getDefaultEdgeTargetArrow());
        this.setDefaultEdgeLabel(toCopy.getDefaultEdgeLabel());
        this.setDefaultEdgeToolTip(toCopy.getDefaultEdgeToolTip());
        this.setDefaultEdgeFont(toCopy.getDefaultEdgeFont());
        this.setEdgeColorCalculator(toCopy.getEdgeColorCalculator());
        this.setEdgeLineTypeCalculator(toCopy.getEdgeLineTypeCalculator());
        this.setEdgeSourceArrowCalculator(toCopy.getEdgeSourceArrowCalculator());
        this.setEdgeTargetArrowCalculator(toCopy.getEdgeTargetArrowCalculator());
        this.setEdgeLabelCalculator(toCopy.getEdgeLabelCalculator());
        this.setEdgeToolTipCalculator(toCopy.getEdgeToolTipCalculator());
        this.setEdgeFontFaceCalculator(toCopy.getEdgeFontFaceCalculator());
        this.setEdgeFontSizeCalculator(toCopy.getEdgeFontSizeCalculator());
    }

    public EdgeAppearanceCalculator(String name, Properties eacProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(name, eacProps, baseKey, catalog);
    }

    public EdgeAppearance calculateEdgeAppearance(Edge edge, CyNetwork network) {
        EdgeAppearance appr = new EdgeAppearance();
        this.calculateEdgeAppearance(appr, edge, network);
        return appr;
    }

    public void calculateEdgeAppearance(EdgeAppearance appr, Edge edge, CyNetwork network) {
        appr.setColor(this.calculateEdgeColor(edge, network));
        appr.setLineType(this.calculateEdgeLineType(edge, network));
        appr.setSourceArrow(this.calculateEdgeSourceArrow(edge, network));
        appr.setTargetArrow(this.calculateEdgeTargetArrow(edge, network));
        appr.setLabel(this.calculateEdgeLabel(edge, network));
        appr.setToolTip(this.calculateEdgeToolTip(edge, network));
        appr.setFont(this.calculateEdgeFont(edge, network));
    }

    public Color getDefaultEdgeColor() {
        return this.defaultEdgeColor;
    }

    public void setDefaultEdgeColor(Color c) {
        if (c != null) {
            this.defaultEdgeColor = c;
        }
    }

    public EdgeColorCalculator getEdgeColorCalculator() {
        return this.edgeColorCalculator;
    }

    public void setEdgeColorCalculator(EdgeColorCalculator c) {
        this.edgeColorCalculator = c;
    }

    public Color calculateEdgeColor(Edge edge, CyNetwork network) {
        if (edge == null || network == null || this.edgeColorCalculator == null) {
            return this.defaultEdgeColor;
        }
        Color c = this.edgeColorCalculator.calculateEdgeColor(edge, network);
        return c == null ? this.defaultEdgeColor : c;
    }

    public LineType getDefaultEdgeLineType() {
        return this.defaultEdgeLineType;
    }

    public void setDefaultEdgeLineType(LineType lt) {
        if (lt != null) {
            this.defaultEdgeLineType = lt;
        }
    }

    public EdgeLineTypeCalculator getEdgeLineTypeCalculator() {
        return this.edgeLineTypeCalculator;
    }

    public void setEdgeLineTypeCalculator(EdgeLineTypeCalculator c) {
        this.edgeLineTypeCalculator = c;
    }

    public LineType calculateEdgeLineType(Edge edge, CyNetwork network) {
        if (edge == null || network == null || this.edgeLineTypeCalculator == null) {
            return this.defaultEdgeLineType;
        }
        LineType lt = this.edgeLineTypeCalculator.calculateEdgeLineType(edge, network);
        return lt == null ? this.defaultEdgeLineType : lt;
    }

    public Arrow getDefaultEdgeSourceArrow() {
        return this.defaultEdgeSourceArrow;
    }

    public void setDefaultEdgeSourceArrow(Arrow a) {
        if (a != null) {
            this.defaultEdgeSourceArrow = a;
        }
    }

    public EdgeArrowCalculator getEdgeSourceArrowCalculator() {
        return this.edgeSourceArrowCalculator;
    }

    public void setEdgeSourceArrowCalculator(EdgeArrowCalculator c) {
        this.edgeSourceArrowCalculator = c;
    }

    public Arrow calculateEdgeSourceArrow(Edge edge, CyNetwork network) {
        if (edge == null || network == null || this.edgeSourceArrowCalculator == null) {
            return this.defaultEdgeSourceArrow;
        }
        Arrow a = this.edgeSourceArrowCalculator.calculateEdgeArrow(edge, network);
        return a == null ? this.defaultEdgeSourceArrow : a;
    }

    public Arrow getDefaultEdgeTargetArrow() {
        return this.defaultEdgeTargetArrow;
    }

    public void setDefaultEdgeTargetArrow(Arrow a) {
        if (a != null) {
            this.defaultEdgeTargetArrow = a;
        }
    }

    public EdgeArrowCalculator getEdgeTargetArrowCalculator() {
        return this.edgeTargetArrowCalculator;
    }

    public void setEdgeTargetArrowCalculator(EdgeArrowCalculator c) {
        this.edgeTargetArrowCalculator = c;
    }

    public Arrow calculateEdgeTargetArrow(Edge edge, CyNetwork network) {
        if (edge == null || network == null || this.edgeTargetArrowCalculator == null) {
            return this.defaultEdgeTargetArrow;
        }
        Arrow a = this.edgeTargetArrowCalculator.calculateEdgeArrow(edge, network);
        return a == null ? this.defaultEdgeTargetArrow : a;
    }

    public String getDefaultEdgeLabel() {
        return this.defaultEdgeLabel;
    }

    public void setDefaultEdgeLabel(String s) {
        if (s != null) {
            this.defaultEdgeLabel = s;
        }
    }

    public EdgeLabelCalculator getEdgeLabelCalculator() {
        return this.edgeLabelCalculator;
    }

    public void setEdgeLabelCalculator(EdgeLabelCalculator c) {
        this.edgeLabelCalculator = c;
    }

    public String calculateEdgeLabel(Edge edge, CyNetwork network) {
        if (edge == null || network == null || this.edgeLabelCalculator == null) {
            return this.defaultEdgeLabel;
        }
        String s = this.edgeLabelCalculator.calculateEdgeLabel(edge, network);
        return s == null ? this.defaultEdgeLabel : s;
    }

    public Font getDefaultEdgeFont() {
        return this.defaultEdgeFont;
    }

    public void setDefaultEdgeFont(Font f) {
        if (f != null) {
            this.defaultEdgeFont = f;
        }
    }

    public Font getDefaultEdgeFontFace() {
        return this.defaultEdgeFont;
    }

    public void setDefaultEdgeFontFace(Font f) {
        if (f != null) {
            float fontSize = this.defaultEdgeFont.getSize2D();
            this.defaultEdgeFont = f.deriveFont(fontSize);
        }
    }

    public EdgeFontFaceCalculator getEdgeFontFaceCalculator() {
        return this.edgeFontFaceCalculator;
    }

    public void setEdgeFontFaceCalculator(EdgeFontFaceCalculator c) {
        this.edgeFontFaceCalculator = c;
    }

    public float getDefaultEdgeFontSize() {
        return this.defaultEdgeFont.getSize2D();
    }

    public void setDefaultEdgeFontSize(float f) {
        if ((double)f > 0.0) {
            this.defaultEdgeFont = this.defaultEdgeFont.deriveFont(f);
        }
    }

    public EdgeFontSizeCalculator getEdgeFontSizeCalculator() {
        return this.edgeFontSizeCalculator;
    }

    public void setEdgeFontSizeCalculator(EdgeFontSizeCalculator c) {
        this.edgeFontSizeCalculator = c;
    }

    public Font calculateEdgeFont(Edge edge, CyNetwork network) {
        Font f;
        if (edge == null || network == null || this.edgeFontFaceCalculator == null && this.edgeFontSizeCalculator == null) {
            return this.defaultEdgeFont;
        }
        float defaultSize = this.defaultEdgeFont.getSize2D();
        if (this.edgeFontFaceCalculator == null) {
            Font f2;
            float fontSize = this.edgeFontSizeCalculator.calculateEdgeFontSize(edge, network);
            if (fontSize == -1.0f) {
                fontSize = defaultSize;
            }
            return (f2 = this.defaultEdgeFont.deriveFont(fontSize)) == null ? this.defaultEdgeFont : f2;
        }
        Font g = this.edgeFontFaceCalculator.calculateEdgeFontFace(edge, network);
        if (g == null) {
            g = this.defaultEdgeFont;
        }
        if (this.edgeFontSizeCalculator == null) {
            f = g.deriveFont(defaultSize);
        } else {
            float fontSize = this.edgeFontSizeCalculator.calculateEdgeFontSize(edge, network);
            if (fontSize == -1.0f) {
                fontSize = defaultSize;
            }
            f = g.deriveFont(fontSize);
        }
        return f == null ? this.defaultEdgeFont : f;
    }

    public String getDefaultEdgeToolTip() {
        return this.defaultEdgeToolTip;
    }

    public void setDefaultEdgeToolTip(String s) {
        if (s != null) {
            this.defaultEdgeToolTip = s;
        }
    }

    public EdgeToolTipCalculator getEdgeToolTipCalculator() {
        return this.edgeToolTipCalculator;
    }

    public void setEdgeToolTipCalculator(EdgeToolTipCalculator c) {
        this.edgeToolTipCalculator = c;
    }

    public String calculateEdgeToolTip(Edge edge, CyNetwork network) {
        if (edge == null || network == null || this.edgeToolTipCalculator == null) {
            return this.defaultEdgeToolTip;
        }
        String s = this.edgeToolTipCalculator.calculateEdgeToolTip(edge, network);
        return s == null ? this.defaultEdgeToolTip : s;
    }

    public String getDescription() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("EdgeAppearanceCalculator:" + lineSep);
        sb.append("defaultEdgeColor = ").append(this.defaultEdgeColor).append(lineSep);
        String edgeLineTypeText = ObjectToString.getStringValue(this.defaultEdgeLineType);
        sb.append("defaultEdgeLineType = ").append(edgeLineTypeText).append(lineSep);
        String sourceArrowText = ObjectToString.getStringValue(this.defaultEdgeSourceArrow);
        sb.append("defaultEdgeSourceArrow = ").append(sourceArrowText).append(lineSep);
        String targetArrowText = ObjectToString.getStringValue(this.defaultEdgeTargetArrow);
        sb.append("defaultEdgeTargetArrow = ").append(targetArrowText).append(lineSep);
        sb.append("defaultEdgeLabel = ").append(this.defaultEdgeLabel).append(lineSep);
        sb.append("defaultEdgeToolTip = ").append(this.defaultEdgeToolTip).append(lineSep);
        sb.append("defaultEdgeFont = ").append(this.defaultEdgeFont).append(lineSep);
        sb.append("edgeColorCalculator = ").append(this.edgeColorCalculator).append(lineSep);
        sb.append("edgeLineTypeCalculator = ").append(this.edgeLineTypeCalculator).append(lineSep);
        sb.append("edgeSourceArrowCalculator = ").append(this.edgeSourceArrowCalculator).append(lineSep);
        sb.append("edgeTargetArrowCalculator = ").append(this.edgeTargetArrowCalculator).append(lineSep);
        sb.append("edgeLabelCalculator = ").append(this.edgeLabelCalculator).append(lineSep);
        sb.append("edgeToolTipCalculator = ").append(this.edgeToolTipCalculator).append(lineSep);
        sb.append("edgeFontFaceCalculator = ").append(this.edgeFontFaceCalculator).append(lineSep);
        sb.append("edgeFontSizeCalculator = ").append(this.edgeFontSizeCalculator).append(lineSep);
        return sb.toString();
    }

    public void applyProperties(String name, Properties eacProps, String baseKey, CalculatorCatalog catalog) {
        Font f;
        Arrow a;
        LineType lt;
        Object c;
        String value = null;
        value = eacProps.getProperty(baseKey + ".defaultEdgeColor");
        if (value != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultEdgeColor((Color)c);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeLineType")) != null && (lt = new LineTypeParser().parseLineType(value)) != null) {
            this.setDefaultEdgeLineType(lt);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeSourceArrow")) != null && (a = new ArrowParser().parseArrow(value)) != null) {
            this.setDefaultEdgeSourceArrow(a);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeTargetArrow")) != null && (a = new ArrowParser().parseArrow(value)) != null) {
            this.setDefaultEdgeTargetArrow(a);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeLabel")) != null) {
            this.setDefaultEdgeLabel(value);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeToolTip")) != null) {
            this.setDefaultEdgeToolTip(value);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeFont")) != null && (f = new FontParser().parseFont(value)) != null) {
            this.setDefaultEdgeFont(f);
        }
        if ((value = eacProps.getProperty(baseKey + ".edgeColorCalculator")) != null && !value.equals("null") && (c = catalog.getEdgeColorCalculator(value)) != null) {
            this.setEdgeColorCalculator((EdgeColorCalculator)c);
        }
        if ((value = eacProps.getProperty(baseKey + ".edgeLineTypeCalculator")) != null && !value.equals("null") && (c = catalog.getEdgeLineTypeCalculator(value)) != null) {
            this.setEdgeLineTypeCalculator((EdgeLineTypeCalculator)c);
        }
        if ((value = eacProps.getProperty(baseKey + ".edgeSourceArrowCalculator")) != null && !value.equals("null") && (c = catalog.getEdgeArrowCalculator(value)) != null) {
            this.setEdgeSourceArrowCalculator((EdgeArrowCalculator)c);
        }
        if ((value = eacProps.getProperty(baseKey + ".edgeTargetArrowCalculator")) != null && !value.equals("null") && (c = catalog.getEdgeArrowCalculator(value)) != null) {
            this.setEdgeTargetArrowCalculator((EdgeArrowCalculator)c);
        }
        if ((value = eacProps.getProperty(baseKey + ".edgeLabelCalculator")) != null && !value.equals("null") && (c = catalog.getEdgeLabelCalculator(value)) != null) {
            this.setEdgeLabelCalculator((EdgeLabelCalculator)c);
        }
        if ((value = eacProps.getProperty(baseKey + ".edgeToolTipCalculator")) != null && !value.equals("null") && (c = catalog.getEdgeToolTipCalculator(value)) != null) {
            this.setEdgeToolTipCalculator((EdgeToolTipCalculator)c);
        }
        if ((value = eacProps.getProperty(baseKey + ".edgeFontFaceCalculator")) != null && !value.equals("null") && (c = catalog.getEdgeFontFaceCalculator(value)) != null) {
            this.setEdgeFontFaceCalculator((EdgeFontFaceCalculator)c);
        }
        if ((value = eacProps.getProperty(baseKey + ".edgeFontSizeCalculator")) != null && !value.equals("null") && (c = catalog.getEdgeFontSizeCalculator(value)) != null) {
            this.setEdgeFontSizeCalculator((EdgeFontSizeCalculator)c);
        }
    }

    public Properties getProperties(String baseKey) {
        String key = null;
        String value = null;
        Properties newProps = new Properties();
        key = baseKey + ".defaultEdgeColor";
        value = ObjectToString.getStringValue(this.getDefaultEdgeColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeLineType";
        value = ObjectToString.getStringValue(this.getDefaultEdgeLineType());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeSourceArrow";
        value = ObjectToString.getStringValue(this.getDefaultEdgeSourceArrow());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeTargetArrow";
        value = ObjectToString.getStringValue(this.getDefaultEdgeTargetArrow());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeLabel";
        value = ObjectToString.getStringValue(this.getDefaultEdgeLabel());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeToolTip";
        value = ObjectToString.getStringValue(this.getDefaultEdgeToolTip());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeFont";
        value = ObjectToString.getStringValue(this.getDefaultEdgeFont());
        newProps.setProperty(key, value);
        Calculator c = null;
        key = baseKey + ".edgeColorCalculator";
        c = this.getEdgeColorCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".edgeLineTypeCalculator";
        c = this.getEdgeLineTypeCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".edgeSourceArrowCalculator";
        c = this.getEdgeSourceArrowCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".edgeTargetArrowCalculator";
        c = this.getEdgeTargetArrowCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".edgeLabelCalculator";
        c = this.getEdgeLabelCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".edgeToolTipCalculator";
        c = this.getEdgeToolTipCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".edgeFontFaceCalculator";
        c = this.getEdgeFontFaceCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        key = baseKey + ".edgeFontSizeCalculator";
        c = this.getEdgeFontSizeCalculator();
        value = c == null ? "null" : ((Object)c).toString();
        newProps.setProperty(key, value);
        return newProps;
    }
}

