/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.CalculatorFactory;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CalculatorIO {
    public static final String dirHeader = "cytoscape.visual.calculators.";
    public static final String nodeColorBaseKey = "nodeColorCalculator";
    public static final String nodeColorClassName = "NodeColorCalculator";
    public static final String nodeLineTypeBaseKey = "nodeLineTypeCalculator";
    public static final String nodeLineTypeClassName = "NodeLineTypeCalculator";
    public static final String nodeShapeBaseKey = "nodeShapeCalculator";
    public static final String nodeShapeClassName = "NodeShapeCalculator";
    public static final String nodeSizeBaseKey = "nodeSizeCalculator";
    public static final String nodeSizeClassName = "NodeSizeCalculator";
    public static final String nodeLabelBaseKey = "nodeLabelCalculator";
    public static final String nodeLabelClassName = "NodeLabelCalculator";
    public static final String nodeToolTipBaseKey = "nodeToolTipCalculator";
    public static final String nodeToolTipClassName = "NodeToolTipCalculator";
    public static final String nodeFontFaceBaseKey = "nodeFontFaceCalculator";
    public static final String nodeFontFaceClassName = "NodeFontFaceCalculator";
    public static final String nodeFontSizeBaseKey = "nodeFontSizeCalculator";
    public static final String nodeFontSizeClassName = "NodeFontSizeCalculator";
    public static final String edgeColorBaseKey = "edgeColorCalculator";
    public static final String edgeColorClassName = "EdgeColorCalculator";
    public static final String edgeLineTypeBaseKey = "edgeLineTypeCalculator";
    public static final String edgeLineTypeClassName = "EdgeLineTypeCalculator";
    public static final String edgeArrowBaseKey = "edgeArrowCalculator";
    public static final String edgeArrowClassName = "EdgeArrowCalculator";
    public static final String edgeLabelBaseKey = "edgeLabelCalculator";
    public static final String edgeLabelClassName = "EdgeLabelCalculator";
    public static final String edgeToolTipBaseKey = "edgeToolTipCalculator";
    public static final String edgeToolTipClassName = "EdgeToolTipCalculator";
    public static final String edgeFontFaceBaseKey = "edgeFontFaceCalculator";
    public static final String edgeFontFaceClassName = "EdgeFontFaceCalculator";
    public static final String edgeFontSizeBaseKey = "edgeFontSizeCalculator";
    public static final String edgeFontSizeClassName = "EdgeFontSizeCalculator";
    public static final String nodeAppearanceBaseKey = "nodeAppearanceCalculator";
    public static final String edgeAppearanceBaseKey = "edgeAppearanceCalculator";
    public static final String globalAppearanceBaseKey = "globalAppearanceCalculator";

    public static void storeCatalog(CalculatorCatalog catalog, File outFile) {
        try {
            String theLine;
            String lineSep = System.getProperty("line.separator");
            StringBuffer header = new StringBuffer();
            header.append("This file specifies visual mappings for Cytoscape");
            header.append(" and has been automatically generated.").append(lineSep);
            header.append("# WARNING: any changes you make to this file while");
            header.append(" Cytoscape is running may be overwritten.").append(lineSep);
            header.append("# Any changes may make these visual mappings unreadable.");
            header.append(lineSep);
            header.append("# Please make sure you know what you are doing before");
            header.append(" modifying this file by hand.").append(lineSep);
            BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
            Properties props = CalculatorIO.getProperties(catalog);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            props.store(buffer, header.toString());
            String theData = buffer.toString();
            BufferedReader reader = new BufferedReader(new StringReader(theData));
            ArrayList<String> headerLines = new ArrayList<String>();
            ArrayList<String> lines = new ArrayList<String>();
            String oneLine = reader.readLine();
            while (oneLine != null) {
                if (oneLine.startsWith("#")) {
                    headerLines.add(oneLine);
                } else {
                    lines.add(oneLine);
                }
                oneLine = reader.readLine();
            }
            Collections.sort(lines);
            Iterator li = headerLines.iterator();
            while (li.hasNext()) {
                theLine = (String)li.next();
                writer.write(theLine, 0, theLine.length());
                writer.newLine();
            }
            li = lines.iterator();
            while (li.hasNext()) {
                theLine = (String)li.next();
                writer.write(theLine, 0, theLine.length());
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getProperties(CalculatorCatalog catalog) {
        Properties newProps = new Properties();
        CalculatorIO.addProperties(newProps, catalog.getNodeColorCalculators(), nodeColorBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getNodeLineTypeCalculators(), nodeLineTypeBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getNodeShapeCalculators(), nodeShapeBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getNodeSizeCalculators(), nodeSizeBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getNodeLabelCalculators(), nodeLabelBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getNodeToolTipCalculators(), nodeToolTipBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getNodeFontFaceCalculators(), nodeFontFaceBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getNodeFontSizeCalculators(), nodeFontSizeBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getEdgeColorCalculators(), edgeColorBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getEdgeLineTypeCalculators(), edgeLineTypeBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getEdgeArrowCalculators(), edgeArrowBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getEdgeLabelCalculators(), edgeLabelBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getEdgeToolTipCalculators(), edgeToolTipBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getEdgeFontFaceCalculators(), edgeFontFaceBaseKey);
        CalculatorIO.addProperties(newProps, catalog.getEdgeFontSizeCalculators(), edgeFontSizeBaseKey);
        Set visualStyleNames = catalog.getVisualStyleNames();
        Iterator i = visualStyleNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            VisualStyle vs = catalog.getVisualStyle(name);
            try {
                Properties styleProps = new Properties();
                NodeAppearanceCalculator nac = vs.getNodeAppearanceCalculator();
                String nacBaseKey = "nodeAppearanceCalculator." + name;
                Properties nacProps = nac.getProperties(nacBaseKey);
                styleProps.putAll((Map<?, ?>)nacProps);
                EdgeAppearanceCalculator eac = vs.getEdgeAppearanceCalculator();
                String eacBaseKey = "edgeAppearanceCalculator." + name;
                Properties eacProps = eac.getProperties(eacBaseKey);
                styleProps.putAll((Map<?, ?>)eacProps);
                GlobalAppearanceCalculator gac = vs.getGlobalAppearanceCalculator();
                String gacBaseKey = "globalAppearanceCalculator." + name;
                Properties gacProps = gac.getProperties(gacBaseKey);
                styleProps.putAll((Map<?, ?>)gacProps);
                newProps.putAll((Map<?, ?>)styleProps);
            }
            catch (Exception e) {
                String s = "Exception while saving visual style " + name;
                System.err.println(s);
                System.err.println(e.getMessage());
            }
        }
        return newProps;
    }

    private static void addProperties(Properties newProps, Collection calcs, String baseKey) {
        Iterator i = calcs.iterator();
        while (i.hasNext()) {
            Calculator c = (Calculator)i.next();
            if (c == null) continue;
            String calcBaseKey = baseKey + "." + ((Object)c).toString();
            try {
                Properties props = CalculatorFactory.getProperties(c, calcBaseKey);
                newProps.putAll((Map<?, ?>)props);
            }
            catch (Exception e) {
                System.err.println("Exception while saving " + calcBaseKey);
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void loadCalculators(Properties props, CalculatorCatalog catalog) {
        CalculatorIO.loadCalculators(props, catalog, true);
    }

    public static void loadCalculators(Properties props, CalculatorCatalog catalog, boolean overWrite) {
        VisualStyle vs;
        String baseKey;
        String name;
        HashMap nodeColorNames = new HashMap();
        HashMap nodeLineTypeNames = new HashMap();
        HashMap nodeShapeNames = new HashMap();
        HashMap nodeSizeNames = new HashMap();
        HashMap nodeLabelNames = new HashMap();
        HashMap nodeToolTipNames = new HashMap();
        HashMap nodeFontFaceNames = new HashMap();
        HashMap nodeFontSizeNames = new HashMap();
        HashMap edgeColorNames = new HashMap();
        HashMap edgeLineTypeNames = new HashMap();
        HashMap edgeArrowNames = new HashMap();
        HashMap edgeLabelNames = new HashMap();
        HashMap edgeToolTipNames = new HashMap();
        HashMap edgeFontFaceNames = new HashMap();
        HashMap edgeFontSizeNames = new HashMap();
        HashMap nacNames = new HashMap();
        HashMap eacNames = new HashMap();
        HashMap gacNames = new HashMap();
        Enumeration<?> eI = props.propertyNames();
        while (eI.hasMoreElements()) {
            String key = (String)eI.nextElement();
            if (key.startsWith("nodeColorCalculator.")) {
                CalculatorIO.storeKey(key, props, nodeColorNames);
                continue;
            }
            if (key.startsWith("nodeLineTypeCalculator.")) {
                CalculatorIO.storeKey(key, props, nodeLineTypeNames);
                continue;
            }
            if (key.startsWith("nodeShapeCalculator.")) {
                CalculatorIO.storeKey(key, props, nodeShapeNames);
                continue;
            }
            if (key.startsWith("nodeSizeCalculator.")) {
                CalculatorIO.storeKey(key, props, nodeSizeNames);
                continue;
            }
            if (key.startsWith("nodeLabelCalculator.")) {
                CalculatorIO.storeKey(key, props, nodeLabelNames);
                continue;
            }
            if (key.startsWith("nodeToolTipCalculator.")) {
                CalculatorIO.storeKey(key, props, nodeToolTipNames);
                continue;
            }
            if (key.startsWith("nodeFontFaceCalculator.")) {
                CalculatorIO.storeKey(key, props, nodeFontFaceNames);
                continue;
            }
            if (key.startsWith("nodeFontSizeCalculator.")) {
                CalculatorIO.storeKey(key, props, nodeFontSizeNames);
                continue;
            }
            if (key.startsWith("edgeColorCalculator.")) {
                CalculatorIO.storeKey(key, props, edgeColorNames);
                continue;
            }
            if (key.startsWith("edgeLineTypeCalculator.")) {
                CalculatorIO.storeKey(key, props, edgeLineTypeNames);
                continue;
            }
            if (key.startsWith("edgeArrowCalculator.")) {
                CalculatorIO.storeKey(key, props, edgeArrowNames);
                continue;
            }
            if (key.startsWith("edgeLabelCalculator.")) {
                CalculatorIO.storeKey(key, props, edgeLabelNames);
                continue;
            }
            if (key.startsWith("edgeToolTipCalculator.")) {
                CalculatorIO.storeKey(key, props, edgeToolTipNames);
                continue;
            }
            if (key.startsWith("edgeFontFaceCalculator.")) {
                CalculatorIO.storeKey(key, props, edgeFontFaceNames);
                continue;
            }
            if (key.startsWith("edgeFontSizeCalculator.")) {
                CalculatorIO.storeKey(key, props, edgeFontSizeNames);
                continue;
            }
            if (key.startsWith("nodeAppearanceCalculator.")) {
                CalculatorIO.storeKey(key, props, nacNames);
                continue;
            }
            if (key.startsWith("edgeAppearanceCalculator.")) {
                CalculatorIO.storeKey(key, props, eacNames);
                continue;
            }
            if (!key.startsWith("globalAppearanceCalculator.")) continue;
            CalculatorIO.storeKey(key, props, gacNames);
        }
        CalculatorIO.handleCalculators(nodeColorNames, catalog, overWrite, nodeColorBaseKey, nodeColorClassName);
        CalculatorIO.handleCalculators(nodeLineTypeNames, catalog, overWrite, nodeLineTypeBaseKey, nodeLineTypeClassName);
        CalculatorIO.handleCalculators(nodeShapeNames, catalog, overWrite, nodeShapeBaseKey, nodeShapeClassName);
        CalculatorIO.handleCalculators(nodeSizeNames, catalog, overWrite, nodeSizeBaseKey, nodeSizeClassName);
        CalculatorIO.handleCalculators(nodeLabelNames, catalog, overWrite, nodeLabelBaseKey, nodeLabelClassName);
        CalculatorIO.handleCalculators(nodeToolTipNames, catalog, overWrite, nodeToolTipBaseKey, nodeToolTipClassName);
        CalculatorIO.handleCalculators(nodeFontFaceNames, catalog, overWrite, nodeFontFaceBaseKey, nodeFontFaceClassName);
        CalculatorIO.handleCalculators(nodeFontSizeNames, catalog, overWrite, nodeFontSizeBaseKey, nodeFontSizeClassName);
        CalculatorIO.handleCalculators(edgeColorNames, catalog, overWrite, edgeColorBaseKey, edgeColorClassName);
        CalculatorIO.handleCalculators(edgeLineTypeNames, catalog, overWrite, edgeLineTypeBaseKey, edgeLineTypeClassName);
        CalculatorIO.handleCalculators(edgeArrowNames, catalog, overWrite, edgeArrowBaseKey, edgeArrowClassName);
        CalculatorIO.handleCalculators(edgeLabelNames, catalog, overWrite, edgeLabelBaseKey, edgeLabelClassName);
        CalculatorIO.handleCalculators(edgeToolTipNames, catalog, overWrite, edgeToolTipBaseKey, edgeToolTipClassName);
        CalculatorIO.handleCalculators(edgeFontFaceNames, catalog, overWrite, edgeFontFaceBaseKey, edgeFontFaceClassName);
        CalculatorIO.handleCalculators(edgeFontSizeNames, catalog, overWrite, edgeFontSizeBaseKey, edgeFontSizeClassName);
        HashMap<String, VisualStyle> visualStyles = new HashMap<String, VisualStyle>();
        Iterator<Object> si = nacNames.keySet().iterator();
        while (si.hasNext()) {
            name = (String)si.next();
            Properties nacProps = (Properties)nacNames.get(name);
            baseKey = "nodeAppearanceCalculator." + name;
            NodeAppearanceCalculator nac = new NodeAppearanceCalculator(name, nacProps, baseKey, catalog);
            vs = (VisualStyle)visualStyles.get(name);
            if (vs == null) {
                vs = new VisualStyle(name);
                visualStyles.put(name, vs);
            }
            vs.setNodeAppearanceCalculator(nac);
        }
        si = eacNames.keySet().iterator();
        while (si.hasNext()) {
            name = (String)si.next();
            Properties eacProps = (Properties)eacNames.get(name);
            baseKey = "edgeAppearanceCalculator." + name;
            EdgeAppearanceCalculator eac = new EdgeAppearanceCalculator(name, eacProps, baseKey, catalog);
            vs = (VisualStyle)visualStyles.get(name);
            if (vs == null) {
                vs = new VisualStyle(name);
                visualStyles.put(name, vs);
            }
            vs.setEdgeAppearanceCalculator(eac);
        }
        si = gacNames.keySet().iterator();
        while (si.hasNext()) {
            name = (String)si.next();
            Properties gacProps = (Properties)gacNames.get(name);
            baseKey = "globalAppearanceCalculator." + name;
            GlobalAppearanceCalculator gac = new GlobalAppearanceCalculator(name, gacProps, baseKey, catalog);
            vs = (VisualStyle)visualStyles.get(name);
            if (vs == null) {
                vs = new VisualStyle(name);
                visualStyles.put(name, vs);
            }
            vs.setGlobalAppearanceCalculator(gac);
        }
        si = visualStyles.values().iterator();
        while (si.hasNext()) {
            VisualStyle vs2 = (VisualStyle)si.next();
            catalog.addVisualStyle(vs2);
        }
    }

    private static void storeKey(String key, Properties props, Map m) {
        String name = CalculatorIO.extractName(key);
        if (name != null) {
            Properties calcProps = (Properties)m.get(name);
            if (calcProps == null) {
                calcProps = new Properties();
                m.put(name, calcProps);
            }
            calcProps.setProperty(key, props.getProperty(key));
        }
    }

    private static String extractName(String key) {
        if (key == null) {
            return null;
        }
        int dot1 = key.indexOf(".");
        if (dot1 == -1 || dot1 >= key.length() - 1) {
            return null;
        }
        int dot2 = key.indexOf(".", dot1 + 1);
        if (dot2 == -1) {
            return null;
        }
        return key.substring(dot1 + 1, dot2);
    }

    private static void handleCalculators(Map nameMap, CalculatorCatalog catalog, boolean overWrite, String baseKey, String className) {
        Iterator si = nameMap.keySet().iterator();
        while (si.hasNext()) {
            String intClassName;
            String keyString;
            Properties calcProps;
            String name = (String)si.next();
            Calculator c = CalculatorFactory.newCalculator(name, calcProps = (Properties)nameMap.get(name), keyString = baseKey + "." + name, intClassName = dirHeader + className);
            if (c == null) continue;
            if (overWrite) {
                CalculatorIO.removeDuplicate(c, catalog);
            } else {
                CalculatorIO.renameAsNeeded(c, catalog);
            }
            catalog.addCalculator(c);
        }
    }

    public static void removeDuplicate(Calculator c, CalculatorCatalog catalog) {
        String name = ((Object)c).toString();
        if (c instanceof NodeColorCalculator) {
            catalog.removeNodeColorCalculator(name);
        } else if (c instanceof NodeLineTypeCalculator) {
            catalog.removeNodeLineTypeCalculator(name);
        } else if (c instanceof NodeShapeCalculator) {
            catalog.removeNodeShapeCalculator(name);
        } else if (c instanceof NodeSizeCalculator) {
            catalog.removeNodeSizeCalculator(name);
        } else if (c instanceof NodeLabelCalculator) {
            catalog.removeNodeLabelCalculator(name);
        } else if (c instanceof NodeToolTipCalculator) {
            catalog.removeNodeToolTipCalculator(name);
        } else if (c instanceof NodeFontFaceCalculator) {
            catalog.removeNodeFontFaceCalculator(name);
        } else if (c instanceof NodeFontSizeCalculator) {
            catalog.removeNodeFontSizeCalculator(name);
        } else if (c instanceof EdgeColorCalculator) {
            catalog.removeEdgeColorCalculator(name);
        } else if (c instanceof EdgeLineTypeCalculator) {
            catalog.removeEdgeLineTypeCalculator(name);
        } else if (c instanceof EdgeArrowCalculator) {
            catalog.removeEdgeArrowCalculator(name);
        } else if (c instanceof EdgeLabelCalculator) {
            catalog.removeEdgeLabelCalculator(name);
        } else if (c instanceof EdgeToolTipCalculator) {
            catalog.removeEdgeToolTipCalculator(name);
        } else if (c instanceof EdgeFontFaceCalculator) {
            catalog.removeEdgeFontFaceCalculator(name);
        } else if (c instanceof EdgeFontSizeCalculator) {
            catalog.removeEdgeFontSizeCalculator(name);
        }
    }

    public static void renameAsNeeded(Calculator c, CalculatorCatalog catalog) {
        String newName;
        String name = ((Object)c).toString();
        if (c instanceof NodeColorCalculator) {
            String newName2 = catalog.checkNodeColorCalculatorName(name);
            if (!newName2.equals(name)) {
                c.setName(newName2);
            }
        } else if (c instanceof NodeLineTypeCalculator) {
            String newName3 = catalog.checkNodeLineTypeCalculatorName(name);
            if (!newName3.equals(name)) {
                c.setName(newName3);
            }
        } else if (c instanceof NodeShapeCalculator) {
            String newName4 = catalog.checkNodeShapeCalculatorName(name);
            if (!newName4.equals(name)) {
                c.setName(newName4);
            }
        } else if (c instanceof NodeSizeCalculator) {
            String newName5 = catalog.checkNodeSizeCalculatorName(name);
            if (!newName5.equals(name)) {
                c.setName(newName5);
            }
        } else if (c instanceof NodeLabelCalculator) {
            String newName6 = catalog.checkNodeLabelCalculatorName(name);
            if (!newName6.equals(name)) {
                c.setName(newName6);
            }
        } else if (c instanceof NodeToolTipCalculator) {
            String newName7 = catalog.checkNodeToolTipCalculatorName(name);
            if (!newName7.equals(name)) {
                c.setName(newName7);
            }
        } else if (c instanceof NodeFontFaceCalculator) {
            String newName8 = catalog.checkNodeFontFaceCalculatorName(name);
            if (!newName8.equals(name)) {
                c.setName(newName8);
            }
        } else if (c instanceof NodeFontSizeCalculator) {
            String newName9 = catalog.checkNodeFontSizeCalculatorName(name);
            if (!newName9.equals(name)) {
                c.setName(newName9);
            }
        } else if (c instanceof EdgeColorCalculator) {
            String newName10 = catalog.checkEdgeColorCalculatorName(name);
            if (!newName10.equals(name)) {
                c.setName(newName10);
            }
        } else if (c instanceof EdgeLineTypeCalculator) {
            String newName11 = catalog.checkEdgeLineTypeCalculatorName(name);
            if (!newName11.equals(name)) {
                c.setName(newName11);
            }
        } else if (c instanceof EdgeArrowCalculator) {
            String newName12 = catalog.checkEdgeArrowCalculatorName(name);
            if (!newName12.equals(name)) {
                c.setName(newName12);
            }
        } else if (c instanceof EdgeLabelCalculator) {
            String newName13 = catalog.checkEdgeLabelCalculatorName(name);
            if (!newName13.equals(name)) {
                c.setName(newName13);
            }
        } else if (c instanceof EdgeToolTipCalculator) {
            String newName14 = catalog.checkEdgeToolTipCalculatorName(name);
            if (!newName14.equals(name)) {
                c.setName(newName14);
            }
        } else if (c instanceof EdgeFontFaceCalculator) {
            String newName15 = catalog.checkEdgeFontFaceCalculatorName(name);
            if (!newName15.equals(name)) {
                c.setName(newName15);
            }
        } else if (c instanceof EdgeFontSizeCalculator && !(newName = catalog.checkEdgeFontSizeCalculatorName(name)).equals(name)) {
            c.setName(newName);
        }
    }
}

