/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeConfig;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.OldStyleCalculatorIO;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class CalculatorCatalogFactory {
    public static CalculatorCatalog loadCalculatorCatalog(CytoscapeConfig config) {
        FileInputStream is;
        Properties loadProps;
        CalculatorCatalog calculatorCatalog = new CalculatorCatalog();
        calculatorCatalog.addMapping("Discrete Mapper", DiscreteMapping.class);
        calculatorCatalog.addMapping("Continuous Mapper", ContinuousMapping.class);
        calculatorCatalog.addMapping("Passthrough Mapper", PassThroughMapping.class);
        Properties calcProps = new Properties();
        String vizPropsFileName = "vizmap.props";
        try {
            File defaultPropsFile = Cytoscape.getCytoscapeObj().getConfigFile(vizPropsFileName);
            if (defaultPropsFile != null && defaultPropsFile.canRead()) {
                loadProps = new Properties();
                is = new FileInputStream(defaultPropsFile);
                loadProps.load(is);
                ((InputStream)is).close();
                calcProps.putAll((Map<?, ?>)loadProps);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        try {
            File propsFile = new File(System.getProperty("CYTOSCAPE_HOME"), vizPropsFileName);
            if (propsFile != null && propsFile.canRead()) {
                loadProps = new Properties();
                is = new FileInputStream(propsFile);
                loadProps.load(is);
                ((InputStream)is).close();
                calcProps.putAll((Map<?, ?>)loadProps);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        try {
            File userSpecialPropsFile = new File(System.getProperty("user.dir"), vizPropsFileName);
            if (userSpecialPropsFile != null && userSpecialPropsFile.canRead()) {
                loadProps = new Properties();
                is = new FileInputStream(userSpecialPropsFile);
                loadProps.load(is);
                ((InputStream)is).close();
                calcProps.putAll((Map<?, ?>)loadProps);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        try {
            File userHomePropsFile = new File(System.getProperty("user.home"), vizPropsFileName);
            if (userHomePropsFile != null && userHomePropsFile.canRead()) {
                loadProps = new Properties();
                is = new FileInputStream(userHomePropsFile);
                loadProps.load(is);
                ((InputStream)is).close();
                calcProps.putAll((Map<?, ?>)loadProps);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        if (config.getProjectVizmapPropsFileName() != null) {
            String projViz = config.getProjectVizmapPropsFileName();
            calcProps.putAll((Map<?, ?>)config.readPropertyFileAsText(projViz));
        }
        CalculatorIO.loadCalculators(calcProps, calculatorCatalog);
        VisualStyle defaultVS = calculatorCatalog.getVisualStyle("default");
        if (defaultVS == null) {
            defaultVS = new VisualStyle("default");
            String cName = "canonical names as node labels";
            NodeLabelCalculator nlc = calculatorCatalog.getNodeLabelCalculator(cName);
            if (nlc == null) {
                PassThroughMapping m = new PassThroughMapping((Object)new String(), "canonicalName");
                nlc = new GenericNodeLabelCalculator(cName, m);
            }
            defaultVS.getNodeAppearanceCalculator().setNodeLabelCalculator(nlc);
            calculatorCatalog.addVisualStyle(defaultVS);
        }
        Properties configProps = config.getProperties();
        OldStyleCalculatorIO.checkForCalculators(configProps, calculatorCatalog);
        return calculatorCatalog;
    }
}

