/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.DuplicateCalculatorNameException;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalculatorCatalog {
    Map nodeColorCalculators = new HashMap();
    List nodeColorListeners = new Vector(2, 1);
    Map nodeLineTypeCalculators = new HashMap();
    List nodeLineTypeListeners = new Vector(1, 1);
    Map nodeShapeCalculators = new HashMap();
    List nodeShapeListeners = new Vector(1, 1);
    Map nodeSizeCalculators = new HashMap();
    List nodeSizeListeners = new Vector(2, 1);
    Map nodeLabelCalculators = new HashMap();
    List nodeLabelListeners = new Vector(1, 1);
    Map nodeToolTipCalculators = new HashMap();
    List nodeToolTipListeners = new Vector(1, 1);
    Map nodeFontFaceCalculators = new HashMap();
    List nodeFontFaceListeners = new Vector(1, 1);
    Map nodeFontSizeCalculators = new HashMap();
    List nodeFontSizeListeners = new Vector(1, 1);
    Map edgeColorCalculators = new HashMap();
    List edgeColorListeners = new Vector(1, 1);
    Map edgeLineTypeCalculators = new HashMap();
    List edgeLineTypeListeners = new Vector(1, 1);
    Map edgeArrowCalculators = new HashMap();
    List edgeArrowListeners = new Vector(2, 1);
    Map edgeLabelCalculators = new HashMap();
    List edgeLabelListeners = new Vector(1, 1);
    Map edgeToolTipCalculators = new HashMap();
    List edgeToolTipListeners = new Vector(1, 1);
    Map edgeFontFaceCalculators = new HashMap();
    List edgeFontFaceListeners = new Vector(1, 1);
    Map edgeFontSizeCalculators = new HashMap();
    List edgeFontSizeListeners = new Vector(1, 1);
    Map visualStyles = new HashMap();
    Map mappers = new HashMap();
    protected transient ChangeEvent changeEvent;

    public CalculatorCatalog() {
    }

    public CalculatorCatalog(Properties props) {
    }

    protected List getListenerList(byte type) throws IllegalArgumentException {
        switch (type) {
            case 0: 
            case 1: {
                return this.nodeColorListeners;
            }
            case 2: {
                return this.nodeLineTypeListeners;
            }
            case 3: {
                return this.nodeShapeListeners;
            }
            case 4: 
            case 126: 
            case 127: {
                return this.nodeSizeListeners;
            }
            case 5: {
                return this.nodeLabelListeners;
            }
            case 13: {
                return this.nodeToolTipListeners;
            }
            case 122: {
                return this.nodeFontFaceListeners;
            }
            case 123: {
                return this.nodeFontSizeListeners;
            }
            case 7: {
                return this.edgeColorListeners;
            }
            case 8: {
                return this.edgeLineTypeListeners;
            }
            case 9: 
            case 10: {
                return this.edgeArrowListeners;
            }
            case 11: {
                return this.edgeLabelListeners;
            }
            case 14: {
                return this.edgeToolTipListeners;
            }
            case 124: {
                return this.edgeFontFaceListeners;
            }
            case 125: {
                return this.edgeFontSizeListeners;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public void addChangeListener(ChangeListener l, byte type) throws IllegalArgumentException {
        List theListeners = this.getListenerList(type);
        theListeners.add(l);
    }

    protected void fireStateChanged(byte type) throws IllegalArgumentException {
        List notifyEvents = this.getListenerList(type);
        for (int i = notifyEvents.size() - 1; i >= 0; --i) {
            ChangeListener listener = (ChangeListener)notifyEvents.get(i);
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            listener.stateChanged(this.changeEvent);
        }
    }

    public byte getType(Calculator c) throws IllegalArgumentException {
        if (c instanceof NodeColorCalculator) {
            return 0;
        }
        if (c instanceof NodeLineTypeCalculator) {
            return 2;
        }
        if (c instanceof NodeShapeCalculator) {
            return 3;
        }
        if (c instanceof NodeSizeCalculator) {
            return 4;
        }
        if (c instanceof NodeLabelCalculator) {
            return 5;
        }
        if (c instanceof NodeToolTipCalculator) {
            return 13;
        }
        if (c instanceof NodeFontFaceCalculator) {
            return 122;
        }
        if (c instanceof NodeFontSizeCalculator) {
            return 123;
        }
        if (c instanceof EdgeColorCalculator) {
            return 7;
        }
        if (c instanceof EdgeLineTypeCalculator) {
            return 8;
        }
        if (c instanceof EdgeArrowCalculator) {
            return 9;
        }
        if (c instanceof EdgeLabelCalculator) {
            return 11;
        }
        if (c instanceof EdgeToolTipCalculator) {
            return 14;
        }
        if (c instanceof EdgeFontFaceCalculator) {
            return 124;
        }
        if (c instanceof EdgeFontSizeCalculator) {
            return 125;
        }
        throw new IllegalArgumentException("Unknown calculator type");
    }

    protected Map getCalculatorMap(byte type) {
        switch (type) {
            case 0: 
            case 1: {
                return this.nodeColorCalculators;
            }
            case 2: {
                return this.nodeLineTypeCalculators;
            }
            case 3: {
                return this.nodeShapeCalculators;
            }
            case 4: 
            case 126: 
            case 127: {
                return this.nodeSizeCalculators;
            }
            case 5: {
                return this.nodeLabelCalculators;
            }
            case 13: {
                return this.nodeToolTipCalculators;
            }
            case 122: {
                return this.nodeFontFaceCalculators;
            }
            case 123: {
                return this.nodeFontSizeCalculators;
            }
            case 7: {
                return this.edgeColorCalculators;
            }
            case 8: {
                return this.edgeLineTypeCalculators;
            }
            case 9: 
            case 10: {
                return this.edgeArrowCalculators;
            }
            case 11: {
                return this.edgeLabelCalculators;
            }
            case 14: {
                return this.edgeToolTipCalculators;
            }
            case 124: {
                return this.edgeFontFaceCalculators;
            }
            case 125: {
                return this.edgeFontSizeCalculators;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public void addCalculator(Calculator dupe) throws DuplicateCalculatorNameException, IllegalArgumentException {
        byte calcType = this.getType(dupe);
        Map theMap = this.getCalculatorMap(calcType);
        this.addCalculator(dupe, theMap);
        this.fireStateChanged(calcType);
    }

    public String checkCalculatorName(String calcName, byte calcType) {
        Map theMap = this.getCalculatorMap(calcType);
        return this.checkName(calcName, theMap);
    }

    public void renameCalculator(Calculator c, String name) throws DuplicateCalculatorNameException, IllegalArgumentException {
        byte calcType = this.getType(c);
        Map theMap = this.getCalculatorMap(calcType);
        String newName = this.checkName(name, theMap);
        if (!newName.equals(name)) {
            throw new DuplicateCalculatorNameException(newName);
        }
        theMap.remove(((Object)c).toString());
        c.setName(name);
        theMap.put(name, c);
        this.fireStateChanged(calcType);
    }

    public void removeCalculator(Calculator c) throws IllegalArgumentException {
        byte calcType = this.getType(c);
        Map theMap = this.getCalculatorMap(calcType);
        theMap.remove(((Object)c).toString());
        this.fireStateChanged(calcType);
    }

    public Set getMappingNames() {
        return this.mappers.keySet();
    }

    public void addMapping(String name, Class m) throws DuplicateCalculatorNameException, IllegalArgumentException {
        if (!ObjectMapping.class.isAssignableFrom(m)) {
            throw new IllegalArgumentException("Class " + m.getName() + " is not an ObjectMapper!");
        }
        if (this.mappers.keySet().contains(name)) {
            throw new DuplicateCalculatorNameException("Duplicate mapper name " + name);
        }
        this.mappers.put(name, m);
    }

    public Class removeMapping(String name) {
        return (Class)this.mappers.remove(name);
    }

    public Class getMapping(String name) {
        return (Class)this.mappers.get(name);
    }

    public String checkMappingName(String name) {
        String newName = name;
        int nameApp = 2;
        while (this.mappers.keySet().contains(newName)) {
            newName = name + nameApp;
            ++nameApp;
        }
        return newName;
    }

    public Set getVisualStyleNames() {
        return this.visualStyles.keySet();
    }

    public Collection getVisualStyles() {
        return this.visualStyles.values();
    }

    public void addVisualStyle(VisualStyle vs) {
        if (vs == null) {
            return;
        }
        String name = vs.toString();
        if (this.visualStyles.keySet().contains(name)) {
            String s = "Duplicate visual style name " + name;
            throw new DuplicateCalculatorNameException(s);
        }
        this.visualStyles.put(name, vs);
        this.addNodeAppearanceCalculator(vs.getNodeAppearanceCalculator());
        this.addEdgeAppearanceCalculator(vs.getEdgeAppearanceCalculator());
    }

    public VisualStyle removeVisualStyle(String name) {
        return (VisualStyle)this.visualStyles.remove(name);
    }

    public VisualStyle getVisualStyle(String name) {
        return (VisualStyle)this.visualStyles.get(name);
    }

    public String checkVisualStyleName(String name) {
        return this.checkName(name, this.visualStyles);
    }

    private void addNodeAppearanceCalculator(NodeAppearanceCalculator c) {
        NodeFontSizeCalculator nfsc;
        NodeFontFaceCalculator nffc;
        NodeToolTipCalculator nttc;
        NodeLabelCalculator nlc;
        NodeSizeCalculator nsc2;
        NodeSizeCalculator nsc1;
        NodeShapeCalculator nsc;
        NodeLineTypeCalculator nltc;
        NodeColorCalculator ncc2;
        NodeColorCalculator ncc1 = c.getNodeFillColorCalculator();
        if (ncc1 != null && !this.nodeColorCalculators.values().contains(ncc1)) {
            this.addNodeColorCalculator(ncc1);
        }
        if ((ncc2 = c.getNodeBorderColorCalculator()) != null && !this.nodeColorCalculators.values().contains(ncc2)) {
            this.addNodeColorCalculator(ncc2);
        }
        if ((nltc = c.getNodeLineTypeCalculator()) != null && !this.nodeLineTypeCalculators.values().contains(nltc)) {
            this.addNodeLineTypeCalculator(nltc);
        }
        if ((nsc = c.getNodeShapeCalculator()) != null && !this.nodeShapeCalculators.values().contains(nsc)) {
            this.addNodeShapeCalculator(nsc);
        }
        if ((nsc1 = c.getNodeHeightCalculator()) != null && !this.nodeSizeCalculators.values().contains(nsc1)) {
            this.addNodeSizeCalculator(nsc1);
        }
        if ((nsc2 = c.getNodeWidthCalculator()) != null && !this.nodeSizeCalculators.values().contains(nsc2)) {
            this.addNodeSizeCalculator(nsc2);
        }
        if ((nlc = c.getNodeLabelCalculator()) != null && !this.nodeLabelCalculators.values().contains(nlc)) {
            this.addNodeLabelCalculator(nlc);
        }
        if ((nttc = c.getNodeToolTipCalculator()) != null && !this.nodeToolTipCalculators.values().contains(nttc)) {
            this.addNodeToolTipCalculator(nttc);
        }
        if ((nffc = c.getNodeFontFaceCalculator()) != null && !this.nodeFontFaceCalculators.values().contains(nffc)) {
            this.addNodeFontFaceCalculator(nffc);
        }
        if ((nfsc = c.getNodeFontSizeCalculator()) != null && !this.nodeFontSizeCalculators.values().contains(nfsc)) {
            this.addNodeFontSizeCalculator(nfsc);
        }
    }

    private void addEdgeAppearanceCalculator(EdgeAppearanceCalculator c) {
        EdgeFontSizeCalculator efsc;
        EdgeFontFaceCalculator effc;
        EdgeToolTipCalculator ettc;
        EdgeLabelCalculator elc;
        EdgeArrowCalculator eac2;
        EdgeArrowCalculator eac1;
        EdgeLineTypeCalculator eltc;
        EdgeColorCalculator ecc = c.getEdgeColorCalculator();
        if (ecc != null && !this.edgeColorCalculators.values().contains(ecc)) {
            this.addEdgeColorCalculator(ecc);
        }
        if ((eltc = c.getEdgeLineTypeCalculator()) != null && !this.edgeLineTypeCalculators.values().contains(eltc)) {
            this.addEdgeLineTypeCalculator(eltc);
        }
        if ((eac1 = c.getEdgeSourceArrowCalculator()) != null && !this.edgeArrowCalculators.values().contains(eac1)) {
            this.addEdgeArrowCalculator(eac1);
        }
        if ((eac2 = c.getEdgeTargetArrowCalculator()) != null && !this.edgeArrowCalculators.values().contains(eac2)) {
            this.addEdgeArrowCalculator(eac2);
        }
        if ((elc = c.getEdgeLabelCalculator()) != null && !this.edgeLabelCalculators.values().contains(elc)) {
            this.addEdgeLabelCalculator(elc);
        }
        if ((ettc = c.getEdgeToolTipCalculator()) != null && !this.edgeToolTipCalculators.values().contains(ettc)) {
            this.addEdgeToolTipCalculator(ettc);
        }
        if ((effc = c.getEdgeFontFaceCalculator()) != null && !this.edgeFontFaceCalculators.values().contains(effc)) {
            this.addEdgeFontFaceCalculator(effc);
        }
        if ((efsc = c.getEdgeFontSizeCalculator()) != null && !this.edgeFontSizeCalculators.values().contains(efsc)) {
            this.addEdgeFontSizeCalculator(efsc);
        }
    }

    protected void addCalculator(Calculator c, Map m) throws DuplicateCalculatorNameException {
        if (c == null) {
            return;
        }
        String name = ((Object)c).toString();
        if (m.keySet().contains(name)) {
            String s = "Duplicate calculator name " + name;
            throw new DuplicateCalculatorNameException(s);
        }
        m.put(name, c);
    }

    protected String checkName(String name, Map m) {
        if (name == null) {
            return null;
        }
        String newName = name;
        int nameApp = 2;
        while (m.keySet().contains(newName)) {
            newName = name + nameApp;
            ++nameApp;
        }
        return newName;
    }

    public Collection getNodeColorCalculators() {
        return this.nodeColorCalculators.values();
    }

    public void addNodeColorCalculator(NodeColorCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.nodeColorCalculators);
    }

    public NodeColorCalculator removeNodeColorCalculator(String name) {
        return (NodeColorCalculator)this.nodeColorCalculators.remove(name);
    }

    public NodeColorCalculator getNodeColorCalculator(String name) {
        return (NodeColorCalculator)this.nodeColorCalculators.get(name);
    }

    public String checkNodeColorCalculatorName(String name) {
        return this.checkName(name, this.nodeColorCalculators);
    }

    public Collection getNodeLineTypeCalculators() {
        return this.nodeLineTypeCalculators.values();
    }

    public void addNodeLineTypeCalculator(NodeLineTypeCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.nodeLineTypeCalculators);
    }

    public NodeLineTypeCalculator removeNodeLineTypeCalculator(String name) {
        return (NodeLineTypeCalculator)this.nodeLineTypeCalculators.remove(name);
    }

    public NodeLineTypeCalculator getNodeLineTypeCalculator(String name) {
        return (NodeLineTypeCalculator)this.nodeLineTypeCalculators.get(name);
    }

    public String checkNodeLineTypeCalculatorName(String name) {
        return this.checkName(name, this.nodeLineTypeCalculators);
    }

    public Collection getNodeShapeCalculators() {
        return this.nodeShapeCalculators.values();
    }

    public void addNodeShapeCalculator(NodeShapeCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.nodeShapeCalculators);
    }

    public NodeShapeCalculator removeNodeShapeCalculator(String name) {
        return (NodeShapeCalculator)this.nodeShapeCalculators.remove(name);
    }

    public NodeShapeCalculator getNodeShapeCalculator(String name) {
        return (NodeShapeCalculator)this.nodeShapeCalculators.get(name);
    }

    public String checkNodeShapeCalculatorName(String name) {
        return this.checkName(name, this.nodeShapeCalculators);
    }

    public Collection getNodeSizeCalculators() {
        return this.nodeSizeCalculators.values();
    }

    public void addNodeSizeCalculator(NodeSizeCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.nodeSizeCalculators);
    }

    public NodeSizeCalculator removeNodeSizeCalculator(String name) {
        return (NodeSizeCalculator)this.nodeSizeCalculators.remove(name);
    }

    public NodeSizeCalculator getNodeSizeCalculator(String name) {
        return (NodeSizeCalculator)this.nodeSizeCalculators.get(name);
    }

    public String checkNodeSizeCalculatorName(String name) {
        return this.checkName(name, this.nodeSizeCalculators);
    }

    public Collection getNodeLabelCalculators() {
        return this.nodeLabelCalculators.values();
    }

    public void addNodeLabelCalculator(NodeLabelCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.nodeLabelCalculators);
    }

    public NodeLabelCalculator removeNodeLabelCalculator(String name) {
        return (NodeLabelCalculator)this.nodeLabelCalculators.remove(name);
    }

    public NodeLabelCalculator getNodeLabelCalculator(String name) {
        return (NodeLabelCalculator)this.nodeLabelCalculators.get(name);
    }

    public String checkNodeLabelCalculatorName(String name) {
        return this.checkName(name, this.nodeLabelCalculators);
    }

    public Collection getNodeToolTipCalculators() {
        return this.nodeToolTipCalculators.values();
    }

    public void addNodeToolTipCalculator(NodeToolTipCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.nodeToolTipCalculators);
    }

    public NodeToolTipCalculator removeNodeToolTipCalculator(String name) {
        return (NodeToolTipCalculator)this.nodeToolTipCalculators.remove(name);
    }

    public NodeToolTipCalculator getNodeToolTipCalculator(String name) {
        return (NodeToolTipCalculator)this.nodeToolTipCalculators.get(name);
    }

    public String checkNodeToolTipCalculatorName(String name) {
        return this.checkName(name, this.nodeToolTipCalculators);
    }

    public Collection getNodeFontFaceCalculators() {
        return this.nodeFontFaceCalculators.values();
    }

    public void addNodeFontFaceCalculator(NodeFontFaceCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.nodeFontFaceCalculators);
    }

    public NodeFontFaceCalculator removeNodeFontFaceCalculator(String name) {
        return (NodeFontFaceCalculator)this.nodeFontFaceCalculators.remove(name);
    }

    public NodeFontFaceCalculator getNodeFontFaceCalculator(String name) {
        return (NodeFontFaceCalculator)this.nodeFontFaceCalculators.get(name);
    }

    public String checkNodeFontFaceCalculatorName(String name) {
        return this.checkName(name, this.nodeFontFaceCalculators);
    }

    public Collection getNodeFontSizeCalculators() {
        return this.nodeFontSizeCalculators.values();
    }

    public void addNodeFontSizeCalculator(NodeFontSizeCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.nodeFontSizeCalculators);
    }

    public NodeFontSizeCalculator removeNodeFontSizeCalculator(String name) {
        return (NodeFontSizeCalculator)this.nodeFontSizeCalculators.remove(name);
    }

    public NodeFontSizeCalculator getNodeFontSizeCalculator(String name) {
        return (NodeFontSizeCalculator)this.nodeFontSizeCalculators.get(name);
    }

    public String checkNodeFontSizeCalculatorName(String name) {
        return this.checkName(name, this.nodeFontSizeCalculators);
    }

    public Collection getEdgeColorCalculators() {
        return this.edgeColorCalculators.values();
    }

    public void addEdgeColorCalculator(EdgeColorCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.edgeColorCalculators);
    }

    public EdgeColorCalculator removeEdgeColorCalculator(String name) {
        return (EdgeColorCalculator)this.edgeColorCalculators.remove(name);
    }

    public EdgeColorCalculator getEdgeColorCalculator(String name) {
        return (EdgeColorCalculator)this.edgeColorCalculators.get(name);
    }

    public String checkEdgeColorCalculatorName(String name) {
        return this.checkName(name, this.edgeColorCalculators);
    }

    public Collection getEdgeLineTypeCalculators() {
        return this.edgeLineTypeCalculators.values();
    }

    public void addEdgeLineTypeCalculator(EdgeLineTypeCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.edgeLineTypeCalculators);
    }

    public EdgeLineTypeCalculator removeEdgeLineTypeCalculator(String name) {
        return (EdgeLineTypeCalculator)this.edgeLineTypeCalculators.remove(name);
    }

    public EdgeLineTypeCalculator getEdgeLineTypeCalculator(String name) {
        return (EdgeLineTypeCalculator)this.edgeLineTypeCalculators.get(name);
    }

    public String checkEdgeLineTypeCalculatorName(String name) {
        return this.checkName(name, this.edgeLineTypeCalculators);
    }

    public Collection getEdgeArrowCalculators() {
        return this.edgeArrowCalculators.values();
    }

    public void addEdgeArrowCalculator(EdgeArrowCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.edgeArrowCalculators);
    }

    public EdgeArrowCalculator removeEdgeArrowCalculator(String name) {
        return (EdgeArrowCalculator)this.edgeArrowCalculators.remove(name);
    }

    public EdgeArrowCalculator getEdgeArrowCalculator(String name) {
        return (EdgeArrowCalculator)this.edgeArrowCalculators.get(name);
    }

    public String checkEdgeArrowCalculatorName(String name) {
        return this.checkName(name, this.edgeArrowCalculators);
    }

    public Collection getEdgeLabelCalculators() {
        return this.edgeLabelCalculators.values();
    }

    public void addEdgeLabelCalculator(EdgeLabelCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.edgeLabelCalculators);
    }

    public EdgeLabelCalculator removeEdgeLabelCalculator(String name) {
        return (EdgeLabelCalculator)this.edgeLabelCalculators.remove(name);
    }

    public EdgeLabelCalculator getEdgeLabelCalculator(String name) {
        return (EdgeLabelCalculator)this.edgeLabelCalculators.get(name);
    }

    public String checkEdgeLabelCalculatorName(String name) {
        return this.checkName(name, this.edgeLabelCalculators);
    }

    public Collection getEdgeToolTipCalculators() {
        return this.edgeToolTipCalculators.values();
    }

    public void addEdgeToolTipCalculator(EdgeToolTipCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.edgeToolTipCalculators);
    }

    public EdgeToolTipCalculator removeEdgeToolTipCalculator(String name) {
        return (EdgeToolTipCalculator)this.edgeToolTipCalculators.remove(name);
    }

    public EdgeToolTipCalculator getEdgeToolTipCalculator(String name) {
        return (EdgeToolTipCalculator)this.edgeToolTipCalculators.get(name);
    }

    public String checkEdgeToolTipCalculatorName(String name) {
        return this.checkName(name, this.edgeToolTipCalculators);
    }

    public Collection getEdgeFontFaceCalculators() {
        return this.edgeFontFaceCalculators.values();
    }

    public void addEdgeFontFaceCalculator(EdgeFontFaceCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.edgeFontFaceCalculators);
    }

    public EdgeFontFaceCalculator removeEdgeFontFaceCalculator(String name) {
        return (EdgeFontFaceCalculator)this.edgeFontFaceCalculators.remove(name);
    }

    public EdgeFontFaceCalculator getEdgeFontFaceCalculator(String name) {
        return (EdgeFontFaceCalculator)this.edgeFontFaceCalculators.get(name);
    }

    public String checkEdgeFontFaceCalculatorName(String name) {
        return this.checkName(name, this.edgeFontFaceCalculators);
    }

    public Collection getEdgeFontSizeCalculators() {
        return this.edgeFontSizeCalculators.values();
    }

    public void addEdgeFontSizeCalculator(EdgeFontSizeCalculator c) throws DuplicateCalculatorNameException {
        this.addCalculator(c, this.edgeFontSizeCalculators);
    }

    public EdgeFontSizeCalculator removeEdgeFontSizeCalculator(String name) {
        return (EdgeFontSizeCalculator)this.edgeFontSizeCalculators.remove(name);
    }

    public EdgeFontSizeCalculator getEdgeFontSizeCalculator(String name) {
        return (EdgeFontSizeCalculator)this.edgeFontSizeCalculators.get(name);
    }

    public String checkEdgeFontSizeCalculatorName(String name) {
        return this.checkName(name, this.edgeFontSizeCalculators);
    }
}

