/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.swing.AbstractTreeTableModel;
import cytoscape.util.swing.JTreeTable;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.PopupActionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NetworkPanel
extends JPanel
implements PropertyChangeListener,
TreeSelectionListener {
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    JTreeTable treeTable;
    NetworkTreeNode root;
    JPanel navigatorPanel;
    JPopupMenu popup;
    PopupActionListener popupActionListener;
    JMenuItem createViewItem;
    JMenuItem destroyViewItem;
    JMenuItem destroyNetworkItem;
    JSplitPane split;
    private CytoscapeDesktop cytoscapeDesktop;
    static /* synthetic */ Class class$cytoscape$util$swing$TreeTableModel;
    static /* synthetic */ Class class$java$lang$Integer;

    public NetworkPanel(CytoscapeDesktop desktop) {
        this.cytoscapeDesktop = desktop;
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(181, 700));
        this.root = new NetworkTreeNode("Network Root", "root");
        this.treeTable = new JTreeTable(new NetworkTreeTableModel(this.root));
        this.treeTable.getTree().addTreeSelectionListener(this);
        this.treeTable.getTree().setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.treeTable);
        this.treeTable.getTree().setCellRenderer(new MyRenderer());
        this.treeTable.getColumn("Network").setMaxWidth(100);
        this.treeTable.getColumn("Nodes").setMaxWidth(40);
        this.treeTable.getColumn("Edges").setMaxWidth(40);
        this.navigatorPanel = new JPanel();
        this.navigatorPanel.setMinimumSize(new Dimension(180, 180));
        this.navigatorPanel.setMaximumSize(new Dimension(180, 180));
        this.navigatorPanel.setPreferredSize(new Dimension(180, 180));
        JScrollPane scroll = new JScrollPane(this.treeTable);
        this.split = new JSplitPane(0, scroll, this.navigatorPanel);
        this.split.setResizeWeight(1.0);
        this.add(this.split);
        this.treeTable.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        this.createViewItem = new JMenuItem(PopupActionListener.CREATE_VIEW);
        this.destroyViewItem = new JMenuItem(PopupActionListener.DESTROY_VIEW);
        this.destroyNetworkItem = new JMenuItem(PopupActionListener.DESTROY_NETWORK);
        this.popupActionListener = new PopupActionListener();
        this.createViewItem.addActionListener(this.popupActionListener);
        this.destroyViewItem.addActionListener(this.popupActionListener);
        this.destroyNetworkItem.addActionListener(this.popupActionListener);
        this.popup.add(this.createViewItem);
        this.popup.add(this.destroyViewItem);
        this.popup.add(this.destroyNetworkItem);
    }

    public void setNavigator(JComponent comp) {
        this.split.setRightComponent(comp);
        this.split.validate();
    }

    public JPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void removeNetwork(String network_id) {
        NetworkTreeNode node = this.getNetworkNode(network_id);
        Enumeration<TreeNode> children = node.children();
        NetworkTreeNode child = null;
        ArrayList<TreeNode> removed_children = new ArrayList<TreeNode>();
        while (children.hasMoreElements()) {
            removed_children.add(children.nextElement());
        }
        Iterator i = removed_children.iterator();
        while (i.hasNext()) {
            child = (NetworkTreeNode)i.next();
            child.removeFromParent();
            this.root.add(child);
        }
        node.removeFromParent();
        this.treeTable.getTree().collapsePath(new TreePath(new TreeNode[]{this.root}));
        this.treeTable.getTree().updateUI();
        this.treeTable.doLayout();
    }

    public void addNetwork(String network_id, String parent_id) {
        if (this.getNetworkNode(network_id) == null) {
            NetworkTreeNode dmtn = new NetworkTreeNode(Cytoscape.getNetwork(network_id).getTitle(), network_id);
            if (parent_id != null) {
                NetworkTreeNode parent = this.getNetworkNode(parent_id);
                parent.add(dmtn);
            } else {
                this.root.add(dmtn);
            }
            this.treeTable.getTree().collapsePath(new TreePath(new TreeNode[]{this.root}));
            this.treeTable.getTree().updateUI();
            TreePath path = new TreePath(dmtn.getPath());
            this.treeTable.getTree().expandPath(path);
            this.treeTable.getTree().scrollPathToVisible(path);
            this.treeTable.doLayout();
        }
    }

    public void focusNetworkNode(String network_id) {
        NetworkTreeNode node = this.getNetworkNode(network_id);
        if (node != null) {
            this.treeTable.getTree().getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
            this.treeTable.getTree().scrollPathToVisible(new TreePath(node.getPath()));
        }
    }

    public NetworkTreeNode getNetworkNode(String network_id) {
        Enumeration<TreeNode> tree_node_enum = this.root.breadthFirstEnumeration();
        while (tree_node_enum.hasMoreElements()) {
            NetworkTreeNode node = (NetworkTreeNode)tree_node_enum.nextElement();
            if (node.getNetworkID() != network_id) continue;
            return node;
        }
        return null;
    }

    public void fireFocus(String network_id) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, CytoscapeDesktop.NETWORK_VIEW_FOCUS, null, network_id));
    }

    public void valueChanged(TreeSelectionEvent e) {
        NetworkTreeNode node = (NetworkTreeNode)this.treeTable.getTree().getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.getUserObject() == null) {
            return;
        }
        this.fireFocus(node.getNetworkID());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == Cytoscape.NETWORK_CREATED) {
            this.addNetwork((String)e.getNewValue(), (String)e.getOldValue());
        }
        if (e.getPropertyName() == Cytoscape.NETWORK_DESTROYED) {
            this.removeNetwork((String)e.getNewValue());
        } else if (e.getPropertyName() == CytoscapeDesktop.NETWORK_VIEW_FOCUSED) {
            this.focusNetworkNode((String)e.getNewValue());
        }
    }

    protected class PopupListener
    extends MouseAdapter {
        protected PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            JTree tree;
            TreePath treePath;
            String networkID;
            CyNetwork cyNetwork;
            int row;
            if (e.isPopupTrigger() && (row = NetworkPanel.this.treeTable.rowAtPoint(e.getPoint())) != -1 && (cyNetwork = Cytoscape.getNetwork(networkID = ((NetworkTreeNode)(treePath = (tree = NetworkPanel.this.treeTable.getTree()).getPathForRow(row)).getLastPathComponent()).getNetworkID())) != null) {
                if (Cytoscape.viewExists(networkID)) {
                    NetworkPanel.this.createViewItem.setEnabled(false);
                    NetworkPanel.this.destroyViewItem.setEnabled(true);
                } else {
                    NetworkPanel.this.createViewItem.setEnabled(true);
                    NetworkPanel.this.destroyViewItem.setEnabled(false);
                }
                NetworkPanel.this.popupActionListener.setActiveNetwork(cyNetwork);
                NetworkPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        Icon tutorialIcon;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.hasView(value)) {
                this.setBackgroundNonSelectionColor(Color.green.brighter());
                this.setBackgroundSelectionColor(Color.green.darker());
            } else {
                this.setBackgroundNonSelectionColor(Color.red.brighter());
                this.setBackgroundSelectionColor(Color.red.darker());
            }
            return this;
        }

        private boolean hasView(Object value) {
            NetworkTreeNode node = (NetworkTreeNode)value;
            this.setToolTipText(Cytoscape.getNetwork(node.getNetworkID()).getTitle());
            return Cytoscape.viewExists(node.getNetworkID());
        }
    }

    protected class NetworkTreeNode
    extends DefaultMutableTreeNode {
        protected String network_uid;

        public NetworkTreeNode(Object userobj, String id) {
            super(userobj.toString());
            this.network_uid = id;
        }

        protected void setNetworkID(String id) {
            this.network_uid = id;
        }

        protected String getNetworkID() {
            return this.network_uid;
        }
    }

    class NetworkTreeTableModel
    extends AbstractTreeTableModel {
        String[] columns;
        Class[] columns_class;

        public NetworkTreeTableModel(Object root) {
            super(root);
            this.columns = new String[]{"Network", "Nodes", "Edges"};
            this.columns_class = new Class[]{class$cytoscape$util$swing$TreeTableModel == null ? (class$cytoscape$util$swing$TreeTableModel = NetworkPanel.class$("cytoscape.util.swing.TreeTableModel")) : class$cytoscape$util$swing$TreeTableModel, class$java$lang$Integer == null ? (class$java$lang$Integer = NetworkPanel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = NetworkPanel.class$("java.lang.Integer")) : class$java$lang$Integer};
        }

        public Object getChild(Object parent, int index) {
            Enumeration<TreeNode> tree_node_enum = ((DefaultMutableTreeNode)this.getRoot()).breadthFirstEnumeration();
            while (tree_node_enum.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node_enum.nextElement();
                if (node != parent) continue;
                return node.getChildAt(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            Enumeration<TreeNode> tree_node_enum = ((DefaultMutableTreeNode)this.getRoot()).breadthFirstEnumeration();
            while (tree_node_enum.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node_enum.nextElement();
                if (node != parent) continue;
                return node.getChildCount();
            }
            return 0;
        }

        public int getColumnCount() {
            return this.columns.length;
        }

        public String getColumnName(int column) {
            return this.columns[column];
        }

        public Class getColumnClass(int column) {
            return this.columns_class[column];
        }

        public Object getValueAt(Object node, int column) {
            if (column == 0) {
                return ((DefaultMutableTreeNode)node).getUserObject();
            }
            if (column == 1) {
                return new Integer(Cytoscape.getNetwork(((NetworkTreeNode)node).getNetworkID()).getNodeCount());
            }
            if (column == 2) {
                return new Integer(Cytoscape.getNetwork(((NetworkTreeNode)node).getNetworkID()).getEdgeCount());
            }
            return new Integer(0);
        }
    }
}

