/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.data.FlagEvent;
import cytoscape.data.FlagEventListener;
import cytoscape.data.FlagFilter;
import giny.model.Edge;
import giny.model.Node;
import giny.model.RootGraph;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import giny.view.NodeView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FlagAndSelectionHandler
implements FlagEventListener,
GraphViewChangeListener {
    FlagFilter flagFilter;
    GraphView view;

    public FlagAndSelectionHandler(FlagFilter flagFilter, GraphView view) {
        this.flagFilter = flagFilter;
        this.view = view;
        this.syncFilterAndView();
        flagFilter.addFlagEventListener(this);
        view.addGraphViewChangeListener(this);
    }

    private void syncFilterAndView() {
        Set flaggedNodes = this.flagFilter.getFlaggedNodes();
        Set flaggedEdges = this.flagFilter.getFlaggedEdges();
        List selectedNodes = this.view.getSelectedNodes();
        List selectedEdges = this.view.getSelectedEdges();
        Iterator iter = flaggedNodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            NodeView nv = this.view.getNodeView(node);
            if (nv == null || nv.isSelected()) continue;
            nv.setSelected(true);
        }
        iter = flaggedEdges.iterator();
        while (iter.hasNext()) {
            Edge edge = (Edge)iter.next();
            EdgeView ev = this.view.getEdgeView(edge);
            if (ev == null || ev.isSelected()) continue;
            ev.setSelected(true);
        }
        iter = selectedNodes.iterator();
        while (iter.hasNext()) {
            NodeView nv = (NodeView)iter.next();
            Node node = nv.getNode();
            this.flagFilter.setFlagged(node, true);
        }
        iter = selectedEdges.iterator();
        while (iter.hasNext()) {
            EdgeView ev = (EdgeView)iter.next();
            Edge edge = ev.getEdge();
            this.flagFilter.setFlagged(edge, true);
        }
    }

    public void graphViewChanged(GraphViewChangeEvent event) {
        GraphView source = (GraphView)event.getSource();
        RootGraph rootGraph = source.getGraphPerspective().getRootGraph();
        if (event.isNodesSelectedType()) {
            int[] selIndices = event.getSelectedNodeIndices();
            ArrayList<Node> selList = new ArrayList<Node>();
            for (int index = 0; index < selIndices.length; ++index) {
                Node node = rootGraph.getNode(selIndices[index]);
                selList.add(node);
            }
            this.flagFilter.setFlaggedNodes(selList, true);
        } else if (event.isNodesUnselectedType()) {
            int[] unselIndices = event.getUnselectedNodeIndices();
            ArrayList<Node> unselList = new ArrayList<Node>();
            for (int index = 0; index < unselIndices.length; ++index) {
                Node node = rootGraph.getNode(unselIndices[index]);
                unselList.add(node);
            }
            this.flagFilter.setFlaggedNodes(unselList, false);
        } else if (event.isEdgesSelectedType()) {
            int[] selIndices = event.getSelectedEdgeIndices();
            ArrayList<Edge> selList = new ArrayList<Edge>();
            for (int index = 0; index < selIndices.length; ++index) {
                Edge edge = rootGraph.getEdge(selIndices[index]);
                selList.add(edge);
            }
            this.flagFilter.setFlaggedEdges(selList, true);
        } else if (event.isEdgesUnselectedType()) {
            int[] unselIndices = event.getUnselectedEdgeIndices();
            ArrayList<Edge> unselList = new ArrayList<Edge>();
            for (int index = 0; index < unselIndices.length; ++index) {
                Edge edge = rootGraph.getEdge(unselIndices[index]);
                unselList.add(edge);
            }
            this.flagFilter.setFlaggedEdges(unselList, false);
        }
    }

    public void onFlagEvent(FlagEvent event) {
        if (event.getTargetType() == 0) {
            this.setNodeSelected((Node)event.getTarget(), event.getEventType());
        } else if (event.getTargetType() == 1) {
            this.setEdgeSelected((Edge)event.getTarget(), event.getEventType());
        } else if (event.getTargetType() == 2) {
            Set nodeSet = (Set)event.getTarget();
            Iterator iter = nodeSet.iterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                this.setNodeSelected(node, event.getEventType());
            }
        } else if (event.getTargetType() == 3) {
            Set edgeSet = (Set)event.getTarget();
            Iterator iter = edgeSet.iterator();
            while (iter.hasNext()) {
                Edge edge = (Edge)iter.next();
                this.setEdgeSelected(edge, event.getEventType());
            }
        } else {
            return;
        }
    }

    private void setNodeSelected(Node node, boolean selectOn) {
        NodeView nodeView = this.view.getNodeView(node);
        if (nodeView == null) {
            return;
        }
        if (nodeView.isSelected() != selectOn) {
            nodeView.setSelected(selectOn);
        }
    }

    private void setEdgeSelected(Edge edge, boolean selectOn) {
        EdgeView edgeView = this.view.getEdgeView(edge);
        if (edgeView == null) {
            return;
        }
        if (edgeView.isSelected() != selectOn) {
            edgeView.setSelected(selectOn);
        }
    }
}

