/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeObj;
import cytoscape.plugin.AbstractPlugin;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.plugin.PluginEvent;
import cytoscape.plugin.PluginListener;
import cytoscape.plugin.PluginUpdateList;
import cytoscape.util.CytoscapeToolBar;
import cytoscape.view.CyMenus;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CyWindow;
import cytoscape.view.GraphViewController;
import cytoscape.view.NetworkPanel;
import cytoscape.view.NetworkViewManager;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.VizMapUI;
import giny.view.GraphView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.SwingPropertyChangeSupport;

public class CytoscapeDesktop
extends JFrame
implements PluginListener,
PropertyChangeListener,
CyWindow {
    protected long lastPluginRegistryUpdate;
    public static String NETWORK_VIEW_FOCUSED = "NETWORK_VIEW_FOCUSED";
    public static String NETWORK_VIEW_FOCUS = "NETWORK_VIEW_FOCUS";
    public static String NETWORK_VIEW_CREATED = "NETWORK_VIEW_CREATED";
    public static String NETWORK_VIEW_DESTROYED = "NETWORK_VIEW_DESTROYED";
    public static String VISUAL_STYLE = "VISUAL_STYLE";
    public static String VIZMAP_ENABLED = "VIZMAP_ENABLED";
    public static int TABBED_VIEW = 0;
    public static int INTERNAL_VIEW = 1;
    public static int EXTERNAL_VIEW = 2;
    protected int VIEW_TYPE;
    protected VisualStyle defaultVisualStyle;
    protected NetworkPanel networkPanel;
    protected CyMenus cyMenus;
    protected NetworkViewManager networkViewManager;
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    protected GraphViewController graphViewController;
    protected VisualMappingManager vizMapper;
    protected VizMapUI vizMapUI;
    protected String currentNetworkID;
    protected String currentNetworkViewID;
    static /* synthetic */ Class class$cytoscape$plugin$AbstractPlugin;
    static /* synthetic */ Class class$cytoscape$plugin$CytoscapePlugin;

    public CytoscapeDesktop() {
        this(TABBED_VIEW);
    }

    public CytoscapeDesktop(int view_type) {
        super("Cytoscape Desktop");
        this.VIEW_TYPE = view_type;
        this.initialize();
    }

    protected void initialize() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/c16.png")));
        JPanel main_panel = new JPanel();
        main_panel.setLayout(new BorderLayout());
        this.networkPanel = new NetworkPanel(this);
        this.cyMenus = new CyMenus();
        this.networkViewManager = new NetworkViewManager(this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.networkViewManager);
        this.networkViewManager.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.networkPanel);
        this.networkPanel.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.cyMenus.initializeMenus();
        if (this.VIEW_TYPE == TABBED_VIEW) {
            JScrollPane scroll_tab = new JScrollPane(this.networkViewManager.getTabbedPane());
            JSplitPane split = new JSplitPane(1, false, this.networkPanel, scroll_tab);
            split.setOneTouchExpandable(true);
            main_panel.add((Component)split, "Center");
            main_panel.add((Component)this.cyMenus.getToolBar(), "North");
            this.setJMenuBar(this.cyMenus.getMenuBar());
        } else if (this.VIEW_TYPE == INTERNAL_VIEW) {
            JSplitPane split = new JSplitPane(1, false, this.networkPanel, this.networkViewManager.getDesktopPane());
            main_panel.add((Component)split, "Center");
            main_panel.add((Component)this.cyMenus.getToolBar(), "North");
            this.setJMenuBar(this.cyMenus.getMenuBar());
        } else if (this.VIEW_TYPE == EXTERNAL_VIEW) {
            main_panel.add(this.networkPanel);
            this.cyMenus.getToolBar().setOrientation(1);
            main_panel.add((Component)this.cyMenus.getToolBar(), "East");
            this.setJMenuBar(this.cyMenus.getMenuBar());
        }
        this.setupVizMapper(main_panel);
        Cytoscape.getCytoscapeObj().getPluginRegistry().addPluginListener(this);
        CytoscapeObj theCytoscapeObj = Cytoscape.getCytoscapeObj();
        CytoscapeDesktop thisWindow = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Cytoscape.exit();
            }

            public void windowClosed() {
            }
        });
        this.addWindowListener(Cytoscape.getCytoscapeObj().getParentApp());
        this.setContentPane(main_panel);
        this.pack();
        if (this.VIEW_TYPE != EXTERNAL_VIEW) {
            this.setSize(700, 700);
        }
        this.setVisible(true);
    }

    public NetworkPanel getNetworkPanel() {
        return this.networkPanel;
    }

    public CytoscapeObj getCytoscapeObj() {
        return Cytoscape.getCytoscapeObj();
    }

    public CyNetwork getNetwork() {
        return Cytoscape.getCurrentNetwork();
    }

    public GraphView getView() {
        return Cytoscape.getCurrentNetworkView();
    }

    public JFrame getMainFrame() {
        return this;
    }

    protected int getViewType() {
        return this.VIEW_TYPE;
    }

    public CyMenus getCyMenus() {
        return this.cyMenus;
    }

    public void setNewNetwork(CyNetwork newNetwork) {
    }

    public String getWindowTitle() {
        return "CD";
    }

    public void setWindowTitle(String newTitle) {
    }

    public void setInteractivity(boolean newState) {
    }

    public void redrawGraph() {
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
    }

    public void redrawGraph(boolean doLayout) {
        Cytoscape.getCurrentNetworkView().redrawGraph(doLayout, true);
    }

    public void redrawGraph(boolean doLayout, boolean applyAppearances) {
        Cytoscape.getCurrentNetworkView().redrawGraph(doLayout, applyAppearances);
    }

    public void showWindow(int width, int height) {
    }

    public void showWindow() {
    }

    public void applyLayout(GraphView lview) {
    }

    public void applySelLayout() {
    }

    public void applyVizmapSettings() {
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
    }

    public void setVisualMapperEnabled(boolean newState) {
        Cytoscape.getCurrentNetworkView().setVisualMapperEnabled(newState);
    }

    public void toggleVisualMapperEnabled() {
        Cytoscape.getCurrentNetworkView().toggleVisualMapperEnabled();
    }

    public void switchToReadOnlyMode() {
    }

    public void switchToEditMode() {
    }

    public void setupPlugins() {
        this.updatePlugins();
    }

    public void pluginRegistryChanged(PluginEvent event) {
        this.updatePlugins();
    }

    protected void updatePlugins() {
        PluginUpdateList pul = Cytoscape.getCytoscapeObj().getPluginRegistry().getPluginsLoadedSince(this.lastPluginRegistryUpdate);
        Class[] neededPlugin = pul.getPluginArray();
        for (int i = 0; i < neededPlugin.length; ++i) {
            if ((class$cytoscape$plugin$AbstractPlugin == null ? CytoscapeDesktop.class$("cytoscape.plugin.AbstractPlugin") : class$cytoscape$plugin$AbstractPlugin).isAssignableFrom(neededPlugin[i])) {
                AbstractPlugin.loadPlugin(neededPlugin[i], Cytoscape.getCytoscapeObj(), Cytoscape.getDesktop());
                continue;
            }
            if (!(class$cytoscape$plugin$CytoscapePlugin == null ? CytoscapeDesktop.class$("cytoscape.plugin.CytoscapePlugin") : class$cytoscape$plugin$CytoscapePlugin).isAssignableFrom(neededPlugin[i])) continue;
            CytoscapePlugin.loadPlugin(neededPlugin[i]);
        }
        this.lastPluginRegistryUpdate = pul.getTimestamp();
    }

    public VisualMappingManager getVizMapManager() {
        return this.vizMapper;
    }

    public VizMapUI getVizMapUI() {
        return this.vizMapUI;
    }

    protected void setupVizMapper(JPanel panel) {
        CalculatorCatalog calculatorCatalog = Cytoscape.getCytoscapeObj().getCalculatorCatalog();
        Properties configProps = Cytoscape.getCytoscapeObj().getConfiguration().getProperties();
        VisualStyle vs = null;
        String vsName = configProps.getProperty("defaultVisualStyle", "default");
        System.out.println("VS Name: " + vsName);
        vs = calculatorCatalog.getVisualStyle(vsName);
        if (vs == null) {
            vs = calculatorCatalog.getVisualStyle("default");
        }
        this.vizMapper = new VisualMappingManager(Cytoscape.getCurrentNetworkView(), calculatorCatalog, vs, Cytoscape.getCytoscapeObj().getLogger());
        this.vizMapUI = new VizMapUI(this.vizMapper, this);
        this.vizMapper.addChangeListener(this.vizMapUI.getStyleSelector());
        JComboBox styleBox = this.vizMapUI.getStyleSelector().getToolbarComboBox();
        Dimension newSize = new Dimension(150, (int)styleBox.getPreferredSize().getHeight());
        styleBox.setMaximumSize(newSize);
        styleBox.setPreferredSize(newSize);
        if (this.VIEW_TYPE == EXTERNAL_VIEW) {
            panel.add((Component)styleBox, "South");
        } else {
            CytoscapeToolBar toolBar = this.cyMenus.getToolBar();
            toolBar.add(styleBox);
            toolBar.addSeparator();
        }
    }

    public VisualStyle setVisualStyle(VisualStyle style) {
        VisualStyle old_style = (VisualStyle)this.vizMapUI.getStyleSelector().getToolbarComboBox().getSelectedItem();
        this.vizMapper.setVisualStyle(style);
        this.vizMapUI.getStyleSelector().getToolbarComboBox().setSelectedItem(style);
        return old_style;
    }

    protected void updateFocus(String network_id) {
        VisualStyle old_style = (VisualStyle)this.vizMapUI.getStyleSelector().getToolbarComboBox().getSelectedItem();
        CyNetworkView old_view = Cytoscape.getCurrentNetworkView();
        if (old_view != null) {
            old_view.putClientData(VISUAL_STYLE, old_style);
            old_view.putClientData(VIZMAP_ENABLED, new Boolean(old_view.getVisualMapperEnabled()));
        }
        Cytoscape.setCurrentNetwork(network_id);
        if (Cytoscape.setCurrentNetworkView(network_id)) {
            CyNetworkView new_view = Cytoscape.getCurrentNetworkView();
            VisualStyle new_style = (VisualStyle)new_view.getClientData(VISUAL_STYLE);
            Boolean vizmap_enabled = (Boolean)new_view.getClientData(VIZMAP_ENABLED);
            if (new_style == null) {
                new_style = this.defaultVisualStyle;
            }
            if (vizmap_enabled == null) {
                vizmap_enabled = new Boolean(true);
            }
            this.vizMapper.setNetworkView(new_view);
            if (new_style != null) {
                this.vizMapper.setVisualStyle(new_style);
                this.vizMapUI.getStyleSelector().getToolbarComboBox().setSelectedItem(new_style);
            }
            this.cyMenus.setNodesRequiredItemsEnabled();
            this.cyMenus.setVisualMapperItemsEnabled(vizmap_enabled);
            if (vizmap_enabled.booleanValue()) {
                new_view.redrawGraph(false, false);
            }
        }
    }

    public void setFocus(String network_id) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, NETWORK_VIEW_FOCUSED, null, network_id));
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, NETWORK_VIEW_FOCUS, null, network_id));
    }

    public GraphViewController getGraphViewController() {
        if (this.graphViewController == null) {
            this.graphViewController = new GraphViewController();
        }
        return this.graphViewController;
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == NETWORK_VIEW_CREATED) {
            this.getGraphViewController().addGraphView((CyNetworkView)e.getNewValue());
            this.pcs.firePropertyChange(e);
            this.networkPanel.focusNetworkNode(((CyNetworkView)e.getNewValue()).getIdentifier());
            this.networkPanel.fireFocus(((CyNetworkView)e.getNewValue()).getIdentifier());
        } else if (e.getPropertyName() == NETWORK_VIEW_FOCUSED) {
            this.updateFocus(e.getNewValue().toString());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == NETWORK_VIEW_FOCUS) {
            this.updateFocus(e.getNewValue().toString());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == Cytoscape.NETWORK_CREATED) {
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == Cytoscape.NETWORK_DESTROYED) {
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == NETWORK_VIEW_DESTROYED) {
            this.getGraphViewController().removeGraphView((CyNetworkView)e.getNewValue());
            this.pcs.firePropertyChange(e);
        }
    }
}

