/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.Cytoscape;
import cytoscape.actions.AlphabeticalSelectionAction;
import cytoscape.actions.BackgroundColorAction;
import cytoscape.actions.BirdsEyeViewAction;
import cytoscape.actions.CloneGraphInNewWindowAction;
import cytoscape.actions.CreateNetworkViewAction;
import cytoscape.actions.DeSelectAllEdgesAction;
import cytoscape.actions.DeSelectAllNodesAction;
import cytoscape.actions.DeselectAllAction;
import cytoscape.actions.DestroyNetworkAction;
import cytoscape.actions.DestroyNetworkViewAction;
import cytoscape.actions.DisplayBrowserAction;
import cytoscape.actions.ExitAction;
import cytoscape.actions.ExportAction;
import cytoscape.actions.FitContentAction;
import cytoscape.actions.HideSelectedAction;
import cytoscape.actions.HideSelectedEdgesAction;
import cytoscape.actions.HideSelectedNodesAction;
import cytoscape.actions.InvertSelectedEdgesAction;
import cytoscape.actions.InvertSelectedNodesAction;
import cytoscape.actions.ListFromFileSelectionAction;
import cytoscape.actions.LoadBioDataServerAction;
import cytoscape.actions.LoadEdgeAttributesAction;
import cytoscape.actions.LoadExpressionMatrixAction;
import cytoscape.actions.LoadGraphFileAction;
import cytoscape.actions.LoadNodeAttributesAction;
import cytoscape.actions.LoadPluginAction;
import cytoscape.actions.LoadPluginDirectoryAction;
import cytoscape.actions.NewWindowSelectedNodesEdgesAction;
import cytoscape.actions.NewWindowSelectedNodesOnlyAction;
import cytoscape.actions.PrintAction;
import cytoscape.actions.SaveAsGMLAction;
import cytoscape.actions.SaveAsInteractionsAction;
import cytoscape.actions.SaveEdgeAttributesAction;
import cytoscape.actions.SaveNodeAttributesAction;
import cytoscape.actions.SelectAllAction;
import cytoscape.actions.SelectAllEdgesAction;
import cytoscape.actions.SelectAllNodesAction;
import cytoscape.actions.SelectFirstNeighborsAction;
import cytoscape.actions.SelectionModeAction;
import cytoscape.actions.SetVisualPropertiesAction;
import cytoscape.actions.ShowAllAction;
import cytoscape.actions.SpringEmbeddedLayoutAction;
import cytoscape.actions.SquiggleAction;
import cytoscape.actions.ToggleVisualMapperAction;
import cytoscape.actions.UnHideSelectedEdgesAction;
import cytoscape.actions.UnHideSelectedNodesAction;
import cytoscape.actions.ZoomAction;
import cytoscape.actions.ZoomSelectedAction;
import cytoscape.data.annotation.AnnotationGui;
import cytoscape.dialogs.ShrinkExpandGraphUI;
import cytoscape.util.CreditScreen;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.CytoscapeMenuBar;
import cytoscape.util.CytoscapeToolBar;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class CyMenus
implements GraphViewChangeListener {
    boolean menusInitialized = false;
    CytoscapeMenuBar menuBar;
    JMenu fileMenu;
    JMenu loadSubMenu;
    JMenu saveSubMenu;
    JMenu editMenu;
    JMenuItem deleteSelectionMenuItem;
    JMenu dataMenu;
    JMenu selectMenu;
    JMenu displayNWSubMenu;
    JMenu layoutMenu;
    JMenu vizMenu;
    CytoscapeAction menuPrintAction;
    CytoscapeAction menuExportAction;
    JMenuItem vizMenuItem;
    JMenuItem vizMapperItem;
    JButton saveButton;
    JButton vizButton;
    JMenu opsMenu;
    CytoscapeToolBar toolBar;
    boolean nodesRequiredItemsEnabled;

    public CyMenus() {
        this.createMenuBar();
        this.toolBar = new CytoscapeToolBar();
    }

    public CytoscapeMenuBar getMenuBar() {
        return this.menuBar;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getLoadSubMenu() {
        return this.loadSubMenu;
    }

    public JMenu getSaveSubMenu() {
        return this.saveSubMenu;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getDataMenu() {
        return this.dataMenu;
    }

    public JMenu getSelectMenu() {
        return this.selectMenu;
    }

    public JMenu getLayoutMenu() {
        return this.layoutMenu;
    }

    public JMenu getVizMenu() {
        return this.vizMenu;
    }

    public JMenu getOperationsMenu() {
        return this.opsMenu;
    }

    public void refreshOperationsMenu() {
    }

    public CytoscapeToolBar getToolBar() {
        return this.toolBar;
    }

    public void addAction(CytoscapeAction action) {
        this.addCytoscapeAction(action);
    }

    public void addCytoscapeAction(CytoscapeAction action) {
        if (action.isInMenuBar()) {
            this.getMenuBar().addAction(action);
        }
        if (action.isInToolBar()) {
            this.getToolBar().addAction(action);
        }
    }

    public void enableDeleteSelectionMenuItem() {
        if (this.deleteSelectionMenuItem != null) {
            this.deleteSelectionMenuItem.setEnabled(true);
        }
    }

    public void disableDeleteSelectionMenuItem() {
        if (this.deleteSelectionMenuItem != null) {
            this.deleteSelectionMenuItem.setEnabled(false);
        }
    }

    public void setVisualMapperItemsEnabled(boolean newState) {
        this.vizMenuItem.setEnabled(newState);
        this.vizButton.setEnabled(newState);
        this.vizMapperItem.setText(newState ? "Disable Visual Mapper" : "Enable Visual Mapper");
    }

    public void setNodesRequiredItemsEnabled() {
        boolean newState = Cytoscape.getCurrentNetwork().getNodeCount() > 0;
        newState = true;
        if (newState == this.nodesRequiredItemsEnabled) {
            return;
        }
        this.saveButton.setEnabled(newState);
        this.saveSubMenu.setEnabled(newState);
        this.menuPrintAction.setEnabled(newState);
        this.menuExportAction.setEnabled(newState);
        this.displayNWSubMenu.setEnabled(newState);
        this.nodesRequiredItemsEnabled = newState;
    }

    public void graphViewChanged(GraphViewChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CyMenus.this.setNodesRequiredItemsEnabled();
            }
        });
    }

    private void createMenuBar() {
        this.menuBar = new CytoscapeMenuBar();
        this.fileMenu = this.menuBar.getMenu("File");
        this.loadSubMenu = this.menuBar.getMenu("File.Load");
        this.saveSubMenu = this.menuBar.getMenu("File.Save");
        this.editMenu = this.menuBar.getMenu("Edit");
        this.dataMenu = this.menuBar.getMenu("Data");
        this.selectMenu = this.menuBar.getMenu("Select");
        this.layoutMenu = this.menuBar.getMenu("Layout");
        this.vizMenu = this.menuBar.getMenu("Visualization");
        this.opsMenu = this.menuBar.getMenu("Plugins");
    }

    public void initializeMenus() {
        if (!this.menusInitialized) {
            this.menusInitialized = true;
            this.fillMenuBar();
            this.fillToolBar();
            this.nodesRequiredItemsEnabled = false;
            this.saveButton.setEnabled(false);
            this.saveSubMenu.setEnabled(false);
            this.menuPrintAction.setEnabled(false);
            this.menuExportAction.setEnabled(false);
            this.displayNWSubMenu.setEnabled(false);
            this.setNodesRequiredItemsEnabled();
        }
    }

    private void fillMenuBar() {
        JMenuItem about = new JMenuItem(new AbstractAction("Cytoscape Credits"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        StringBuffer lines = new StringBuffer();
                        lines.append("Cytoscape is a collaboration \n");
                        lines.append("between the Institute for Systems\n");
                        lines.append("Biology, University of California,\n");
                        lines.append("San Diaego, Memorial Sloan Kettering\n");
                        lines.append("Cancer Center and the\n");
                        lines.append("Institute Pasteur\n");
                        lines.append(" \n");
                        lines.append("Cytosape 2.0 Primary Developers\n");
                        lines.append("Iliana Avila-Campillo,  Ethan Cerami,\n");
                        lines.append("Rowan Christmas, Ryan Kelley, Andrew\n");
                        lines.append("Markiel, and Chris Workman\n");
                        lines.append(" \n");
                        lines.append(" \n");
                        lines.append("ISB: Hamid Bolouri (PI) \n");
                        lines.append("Paul Shannon, David Reiss, James\n");
                        lines.append("Taylor, Larissa KamenkoVich and \n");
                        lines.append("Paul Edlefsen ( GINY Library )\n");
                        lines.append(" \n");
                        lines.append("UCSD: Trey Ideker (PI) \n");
                        lines.append("Jonathan Wang,  Nada Amin, and \n");
                        lines.append("Owen Ozier\n");
                        lines.append(" \n");
                        lines.append("MSKCC: Chris Sander (PI) \n");
                        lines.append("Gary Bader,  Robert Sheridan\n");
                        lines.append(" \n");
                        lines.append("IP: Benno Shwikowski (PI) \n");
                        lines.append(" \n");
                        lines.append("Addional Collaborators\n");
                        CreditScreen.showCredits(this.getClass().getResource("/cytoscape/images/CytoscapeCredits.png"), lines.toString());
                    }
                });
            }
        });
        this.getMenuBar().getMenu("File.Help").add(about);
        this.addAction(new LoadGraphFileAction(this));
        this.addAction(new LoadNodeAttributesAction());
        this.addAction(new LoadEdgeAttributesAction());
        this.addAction(new LoadExpressionMatrixAction());
        this.addAction(new LoadBioDataServerAction());
        this.addAction(new SaveAsGMLAction());
        this.addAction(new SaveAsInteractionsAction());
        this.addAction(new SaveNodeAttributesAction());
        this.addAction(new SaveEdgeAttributesAction());
        this.menuPrintAction = new PrintAction();
        this.menuExportAction = new ExportAction();
        this.addAction(this.menuPrintAction);
        this.addAction(this.menuExportAction);
        if (Cytoscape.getCytoscapeObj().getParentApp() != null) {
            this.addAction(new ExitAction());
        }
        this.editMenu.add(new SquiggleAction());
        this.addAction(new CreateNetworkViewAction());
        this.addAction(new DestroyNetworkViewAction());
        this.addAction(new DestroyNetworkAction());
        this.addAction(new DisplayBrowserAction());
        this.selectMenu.add(new SelectionModeAction());
        this.displayNWSubMenu = this.menuBar.getMenu("Select.To New Network");
        this.addAction(new InvertSelectedNodesAction());
        this.addAction(new HideSelectedNodesAction());
        this.addAction(new UnHideSelectedNodesAction());
        this.addAction(new SelectAllNodesAction());
        this.addAction(new DeSelectAllNodesAction());
        this.addAction(new SelectFirstNeighborsAction());
        this.addAction(new AlphabeticalSelectionAction());
        this.addAction(new ListFromFileSelectionAction());
        this.addAction(new InvertSelectedEdgesAction());
        this.addAction(new HideSelectedEdgesAction());
        this.addAction(new UnHideSelectedEdgesAction());
        this.addAction(new SelectAllEdgesAction());
        this.addAction(new DeSelectAllEdgesAction());
        this.addAction(new NewWindowSelectedNodesOnlyAction());
        this.addAction(new NewWindowSelectedNodesEdgesAction());
        this.addAction(new CloneGraphInNewWindowAction());
        this.addAction(new SelectAllAction());
        this.addAction(new DeselectAllAction());
        this.addAction(new SpringEmbeddedLayoutAction());
        this.layoutMenu.addSeparator();
        ShrinkExpandGraphUI.makeShrinkExpandGraphUI(this);
        this.addAction(new BirdsEyeViewAction());
        this.addAction(new BackgroundColorAction());
        this.vizMenuItem = new JMenuItem(new SetVisualPropertiesAction());
        this.vizMapperItem = new JMenuItem(new ToggleVisualMapperAction());
        this.menuBar.getMenu("Visualization").add(this.vizMenuItem);
        this.menuBar.getMenu("Visualization").add(this.vizMapperItem);
        this.addAction(new LoadPluginAction());
        this.addAction(new LoadPluginDirectoryAction());
        this.opsMenu.addSeparator();
    }

    private void fillToolBar() {
        JButton b = this.toolBar.add(new LoadGraphFileAction(this, false));
        b.setIcon(new ImageIcon(this.getClass().getResource("images/new/load36.gif")));
        b.setToolTipText("Load Graph");
        b.setBorderPainted(false);
        b.setRolloverEnabled(true);
        this.saveButton = this.toolBar.add(new SaveAsGMLAction(false));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("images/new/save36.gif")));
        this.saveButton.setToolTipText("Save Graph as GML");
        this.saveButton.setBorderPainted(false);
        this.saveButton.setRolloverEnabled(true);
        this.saveButton.setEnabled(false);
        this.toolBar.addSeparator();
        final ZoomAction zoom_in = new ZoomAction(1.1);
        final JButton zoomInButton = new JButton();
        zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("images/new/zoom_in36.gif")));
        zoomInButton.setToolTipText("Zoom In");
        zoomInButton.setBorderPainted(false);
        zoomInButton.setRolloverEnabled(true);
        zoomInButton.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                zoom_in.zoom();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                zoomInButton.setSelected(true);
            }

            public void mouseReleased(MouseEvent e) {
                zoomInButton.setSelected(false);
            }
        });
        final ZoomAction zoom_out = new ZoomAction(0.9);
        final JButton zoomOutButton = new JButton();
        zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("images/new/zoom_out36.gif")));
        zoomOutButton.setToolTipText("Zoom Out");
        zoomOutButton.setBorderPainted(false);
        zoomOutButton.setRolloverEnabled(true);
        zoomOutButton.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                zoom_out.zoom();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                zoomOutButton.setSelected(true);
            }

            public void mouseReleased(MouseEvent e) {
                zoomOutButton.setSelected(false);
            }
        });
        zoomOutButton.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    zoom_in.zoom();
                } else {
                    zoom_out.zoom();
                }
            }
        });
        zoomInButton.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    zoom_in.zoom();
                } else {
                    zoom_out.zoom();
                }
            }
        });
        this.toolBar.add(zoomOutButton);
        this.toolBar.add(zoomInButton);
        b = this.toolBar.add(new ZoomSelectedAction());
        b.setIcon(new ImageIcon(this.getClass().getResource("images/new/crop36.gif")));
        b.setToolTipText("Zoom Selected Region");
        b.setBorderPainted(false);
        b = this.toolBar.add(new FitContentAction());
        b.setIcon(new ImageIcon(this.getClass().getResource("images/new/fit36.gif")));
        b.setToolTipText("Zoom out to display all of current Graph");
        b.setBorderPainted(false);
        b = this.toolBar.add(new ShowAllAction());
        b.setIcon(new ImageIcon(this.getClass().getResource("images/new/add36.gif")));
        b.setToolTipText("Show all Nodes and Edges (unhiding as necessary)");
        b.setBorderPainted(false);
        b = this.toolBar.add(new HideSelectedAction(false));
        b.setIcon(new ImageIcon(this.getClass().getResource("images/new/delete36.gif")));
        b.setToolTipText("Hide Selected Region");
        b.setBorderPainted(false);
        this.toolBar.addSeparator();
        b = this.toolBar.add(new AnnotationGui());
        b.setIcon(new ImageIcon(this.getClass().getResource("images/new/ontology36.gif")));
        b.setToolTipText("Add Annotation Ontology to Nodes");
        b.setBorderPainted(false);
        this.toolBar.addSeparator();
        this.vizButton = this.toolBar.add(new SetVisualPropertiesAction(false));
        this.vizButton.setIcon(new ImageIcon(this.getClass().getResource("images/new/color_wheel36.gif")));
        this.vizButton.setToolTipText("Set Visual Properties");
        this.vizButton.setBorderPainted(false);
    }
}

