/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cern.colt.list.IntArrayList;
import cytoscape.view.GraphViewHandler;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BasicGraphViewHandler
implements GraphViewHandler {
    public void handleGraphPerspectiveEvent(GraphPerspectiveChangeEvent event, GraphView graph_view) {
        int numTypes = 0;
        if (event.isNodesHiddenType()) {
            BasicGraphViewHandler.removeGraphViewNodes(graph_view, event.getHiddenNodeIndices());
            ++numTypes;
        }
        if (event.isNodesRestoredType()) {
            BasicGraphViewHandler.restoreGraphViewNodes(graph_view, event.getRestoredNodeIndices(), true);
            ++numTypes;
        }
        if (event.isEdgesHiddenType()) {
            BasicGraphViewHandler.removeGraphViewEdges(graph_view, event.getHiddenEdgeIndices());
            ++numTypes;
        }
        if (event.isEdgesRestoredType()) {
            BasicGraphViewHandler.restoreGraphViewEdges(graph_view, event.getRestoredEdgeIndices());
            ++numTypes;
        }
        if (numTypes == 0) {
            return;
        }
        graph_view.updateView();
    }

    public static Edge[] removeGraphViewEdges(GraphView graph_view, Edge[] edges) {
        HashSet<Edge> removedEdges = new HashSet<Edge>();
        for (int i = 0; i < edges.length; ++i) {
            EdgeView edgeView = graph_view.removeEdgeView(edges[i]);
            if (edgeView == null) continue;
            removedEdges.add(edges[i]);
        }
        return removedEdges.toArray(new Edge[removedEdges.size()]);
    }

    public static int[] removeGraphViewEdges(GraphView graph_view, int[] edge_indices) {
        IntArrayList removedEdges = new IntArrayList(edge_indices.length);
        for (int i = 0; i < edge_indices.length; ++i) {
            EdgeView edgeView = graph_view.removeEdgeView(edge_indices[i]);
            if (edgeView == null) continue;
            removedEdges.add(edge_indices[i]);
        }
        removedEdges.trimToSize();
        return removedEdges.elements();
    }

    public static Edge[] restoreGraphViewEdges(GraphView graph_view, Edge[] edges) {
        HashSet<Edge> restoredEdges = new HashSet<Edge>();
        for (int i = 0; i < edges.length; ++i) {
            EdgeView edgeView = graph_view.getEdgeView(edges[i]);
            boolean restored = false;
            if (edgeView == null) {
                edgeView = graph_view.addEdgeView(edges[i].getRootGraphIndex());
                if (edgeView != null) {
                    restored = true;
                }
            } else {
                restored = graph_view.showGraphObject(edgeView);
            }
            if (!restored) continue;
            restoredEdges.add(edgeView.getEdge());
        }
        return restoredEdges.toArray(new Edge[restoredEdges.size()]);
    }

    public static int[] restoreGraphViewEdges(GraphView graph_view, int[] edge_indices) {
        IntArrayList restoredEdgeIndices = new IntArrayList(edge_indices.length);
        for (int i = 0; i < edge_indices.length; ++i) {
            EdgeView edgeView = graph_view.getEdgeView(edge_indices[i]);
            boolean restored = false;
            if (edgeView == null) {
                edgeView = graph_view.addEdgeView(edge_indices[i]);
                if (edgeView != null) {
                    restored = true;
                }
            } else {
                restored = graph_view.showGraphObject(edgeView);
            }
            if (!restored) continue;
            restoredEdgeIndices.add(edge_indices[i]);
        }
        restoredEdgeIndices.trimToSize();
        return restoredEdgeIndices.elements();
    }

    public static Edge[] selectGraphViewEdges(GraphView graph_view, Edge[] edges) {
        HashSet<Edge> selectedEdges = new HashSet<Edge>();
        for (int i = 0; i < edges.length; ++i) {
            EdgeView edgeView = graph_view.getEdgeView(edges[i]);
            if (edgeView == null) continue;
            edgeView.setSelected(true);
            selectedEdges.add(edges[i]);
        }
        return selectedEdges.toArray(new Edge[selectedEdges.size()]);
    }

    public static Edge[] unselectGraphViewEdges(GraphView graph_view, Edge[] edges) {
        HashSet<Edge> unselectedEdges = new HashSet<Edge>();
        for (int i = 0; i < edges.length; ++i) {
            EdgeView edgeView = graph_view.getEdgeView(edges[i]);
            if (edgeView == null) continue;
            edgeView.setSelected(false);
            unselectedEdges.add(edges[i]);
        }
        return unselectedEdges.toArray(new Edge[unselectedEdges.size()]);
    }

    public static Node[] removeGraphViewNodes(GraphView graph_view, Node[] nodes) {
        HashSet<Node> removedNodes = new HashSet<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            NodeView nodeView = graph_view.removeNodeView(nodes[i]);
            if (nodeView == null) continue;
            removedNodes.add(nodes[i]);
        }
        return removedNodes.toArray(new Node[removedNodes.size()]);
    }

    public static int[] removeGraphViewNodes(GraphView graph_view, int[] node_indices) {
        IntArrayList removedNodesIndices = new IntArrayList(node_indices.length);
        for (int i = 0; i < node_indices.length; ++i) {
            NodeView nodeView = graph_view.removeNodeView(node_indices[i]);
            if (nodeView == null) continue;
            removedNodesIndices.add(node_indices[i]);
        }
        removedNodesIndices.trimToSize();
        return removedNodesIndices.elements();
    }

    public static Node[] restoreGraphViewNodes(GraphView graph_view, Node[] nodes, boolean restore_connected_edges) {
        HashSet<Node> restoredNodes = new HashSet<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            NodeView nodeView = graph_view.getNodeView(nodes[i]);
            boolean restored = false;
            if (nodeView == null) {
                nodeView = graph_view.addNodeView(nodes[i].getRootGraphIndex());
                if (nodeView != null) {
                    restored = true;
                }
            } else {
                restored = graph_view.showGraphObject(nodeView);
            }
            if (!restored) continue;
            BasicGraphViewHandler.positionToBarycenter(nodeView);
            restoredNodes.add(nodeView.getNode());
        }
        return restoredNodes.toArray(new Node[restoredNodes.size()]);
    }

    public static int[] restoreGraphViewNodes(GraphView graph_view, int[] node_indices, boolean restore_connected_edges) {
        IntArrayList restoredNodeIndices = new IntArrayList(node_indices.length);
        for (int i = 0; i < node_indices.length; ++i) {
            NodeView nodeView = graph_view.getNodeView(node_indices[i]);
            boolean restored = false;
            if (nodeView == null) {
                nodeView = graph_view.addNodeView(node_indices[i]);
                if (nodeView != null) {
                    restored = true;
                }
            } else {
                restored = graph_view.showGraphObject(nodeView);
            }
            if (!restored) continue;
            restoredNodeIndices.add(node_indices[i]);
            BasicGraphViewHandler.positionToBarycenter(nodeView);
        }
        restoredNodeIndices.trimToSize();
        return restoredNodeIndices.elements();
    }

    public static Node[] selectGraphViewNodes(GraphView graph_view, Node[] nodes) {
        HashSet<Node> selectedNodes = new HashSet<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            NodeView nodeView = graph_view.getNodeView(nodes[i]);
            if (nodeView == null) continue;
            nodeView.setSelected(true);
            selectedNodes.add(nodes[i]);
        }
        return selectedNodes.toArray(new Node[selectedNodes.size()]);
    }

    public static Node[] unselectGraphViewNodes(GraphView graph_view, Node[] nodes) {
        HashSet<Node> unselectedNodes = new HashSet<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            NodeView nodeView = graph_view.getNodeView(nodes[i]);
            if (nodeView == null) continue;
            nodeView.setSelected(false);
            unselectedNodes.add(nodes[i]);
        }
        return unselectedNodes.toArray(new Node[unselectedNodes.size()]);
    }

    public static void positionToBarycenter(NodeView node_view) {
        Node node = node_view.getNode();
        int rootIndex = node.getRootGraphIndex();
        GraphView graphView = node_view.getGraphView();
        GraphPerspective gp = graphView.getGraphPerspective();
        int[] childrenNodeIndices = gp.getNodeMetaChildIndicesArray(rootIndex);
        if (childrenNodeIndices == null || childrenNodeIndices.length == 0) {
            return;
        }
        GraphPerspective childGP = node.getGraphPerspective();
        if (childGP == null || childGP.getNodeCount() == 0) {
            throw new IllegalStateException("Node " + node.getIdentifier() + " has a non-empty array " + " of children-node indices, but, it has no child GraphPerspective");
        }
        List childrenNodeList = childGP.nodesList();
        Iterator it = childrenNodeList.iterator();
        double x = 0.0;
        double y = 0.0;
        double viewableChildren = 0.0;
        while (it.hasNext()) {
            NodeView childNV;
            Node childNode = (Node)it.next();
            if (!gp.containsNode(childNode, false) || (childNV = graphView.getNodeView(childNode.getRootGraphIndex())) == null) continue;
            x += childNV.getXPosition();
            y += childNV.getYPosition();
            viewableChildren += 1.0;
        }
        if (viewableChildren != 0.0) {
            node_view.setXPosition(x /= viewableChildren);
            node_view.setYPosition(y /= viewableChildren);
        }
    }

    public void updateGraphView(GraphView graph_view) {
        int i;
        GraphPerspective graphPerspective = graph_view.getGraphPerspective();
        IntArrayList gpNodeIndices = new IntArrayList(graphPerspective.getNodeIndicesArray());
        IntArrayList gpEdgeIndices = new IntArrayList(graphPerspective.getEdgeIndicesArray());
        IntArrayList gvNodeIndices = new IntArrayList(graph_view.getNodeViewCount());
        IntArrayList gvEdgeIndices = new IntArrayList(graph_view.getEdgeViewCount());
        Iterator it = graph_view.getNodeViewsIterator();
        while (it.hasNext()) {
            NodeView nodeView = (NodeView)it.next();
            Node gvNode = nodeView.getNode();
            if (gvNode == null) {
                System.err.println("Node for nodeView is null (nodeView  = " + nodeView + ")");
                continue;
            }
            int nodeIndex = gvNode.getRootGraphIndex();
            gvNodeIndices.add(nodeIndex);
        }
        it = graph_view.getEdgeViewsIterator();
        while (it.hasNext()) {
            EdgeView edgeView = (EdgeView)it.next();
            Edge gvEdge = edgeView.getEdge();
            if (gvEdge == null) {
                System.err.println("Edge for edgeView is null (edgeView  = " + edgeView + ")");
                continue;
            }
            int edgeIndex = gvEdge.getRootGraphIndex();
            gvEdgeIndices.add(edgeIndex);
        }
        for (i = 0; i < gpNodeIndices.size(); ++i) {
            int nodeIndex = gpNodeIndices.getQuick(i);
            NodeView nodeView = graph_view.getNodeView(nodeIndex);
            if (nodeView == null) {
                graph_view.addNodeView(nodeIndex);
                continue;
            }
            graph_view.showGraphObject(nodeView);
        }
        for (i = 0; i < gpEdgeIndices.size(); ++i) {
            int edgeIndex = gpEdgeIndices.getQuick(i);
            EdgeView edgeView = graph_view.getEdgeView(edgeIndex);
            if (edgeView == null) {
                graph_view.addEdgeView(edgeIndex);
                continue;
            }
            graph_view.showGraphObject(edgeView);
        }
        gvEdgeIndices.removeAll(gpEdgeIndices);
        gvEdgeIndices.trimToSize();
        for (i = 0; i < gvEdgeIndices.size(); ++i) {
            graph_view.removeEdgeView(gvEdgeIndices.getQuick(i));
        }
        gvNodeIndices.removeAll(gpNodeIndices);
        gvNodeIndices.trimToSize();
        for (i = 0; i < gvNodeIndices.size(); ++i) {
            graph_view.removeNodeView(gvNodeIndices.getQuick(i));
        }
    }
}

