/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.shadegrown;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.WindowConstants;

public abstract class WindowUtilities
implements WindowConstants {
    protected static JWindow splashWindow = null;
    protected static JComponent splashContent = null;

    public static void centerWindowOnScreen(Window window) {
        WindowUtilities.centerWindowSize(window);
        WindowUtilities.centerWindowLocation(window);
        window.setVisible(true);
    }

    public static void centerWindowSize(Window window) {
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsConfiguration configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Insets screen_insets = Toolkit.getDefaultToolkit().getScreenInsets(configuration);
        screen_size.width -= screen_insets.left;
        screen_size.width -= screen_insets.right;
        screen_size.height -= screen_insets.top;
        screen_size.height -= screen_insets.bottom;
        Dimension frame_size = window.getSize();
        frame_size.width = (int)((double)screen_size.width * 0.75);
        frame_size.height = (int)((double)screen_size.height * 0.75);
        window.setSize(frame_size);
    }

    public static void centerWindowLocation(Window window) {
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsConfiguration configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Insets screen_insets = Toolkit.getDefaultToolkit().getScreenInsets(configuration);
        screen_size.width -= screen_insets.left;
        screen_size.width -= screen_insets.right;
        screen_size.height -= screen_insets.top;
        screen_size.height -= screen_insets.bottom;
        Dimension frame_size = window.getSize();
        window.setLocation(screen_size.width / 2 - frame_size.width / 2 + screen_insets.left, screen_size.height / 2 - frame_size.height / 2 + screen_insets.top);
    }

    public static void showSplash(ImageIcon image, int milliseconds) {
        WindowUtilities.showSplash(image, milliseconds, true);
    }

    public static void showSplash(ImageIcon image, int milliseconds, boolean start_timer) {
        WindowUtilities.showSplash(new JLabel(image), milliseconds, start_timer);
    }

    public static void showSplash(JComponent content, int milliseconds) {
        WindowUtilities.showSplash(content, milliseconds, true);
    }

    public static void showSplash(JComponent content, int milliseconds, boolean start_timer) {
        WindowUtilities.hideSplash();
        if (splashWindow == null) {
            splashWindow = new JWindow();
        }
        splashContent = content;
        splashWindow.getContentPane().add(splashContent);
        splashWindow.pack();
        WindowUtilities.centerWindowLocation(splashWindow);
        splashWindow.setVisible(true);
        splashContent.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                WindowUtilities.hideSplash();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public static void hideSplash() {
        if (splashWindow != null && splashWindow.isVisible()) {
            splashWindow.setVisible(false);
            if (splashContent != null) {
                splashWindow.getContentPane().remove(splashContent);
                splashContent = null;
            }
        }
    }
}

