/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.CytoscapeAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class CytoscapeMenuBar
extends JMenuBar {
    public static final String DEFAULT_MENU_SPECIFIER = "Tools";
    protected String defaultMenuSpecifier = "Tools";
    protected Set actionMembersSet = null;
    protected Map actionMenuItemMap = null;
    protected Map menuMap = null;
    protected Map menuEffectiveLastIndexMap = null;
    private String identifier;

    public CytoscapeMenuBar() {
        this.initializeCytoscapeMenuBar();
    }

    protected void initializeCytoscapeMenuBar() {
        this.setMinimumSize(this.getMenu("File").getPreferredSize());
    }

    public void setDefaultMenuSpecifier(String menu_name) {
        this.defaultMenuSpecifier = menu_name;
    }

    public String getDefaultMenuSpecifier() {
        return this.defaultMenuSpecifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addAction(Action action) {
        String menu_name = null;
        if (action instanceof CytoscapeAction) {
            if (!((CytoscapeAction)action).isInMenuBar()) return false;
            menu_name = ((CytoscapeAction)action).getPreferredMenu();
            return this.addAction(menu_name, action);
        } else {
            menu_name = DEFAULT_MENU_SPECIFIER;
        }
        return this.addAction(menu_name, action);
    }

    public boolean addAction(String menu_name, Action action) {
        Integer effective_last_index;
        JMenuItem menu_item = null;
        if (this.actionMenuItemMap != null) {
            menu_item = (JMenuItem)this.actionMenuItemMap.get(action);
        }
        if (menu_item != null) {
            return false;
        }
        JMenu menu = this.getMenu(menu_name);
        menu_item = this.createJMenuItem(action);
        Integer index_object = new Integer(-1);
        if (action instanceof CytoscapeAction) {
            index_object = ((CytoscapeAction)action).getPrefferedIndex();
            if (((CytoscapeAction)action).isAccelerated()) {
                menu_item.setAccelerator(KeyStroke.getKeyStroke(((CytoscapeAction)action).getKeyCode(), ((CytoscapeAction)action).getKeyModifiers()));
            }
        }
        if (index_object != null) {
            int index = -1;
            if (index_object instanceof Integer) {
                index = index_object;
            } else if (index_object instanceof String) {
                try {
                    index = Integer.parseInt((String)((Object)index_object));
                }
                catch (NumberFormatException e) {
                    System.err.println("WARNING: The action " + action + " has an \"index\" property but its String value cannot be converted to an int.  Ignoring.");
                    index_object = null;
                }
            } else {
                System.err.println("WARNING: The action " + action + " has an \"index\" property but its value is neither an Integer nor a String.  Ignoring.");
                index_object = null;
            }
            if (index_object != null) {
                if (index < 0) {
                    index = menu.getItemCount() + (index + 1);
                    if (index < 0) {
                        index = 0;
                    } else {
                        if (this.menuEffectiveLastIndexMap == null) {
                            this.menuEffectiveLastIndexMap = this.createMenuEffectiveLastIndexMap();
                        }
                        if ((effective_last_index = (Integer)this.menuEffectiveLastIndexMap.get(menu)) == null) {
                            menu.insertSeparator(index);
                            this.menuEffectiveLastIndexMap.put(menu, new Integer(index));
                            ++index;
                        } else if (effective_last_index >= index) {
                            this.menuEffectiveLastIndexMap.put(menu, new Integer(index));
                        }
                    }
                }
                menu.insert(menu_item, index);
            }
        }
        if (index_object == null) {
            boolean added_it = false;
            if (this.menuEffectiveLastIndexMap != null && (effective_last_index = (Integer)this.menuEffectiveLastIndexMap.get(menu)) != null) {
                menu.insert(menu_item, (int)effective_last_index);
                this.menuEffectiveLastIndexMap.put(menu, new Integer(effective_last_index + 1));
                added_it = true;
            }
            if (!added_it) {
                menu.add(menu_item);
            }
        }
        if (this.actionMenuItemMap == null) {
            this.actionMenuItemMap = this.createActionMenuItemMap();
        }
        this.actionMenuItemMap.put(action, menu_item);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeAction(Action action) {
        if (this.actionMenuItemMap == null) {
            return false;
        }
        JMenuItem menu_item = (JMenuItem)this.actionMenuItemMap.remove(action);
        if (menu_item == null) {
            return false;
        }
        String menu_name = null;
        if (action instanceof CytoscapeAction) {
            if (!((CytoscapeAction)action).isInMenuBar()) return false;
            menu_name = ((CytoscapeAction)action).getPreferredMenu();
        } else {
            menu_name = DEFAULT_MENU_SPECIFIER;
        }
        if (menu_name == null) {
            menu_name = this.defaultMenuSpecifier;
        }
        this.getMenu(menu_name).remove(menu_item);
        return true;
    }

    public JMenu getMenu(String menu_string) {
        if (menu_string == null) {
            menu_string = this.getDefaultMenuSpecifier();
        }
        StringTokenizer st = new StringTokenizer(menu_string, ".");
        JMenu parent_menu = null;
        JMenu menu = null;
        if (this.menuMap == null) {
            this.menuMap = this.createMenuMap();
        }
        while (st.hasMoreTokens()) {
            String menu_token = st.nextToken();
            if (this.menuMap.containsKey(menu_token)) {
                parent_menu = (JMenu)this.menuMap.get(menu_token);
                continue;
            }
            menu = this.createJMenu(menu_token);
            if (parent_menu == null) {
                this.add(menu);
                this.invalidate();
            } else {
                parent_menu.add(menu);
            }
            this.menuMap.put(menu_token, menu);
            parent_menu = menu;
        }
        if (menu == null) {
            return parent_menu;
        }
        return menu;
    }

    public boolean equals(Object other_object) {
        return this == other_object;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String new_identifier) {
        if (this.identifier == null ? new_identifier == null : new_identifier != null && this.identifier.equals(new_identifier)) {
            return;
        }
        String old_identifier = this.identifier;
        this.identifier = new_identifier;
        this.firePropertyChange("identifier", old_identifier, new_identifier);
    }

    public boolean isReidentificationEnabled() {
        return true;
    }

    public String toString() {
        return this.getIdentifier();
    }

    public JMenu createJMenu(String title) {
        JMenu menu = new JMenu(title);
        this.revalidate();
        this.repaint();
        return menu;
    }

    protected JMenuItem createJMenuItem(Action action) {
        return new JMenuItem(action);
    }

    protected Map createActionMenuItemMap() {
        return new HashMap();
    }

    protected Map createMenuMap() {
        return new HashMap();
    }

    protected Map createMenuEffectiveLastIndexMap() {
        return new HashMap();
    }
}

