/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public abstract class CytoscapeAction
extends AbstractAction {
    protected String preferredMenu = null;
    protected String preferredButtonGroup = null;
    protected Integer menuIndex = new Integer(-1);
    protected boolean acceleratorSet = false;
    protected int keyModifiers;
    protected int keyCode;
    private boolean reidentificationEnabled = true;

    public CytoscapeAction() {
        this.initialize();
    }

    public CytoscapeAction(String name) {
        super(name);
        this.initialize();
    }

    public CytoscapeAction(String name, Icon icon) {
        super(name, icon);
        this.initialize();
    }

    public abstract void actionPerformed(ActionEvent var1);

    protected void initialize() {
    }

    public Object clone() {
        return this;
    }

    public boolean isInMenuBar() {
        return true;
    }

    public boolean isInToolBar() {
        return false;
    }

    public void setPreferredIndex(int index) {
        this.menuIndex = new Integer(index);
    }

    public Integer getPrefferedIndex() {
        return this.menuIndex;
    }

    public void setAcceleratorCombo(int key_code, int key_mods) {
        this.acceleratorSet = true;
        this.keyCode = key_code;
        this.keyModifiers = key_mods;
    }

    public boolean isAccelerated() {
        return this.acceleratorSet;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getKeyModifiers() {
        return this.keyModifiers;
    }

    public String getPreferredMenu() {
        return this.preferredMenu;
    }

    public void setPreferredMenu(String new_preferred) {
        if (this.preferredMenu == new_preferred || this.preferredMenu != null && this.preferredMenu.equals(new_preferred)) {
            return;
        }
        String old_preferred = this.preferredMenu;
        this.preferredMenu = new_preferred;
        this.firePropertyChange("preferredMenu", old_preferred, new_preferred);
    }

    public String getPreferredButtonGroup() {
        return this.preferredButtonGroup;
    }

    public void setPreferredButtonGroup(String new_preferred) {
        if (this.preferredButtonGroup.equals(new_preferred)) {
            return;
        }
        String old_preferred = this.preferredButtonGroup;
        this.preferredButtonGroup = new_preferred;
        this.firePropertyChange("preferredButtonGroup", old_preferred, new_preferred);
    }
}

