/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.unitTests;

import cytoscape.CytoscapeConfig;
import cytoscape.unitTests.AllTests;
import java.io.File;
import java.util.Properties;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CytoscapeConfigTest
extends TestCase {
    private static String testDataDirectory = "";

    public CytoscapeConfigTest(String name) {
        super(name);
    }

    public void testAllArgs() throws Exception {
        AllTests.standardOut("testAllArgs");
        String bioDataDirectory = "../data/GO";
        String geometryFilename = "../data/galFiltered.gml";
        String interactionsFilename = "../data/tideker0/yeastSmall.intr";
        String expressionFilename = "../data/tideker0/gal1-20.mrna";
        String nodeAttributeFile1 = "xxx.fooB";
        String nodeAttributeFile2 = "xxx.barA";
        String nodeAttributeFile3 = "xxx.zooC";
        String edgeAttributeFile1 = "xxx.edgeA";
        String edgeAttributeFile2 = "xxx.edgeB";
        String defaultSpeciesName = "Halobacterium sp.";
        String defaultLayoutStrategy = "hierarchical";
        String[] args = new String[]{"-b", bioDataDirectory, "-g", geometryFilename, "-i", interactionsFilename, "-e", expressionFilename, "-n", nodeAttributeFile1, "-n", nodeAttributeFile2, "-n", nodeAttributeFile3, "-j", edgeAttributeFile1, "-j", edgeAttributeFile2, "-s", defaultSpeciesName, "-l", defaultLayoutStrategy, "-h", "-v", "-x"};
        CytoscapeConfig config = new CytoscapeConfig(args);
        CytoscapeConfigTest.assertTrue(config.getBioDataDirectory().equals(bioDataDirectory));
        CytoscapeConfigTest.assertTrue(config.getGeometryFilenames().get(0).equals(geometryFilename));
        CytoscapeConfigTest.assertTrue(config.getInteractionsFilenames().get(0).equals(interactionsFilename));
        CytoscapeConfigTest.assertTrue(config.getExpressionFilename().equals(expressionFilename));
        CytoscapeConfigTest.assertTrue(!config.getWhetherToCopyExpToAttribs());
        CytoscapeConfigTest.assertTrue(config.getNumberOfNodeAttributeFiles() == 3);
        String[] nafs = config.getNodeAttributeFilenames();
        CytoscapeConfigTest.assertTrue(nafs.length == 3);
        for (int i = 0; i < nafs.length; ++i) {
            String af = nafs[i];
            CytoscapeConfigTest.assertTrue(af.equals(nodeAttributeFile1) || af.equals(nodeAttributeFile2) || af.equals(nodeAttributeFile3));
        }
        CytoscapeConfigTest.assertTrue(config.getNumberOfEdgeAttributeFiles() == 2);
        String[] eafs = config.getEdgeAttributeFilenames();
        CytoscapeConfigTest.assertTrue(eafs.length == 2);
        for (int i = 0; i < eafs.length; ++i) {
            String af = eafs[i];
            CytoscapeConfigTest.assertTrue(af.equals(edgeAttributeFile1) || af.equals(edgeAttributeFile2));
        }
        AllTests.standardOut("--------------------- config: \n" + config.toString());
        CytoscapeConfigTest.assertTrue(config.helpRequested());
        CytoscapeConfigTest.assertTrue(config.displayVersion());
        String[] extensions = config.getAllDataFileExtensions();
        CytoscapeConfigTest.assertTrue(config.getAllDataFileNames().length == 8);
        CytoscapeConfigTest.assertTrue(config.getAllDataFileExtensions().length == 8);
        boolean foundFooB = false;
        boolean foundIntr = false;
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i].equals("fooB")) {
                foundFooB = true;
            }
            if (!extensions[i].equals("intr")) continue;
            foundIntr = true;
        }
        CytoscapeConfigTest.assertTrue(config.getDefaultSpeciesName().equals(defaultSpeciesName));
        CytoscapeConfigTest.assertTrue(config.getDefaultLayoutStrategy().equals(defaultLayoutStrategy));
        CytoscapeConfigTest.assertTrue(foundFooB);
        CytoscapeConfigTest.assertTrue(foundIntr);
    }

    public void testReadProjectFile_1() throws Exception {
        AllTests.standardOut("testReadProjectFile_1");
        String projectFilename = testDataDirectory + "src/cytoscape/unitTests/test1.cpr";
        String dir = new File(projectFilename).getAbsoluteFile().getParentFile().getPath();
        String[] args = new String[]{"-p", projectFilename};
        CytoscapeConfig config = new CytoscapeConfig(args);
        CytoscapeConfigTest.assertTrue(config.getProjectFilename().equals(projectFilename));
        CytoscapeConfigTest.assertTrue(config.getGeometryFilenames().get(0).equals(dir + "/galFiltered.gml"));
        CytoscapeConfigTest.assertTrue(config.getInteractionsFilenames().get(0).equals(dir + "/galFiltered.sif"));
        CytoscapeConfigTest.assertTrue(config.getNumberOfNodeAttributeFiles() == 2);
        String[] nafs = config.getNodeAttributeFilenames();
        CytoscapeConfigTest.assertTrue(nafs.length == 2);
        for (int i = 0; i < nafs.length; ++i) {
            String af = nafs[i];
            CytoscapeConfigTest.assertTrue(af.equals(dir + "/nodeAttributes1.noa") || af.equals(dir + "/nodeAttributes2.noa"));
        }
        CytoscapeConfigTest.assertTrue(config.getNumberOfEdgeAttributeFiles() == 2);
        CytoscapeConfigTest.assertTrue(config.getDefaultSpeciesName().equals("Saccharomyces cerevisiae"));
        CytoscapeConfigTest.assertTrue(config.getDefaultLayoutStrategy().equals("hierarchical"));
        CytoscapeConfigTest.assertTrue(config.getBioDataDirectory().equals("rmi://hazel/yeast"));
    }

    public void testReadProjectFile_2() throws Exception {
        AllTests.standardOut("testReadProjectFile_2");
        String projectFilename = testDataDirectory + "src/cytoscape/unitTests/test2.cpr";
        String dir = new File(projectFilename).getAbsoluteFile().getParentFile().getPath();
        String[] args = new String[]{"-p", projectFilename};
        CytoscapeConfig config = new CytoscapeConfig(args);
        CytoscapeConfigTest.assertTrue(config.getProjectFilename().equals(projectFilename));
        CytoscapeConfigTest.assertTrue(config.getGeometryFilenames().get(0).equals(dir + "/galFiltered.gml"));
        CytoscapeConfigTest.assertTrue(config.getInteractionsFilenames().size() == 0);
        CytoscapeConfigTest.assertTrue(config.getNumberOfNodeAttributeFiles() == 2);
        CytoscapeConfigTest.assertTrue(config.getNumberOfEdgeAttributeFiles() == 2);
        String[] nafs = config.getNodeAttributeFilenames();
        CytoscapeConfigTest.assertTrue(nafs.length == 2);
        for (int i = 0; i < nafs.length; ++i) {
            String af = nafs[i];
            CytoscapeConfigTest.assertTrue(af.equals(dir + "/nodeAttributes1.noa") || af.equals(dir + "/nodeAttributes2.noa"));
        }
        CytoscapeConfigTest.assertTrue(config.getNumberOfEdgeAttributeFiles() == 2);
        String[] eafs = config.getEdgeAttributeFilenames();
        CytoscapeConfigTest.assertTrue(eafs.length == 2);
        for (int i = 0; i < eafs.length; ++i) {
            String af = eafs[i];
            CytoscapeConfigTest.assertTrue(af.equals(dir + "/edgeAttributes1.eda") || af.equals(dir + "/edgeAttributes2.eda"));
        }
        CytoscapeConfigTest.assertTrue(config.getDefaultSpeciesName().equals("Saccharomyces cerevisiae"));
        CytoscapeConfigTest.assertTrue(config.getDefaultLayoutStrategy().equals("hierarchical"));
        CytoscapeConfigTest.assertTrue(config.getBioDataDirectory().equals(dir + "/annotationsAndSynonyms"));
    }

    public void testForExpectedNullValues() throws Exception {
        AllTests.standardOut("testForExpectedNullValues");
        String[] args = new String[]{"-h"};
        CytoscapeConfig config = new CytoscapeConfig(args);
        CytoscapeConfigTest.assertTrue(config.getBioDataDirectory() == null);
        CytoscapeConfigTest.assertTrue(config.getGeometryFilenames().size() == 0);
        CytoscapeConfigTest.assertTrue(config.getInteractionsFilenames().size() == 0);
        CytoscapeConfigTest.assertTrue(config.getExpressionFilename() == null);
        CytoscapeConfigTest.assertTrue(config.getAllDataFileNames().length == 0);
        CytoscapeConfigTest.assertTrue(config.getDefaultSpeciesName() == null);
        CytoscapeConfigTest.assertTrue(config.helpRequested());
        CytoscapeConfigTest.assertTrue(config.getWhetherToCopyExpToAttribs());
        CytoscapeConfigTest.assertTrue(!config.inputsError());
    }

    public void testReadProperties() throws Exception {
        AllTests.standardOut("testReadProperties");
        System.setProperty("CYTOSCAPE_HOME", "src/cytoscape/unitTests/");
        String[] args = new String[]{};
        CytoscapeConfig config = new CytoscapeConfig(args);
        Properties props = config.getProperties();
        CytoscapeConfigTest.assertTrue(props.size() > 10);
        CytoscapeConfigTest.assertTrue(config.getDefaultLayoutStrategy().equals("hierarchical"));
        CytoscapeConfigTest.assertTrue(props.getProperty("edge.color.controller").equals("interaction"));
        CytoscapeConfigTest.assertTrue(props.getProperty("edge.color.map.interaction.pd").equals("255,0,0"));
    }

    public void testConfigDirectFromProperties() throws Exception {
        AllTests.standardOut("testConfigDirectFromProperties");
        System.setProperty("CYTOSCAPE_HOME", "src/cytoscape/unitTests/");
        String[] args = new String[]{};
        CytoscapeConfig config = new CytoscapeConfig(args);
        CytoscapeConfigTest.assertTrue(config.getDefaultLayoutStrategy().equals("hierarchical"));
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            testDataDirectory = args[0];
        }
        System.out.println("testDataDirectory: " + testDataDirectory);
        TestRunner.run(new TestSuite(CytoscapeConfigTest.class));
    }
}

