/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.unitTests;

import cytoscape.CyProject;
import java.io.File;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CyProjectTest
extends TestCase {
    public CyProjectTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testAll() throws Exception {
        String filename = "src/cytoscape/unitTests/sampleProject.pro";
        File projectFile = new File(filename);
        File directory = projectFile.getAbsoluteFile().getParentFile();
        CyProject project = new CyProject(filename);
        CyProjectTest.assertTrue(project.getProjectFilename().equals(filename));
        String intName = new File(directory, "network.sif").getPath();
        CyProjectTest.assertTrue(project.getInteractionsFilename().equals(intName));
        String geomName = new File(directory, "network.gml").getPath();
        CyProjectTest.assertTrue(project.getGeometryFilename().equals(geomName));
        String exprName = new File(directory, "yabba.mrna").getPath();
        CyProjectTest.assertTrue(project.getExpressionFilename().equals(exprName));
        CyProjectTest.assertTrue(project.getNumberOfNodeAttributeFiles() == 4);
        String noaName = new File(directory, "age.noa").getPath();
        CyProjectTest.assertTrue(project.getNodeAttributeFilenames()[0].equals(noaName));
        CyProjectTest.assertTrue(project.getNodeAttributeFilenames()[1].endsWith("commonName.noa"));
        CyProjectTest.assertTrue(project.getNodeAttributeFilenames()[2].endsWith("frillycurtainlength.noa"));
        CyProjectTest.assertTrue(project.getNodeAttributeFilenames()[3].endsWith("species.noa"));
        CyProjectTest.assertTrue(project.getNumberOfEdgeAttributeFiles() == 3);
        String edaName = new File(directory, "edgeancillaryname.eda").getPath();
        CyProjectTest.assertTrue(project.getEdgeAttributeFilenames()[0].equals(edaName));
        CyProjectTest.assertTrue(project.getEdgeAttributeFilenames()[1].endsWith("edgeweight.eda"));
        CyProjectTest.assertTrue(project.getEdgeAttributeFilenames()[2].endsWith("interaction.eda"));
        CyProjectTest.assertTrue(project.getBioDataDirectory().equals("jar://privateServer"));
        CyProjectTest.assertTrue(project.getDefaultSpeciesName().equals("Saccharomyces cerevisiae"));
        CyProjectTest.assertTrue(project.getDefaultLayoutStrategy().equals("frisbee"));
        CyProjectTest.assertTrue(project.getProjectPropsFileName().equals("special.props"));
        CyProjectTest.assertTrue(project.getProjectVizmapPropsFileName().equals("vspecial.props"));
        CyProjectTest.assertTrue(!project.getCanonicalize());
        CyProjectTest.assertTrue(project.getOtherArgs().length == 2);
        CyProjectTest.assertTrue(project.getOtherArgs()[0].equals("more"));
        CyProjectTest.assertTrue(project.getOtherArgs()[1].equals("args"));
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(CyProjectTest.class));
    }
}

