/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin.jar;

import cytoscape.Cytoscape;
import cytoscape.plugin.jar.InputStreamProducer;
import java.awt.Toolkit;
import java.beans.Beans;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SimpleClassLoader
extends ClassLoader {
    public static final String urlPrefix = "SIMPLE";
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private static boolean debug = false;
    private static boolean keepLoading = true;
    private String cookie;
    private static Hashtable loaders = new Hashtable();
    public static SimpleClassLoader ourLoader;
    private String localResourceDirectory;
    private Hashtable localOverrides = new Hashtable();
    private Hashtable resourceHash = new Hashtable();
    private Hashtable mimeHash = new Hashtable();
    private Hashtable rawClasses = new Hashtable();

    private SimpleClassLoader(String cookie, String dir) {
        super(Cytoscape.class.getClassLoader());
        this.cookie = cookie;
        this.localResourceDirectory = dir;
        loaders.put(cookie, this);
    }

    public void defineClassFromBytes(String name, byte[] buf) {
        this.rawClasses.put(name, buf);
    }

    private Class applyDefinition(String name, boolean resolve) {
        byte[] buf = (byte[])this.rawClasses.get(name);
        this.rawClasses.remove(name);
        if (buf == null) {
            return null;
        }
        Class<?> c = null;
        try {
            c = super.defineClass(null, buf, 0, buf.length);
            if (c != null && resolve) {
                this.resolveClass(c);
            }
        }
        catch (ClassFormatError e) {
            System.err.println("The definition for " + name + " in the JAR file");
            System.err.println("has a format error.");
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        if (!c.getName().equals(name)) {
            System.err.println("\nWARNING: file name versus class name mismatch");
            String fname = name.replace('.', '/') + ".class";
            System.err.println("    JAR entry \"" + fname + "\" was expected " + "to contain class \"" + name + "\"");
            System.err.println("    but instead contained class \"" + c.getName() + "\"");
            System.err.println("    This may cause future class-loading problems.\n");
        }
        return c;
    }

    private static byte[] getByteArray(String fileName) throws IOException {
        int r;
        File f = new File(fileName);
        int length = (int)f.length();
        byte[] buff = new byte[length];
        FileInputStream is = new FileInputStream(fileName);
        for (int read = 0; read < length && (r = ((InputStream)is).read(buff, read, length - read)) >= 0; read += r) {
        }
        return buff;
    }

    public Class loadClassFromFile(String fileName) throws ClassNotFoundException {
        try {
            byte[] buf = SimpleClassLoader.getByteArray(fileName);
            Class<?> c = super.defineClass(null, buf, 0, buf.length);
            if (c != null) {
                this.resolveClass(c);
            }
            if (c == null) {
                throw new ClassNotFoundException(fileName);
            }
            return c;
        }
        catch (Exception ex) {
            SimpleClassLoader.debug("LoadFromFile/caught " + ex + " when loading from file " + fileName);
            throw new ClassNotFoundException(fileName);
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl == null) {
            cl = this.applyDefinition(name, resolve);
        }
        if (cl == null) {
            try {
                cl = this.findSystemClass(name);
                return cl;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (cl == null && this.getParent() != null) {
            try {
                cl = this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (cl == null) {
            try {
                cl = SimpleClassLoader.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (cl == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instantiate(String name, InputStreamProducer isp) throws ClassNotFoundException, IOException {
        String sname = name.replace('.', '/');
        Object back = null;
        try {
            this.setLocalResourceSource(sname + ".ser", isp);
            back = Beans.instantiate(this, name);
        }
        finally {
            this.localOverrides.remove(sname + ".ser");
        }
        return back;
    }

    public void setLocalResourceSource(String name, InputStreamProducer isp) {
        this.localOverrides.put(name, isp);
    }

    void putClassResource(String name, String type) {
        this.resourceHash.put(name, "A CLASS FILE");
        this.mimeHash.put(name, type);
    }

    void putLocalResource(String name, byte[] data, String type) {
        this.resourceHash.put(name, data);
        this.mimeHash.put(name, type);
    }

    public URL getResource(String name) {
        URL back = SimpleClassLoader.getSystemResource(name);
        if (back != null) {
            return back;
        }
        return this.getLocalResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        InputStream back = SimpleClassLoader.getSystemResourceAsStream(name);
        if (back != null) {
            return back;
        }
        return this.getLocalResourceAsStream(name);
    }

    public byte[] getObjectIfYouWantIt(String name) {
        return (byte[])this.resourceHash.get(name);
    }

    public URL getLocalResource(String name) {
        File f;
        Object o = this.localOverrides.get(name);
        if (o == null) {
            o = this.resourceHash.get(name);
            System.out.println("getLocalResource got: " + o);
        }
        if (o == null && this.localResourceDirectory != null && (f = new File(this.localResourceDirectory, name)).exists()) {
            o = new Integer("1");
        }
        if (o != null) {
            try {
                URL url = new URL("simpleresource", "", "/SIMPLE" + this.cookie + "/+/" + name);
                System.out.println("Returninr URL :" + url);
                return url;
            }
            catch (Exception e) {
                SimpleClassLoader.debug("Exception " + e + " while building a resource URL");
                return null;
            }
        }
        return null;
    }

    private InputStream getLocalResourceAsStream(String name) {
        Object o = this.localOverrides.get(name);
        if (o != null) {
            return ((InputStreamProducer)o).getInputStream();
        }
        o = this.resourceHash.get(name);
        if (o != null) {
            if (o instanceof String) {
                throw new SecurityException("No access through getResource() to .class in 1.1");
            }
            byte[] buf = (byte[])o;
            return new ByteArrayInputStream(buf);
        }
        if (this.localResourceDirectory != null) {
            File f = new File(this.localResourceDirectory, name);
            try {
                return new FileInputStream(f);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static SimpleClassLoader createLoader(String cookie, String dir) {
        SimpleClassLoader back = SimpleClassLoader.getLoader(cookie);
        if (back != null) {
            if (!back.localResourceDirectory.equals(dir)) {
                throw new Error("internal error!");
            }
            return back;
        }
        return new SimpleClassLoader(cookie, dir);
    }

    private static SimpleClassLoader getLoader(String cookie) {
        return (SimpleClassLoader)loaders.get(cookie);
    }

    public static Object getLocalResource(String cookie, String name) {
        File f;
        SimpleClassLoader cl = SimpleClassLoader.getLoader(cookie);
        Object o = cl.localOverrides.get(name);
        if (o != null) {
            return ((InputStreamProducer)o).getInputStream();
        }
        String type = (String)cl.mimeHash.get(name);
        if (type != null) {
            o = cl.resourceHash.get(name);
            if (o instanceof String) {
                throw new SecurityException("No access through getResource() to .class in 1.1");
            }
            byte[] buf = (byte[])o;
            if (type.startsWith("image")) {
                return Toolkit.getDefaultToolkit().createImage(buf).getSource();
            }
            return new ByteArrayInputStream(buf);
        }
        if (cl.localResourceDirectory != null && (f = new File(cl.localResourceDirectory, name)).exists()) {
            try {
                URL url = new URL("file", "", f.getAbsolutePath());
                return url.getContent();
            }
            catch (Exception e) {
                throw new Error("no such resource");
            }
        }
        return null;
    }

    public static InputStream getLocalResourceAsStream(String cookie, String name) {
        SimpleClassLoader cl = SimpleClassLoader.getLoader(cookie);
        return cl.getLocalResourceAsStream(name);
    }

    public synchronized boolean applyDefinitions(Vector classList) {
        boolean back = true;
        Enumeration k = classList.elements();
        while (k.hasMoreElements()) {
            String classname = (String)k.nextElement();
            Class c = this.findLoadedClass(classname);
            if (c != null || (c = this.applyDefinition(classname, true)) != null) continue;
            if (back) {
                System.err.println("NOTE: There are classes that cannot be defined in this JAR file");
                System.err.println("    Some of these classes will cause the failure of defining or linking ");
                System.err.println("    other classes that depend on them.");
                if (keepLoading) {
                    System.err.println("NOTE: To simplify debugging JAR files, we will proceed loading classes");
                    System.err.println("    although this may lead eventually to an UnknownError or the like");
                    System.err.println();
                }
            }
            System.err.println("Class " + classname + " could not be defined from JAR file");
            back = false;
        }
        return back;
    }

    private static void debug(String msg) {
        if (debug) {
            System.err.println("SimpleClassLoader:: " + msg);
        }
    }

    static {
        Properties newP = new Properties(System.getProperties());
        newP.put(protocolPathProp, newP.getProperty(protocolPathProp) + "|sun.beanbox");
        System.setProperties(newP);
        ourLoader = SimpleClassLoader.createLoader("BeanBox", null);
    }
}

