/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin.jar;

import cytoscape.Cytoscape;
import cytoscape.plugin.AbstractPlugin;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.plugin.NotAPluginException;
import cytoscape.plugin.PluginAlreadyRegisteredException;
import cytoscape.plugin.jar.JarInfo;
import cytoscape.plugin.jar.Manifest;
import cytoscape.plugin.jar.MessageHeader;
import cytoscape.plugin.jar.SimpleClassLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipInputStream;

public class JarLoader {
    private static boolean debug = false;
    private InputStream jarStream;
    private String jarName;
    private static SimpleClassLoader loader;
    private static boolean warnedAboutNoBeans;

    public JarLoader(String jarName) throws IOException, MalformedURLException {
        JarLoader.debug("(" + jarName + ")");
        this.jarName = jarName;
        InputStream is = null;
        if (jarName.startsWith("http://") || jarName.startsWith("file://")) {
            URL url = new URL(jarName);
            is = url.openStream();
        } else {
            is = new FileInputStream(jarName);
        }
        this.jarStream = new BufferedInputStream(is);
        loader = SimpleClassLoader.ourLoader;
    }

    public static SimpleClassLoader getLoader() {
        return loader;
    }

    private String guessContentTypeFromStream(InputStream is) throws IOException {
        String type = URLConnection.guessContentTypeFromStream(is);
        if (type == null) {
            is.mark(10);
            int c1 = is.read();
            int c2 = is.read();
            int c3 = is.read();
            int c4 = is.read();
            int c5 = is.read();
            int c6 = is.read();
            is.reset();
            if (c1 == 172 && c2 == 237) {
                type = "application/java-serialized-object";
            }
        }
        return type;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JarInfo loadJar() throws IOException {
        block25: {
            block24: {
                block23: {
                    block22: {
                        block19: {
                            block20: {
                                zis = null;
                                mf = null;
                                classList = new Vector<String>();
                                serList = new Vector<String>();
                                buffer = new byte[1024];
                                empty = true;
                                try {
                                    try {
                                        zis = new ZipInputStream(this.jarStream);
                                        ent = null;
lbl11:
                                        // 5 sources

                                        while (true) {
                                            ent = zis.getNextEntry();
                                            if (ent != null) {
                                                empty = false;
                                                name = ent.getName();
                                                type = null;
                                                baos = new ByteArrayOutputStream();
                                                break block19;
                                            }
                                            var15_22 = null;
                                            if (zis == null) break block20;
                                            break;
                                        }
                                    }
                                    catch (IOException ex) {
                                        JarLoader.debug("IOException loading archive: " + ex);
                                        throw ex;
                                    }
                                    catch (Throwable th) {
                                        JarLoader.debug("Caught " + th + " in loadit()");
                                        th.printStackTrace();
                                        throw new IOException("loadJar caught: " + th);
                                    }
                                }
                                catch (Throwable var14_26) {
                                    var15_23 = null;
                                    if (zis == null) throw var14_26;
                                    try {
                                        zis.close();
                                        throw var14_26;
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    throw var14_26;
                                }
                                try {}
                                catch (Exception ex) {}
                                zis.close();
                            }
                            if (empty) {
                                throw new IOException("JAR file is corrupt or empty");
                            }
                            ji = this.createJarInfo(classList, serList, mf);
                            totalEntries = 0;
                            totalClasses = 0;
                            totalPlugins = 0;
                            entries = classList.elements();
                            try {
                                while (entries.hasMoreElements() != false) {
                                    ++totalEntries;
                                    entry_o = entries.nextElement();
                                    entry_s = entry_o.toString();
                                    ++totalClasses;
                                    className = entry_s;
                                    if (!this.isClassPlugin(className)) continue;
                                    ++totalPlugins;
                                    this.invokePlugin(className);
                                }
                                return ji;
                            }
                            catch (Exception e) {
                                System.err.println("Exception Loading jar.");
                                e.printStackTrace();
                                return ji;
                            }
                        }
                        while (true) {
                            if ((len = zis.read(buffer)) < 0) {
                                buf = baos.toByteArray();
                                size = buf.length;
                                if (Manifest.isManifestName(name)) {
                                    break;
                                }
                                break block22;
                            }
                            baos.write(buffer, 0, len);
                        }
                        type = "manifest/manifest";
                    }
                    if (type == null) {
                        tmpStream = new ByteArrayInputStream(buf);
                        type = this.guessContentTypeFromStream(tmpStream);
                        tmpStream.close();
                    }
                    if (type == null) {
                        type = "input-stream/input-stream";
                    }
                    if (!type.startsWith("application/java-serialized-object") && !type.startsWith("application/x-java-serialized-object")) break block23;
                    JarLoader.loader.putLocalResource(name, buf, type);
                    sername = name.substring(0, name.length() - 4);
                    sername = sername.replace('/', '.');
                    serList.addElement(sername);
                    ** GOTO lbl11
                }
                if (!type.startsWith("application/java-vm") && !type.startsWith("application/x-java-vm")) break block24;
                JarLoader.loader.putClassResource(name, type);
                classname = name.substring(0, name.length() - 6);
                classname = classname.replace('/', '.');
                JarLoader.loader.defineClassFromBytes(classname, buf);
                classList.addElement(classname);
                ** GOTO lbl11
            }
            if (!type.equals("manifest/manifest")) break block25;
            mf = new Manifest(buf);
            ** GOTO lbl11
        }
        JarLoader.loader.putLocalResource(name, buf, type);
        ** while (true)
    }

    protected void invokePlugin(String name) {
        try {
            Cytoscape.getCytoscapeObj().getPluginRegistry().addPluginToRegistry(Class.forName(name, false, JarLoader.getLoader()));
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error: plugin class " + name + " was not found.\n");
        }
        catch (NotAPluginException e) {
            System.err.println("Error: plugin class " + name + " is not a plugin.\n");
        }
        catch (PluginAlreadyRegisteredException e) {
            System.err.println("Error: plugin class " + name + " already Registered.\n");
        }
        catch (Exception e) {
            System.out.println("Error Invoking " + name);
            e.printStackTrace();
        }
    }

    protected boolean isClassPlugin(String name) throws ClassNotFoundException {
        Class<?> c = Class.forName(name, false, JarLoader.getLoader());
        Class p = AbstractPlugin.class;
        Class cp = CytoscapePlugin.class;
        return p.isAssignableFrom(c) || cp.isAssignableFrom(c);
    }

    public static void loadJar(String jarFile) throws IOException {
        JarLoader jl = new JarLoader(jarFile);
        JarInfo ji = jl.loadJar();
        if (ji == null) {
            System.err.println("JAR file " + jarFile + " did not load properly!");
            System.err.println("Check for error messages possibly regarding");
            System.err.println("problems defining classes");
            return;
        }
    }

    private JarInfo createJarInfo(Vector classList, Vector serList, Manifest mf) {
        Hashtable<String, Boolean> beans;
        Hashtable<String, MessageHeader> headersTable = new Hashtable<String, MessageHeader>();
        if (mf == null) {
            beans = new Hashtable<String, Boolean>();
        } else {
            beans = new Hashtable();
            Enumeration entries = mf.entries();
            while (entries.hasMoreElements()) {
                String beanName;
                MessageHeader mh = (MessageHeader)entries.nextElement();
                String name = mh.findValue("Name");
                String isBean = mh.findValue("Java-Bean");
                if (isBean == null || !isBean.equalsIgnoreCase("True")) continue;
                boolean fromPrototype = true;
                if (name.endsWith(".class")) {
                    fromPrototype = false;
                    beanName = name.substring(0, name.length() - 6);
                } else {
                    beanName = name.endsWith(".ser") ? name.substring(0, name.length() - 4) : name;
                }
                beanName = beanName.replace('/', '.');
                beans.put(beanName, new Boolean(fromPrototype));
                headersTable.put(beanName, mh);
            }
        }
        String[] beanNames = new String[beans.size()];
        boolean[] fromPrototype = new boolean[beans.size()];
        MessageHeader[] headers = new MessageHeader[beans.size()];
        Enumeration keys = beans.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String key;
            beanNames[i] = key = (String)keys.nextElement();
            fromPrototype[i] = (Boolean)beans.get(key);
            headers[i] = (MessageHeader)headersTable.get(key);
            ++i;
        }
        return new JarInfo(this.jarName, loader, beanNames, fromPrototype, headers);
    }

    private static void debug(String msg) {
        if (debug) {
            System.err.println("JarLoader:: " + msg);
        }
    }
}

