/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin.jar;

import cytoscape.plugin.jar.MessageHeader;
import cytoscape.plugin.jar.ObjectInputStreamLoader;
import cytoscape.plugin.jar.SimpleClassLoader;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class JarInfo {
    private SimpleClassLoader classLoader;
    private String[] beanNames;
    private BeanInfo[] beanInfos;
    private boolean[] fromPrototype;
    private MessageHeader[] manifestData;
    private String jarName;
    private static Hashtable beanToJar = new Hashtable();
    private static boolean debug = false;

    public JarInfo(String jarName, SimpleClassLoader cl, String[] beanNames, boolean[] fromPrototype, MessageHeader[] manifestData) {
        if (beanNames.length != fromPrototype.length) {
            throw new Error("beanNames and fromPrototype need to have the same length");
        }
        this.jarName = jarName;
        this.classLoader = cl;
        this.beanNames = beanNames;
        this.fromPrototype = fromPrototype;
        this.manifestData = manifestData;
        this.beanInfos = new BeanInfo[beanNames.length];
        for (int i = 0; i < beanNames.length; ++i) {
            BeanInfo bi;
            Class c;
            beanToJar.put(beanNames[i], jarName);
            if (fromPrototype[i]) continue;
            try {
                c = cl.loadClass(beanNames[i]);
            }
            catch (Exception ex) {
                continue;
            }
            try {
                bi = Introspector.getBeanInfo(c);
            }
            catch (Exception ex) {
                System.err.println("JarInfo: couldn't find BeanInfo for " + c + "; caught " + ex);
                continue;
            }
            this.beanInfos[i] = bi;
            JarInfo.debug("JarInfo:: @ " + i + "; beanName: " + beanNames[i] + "; fromPrototype: " + fromPrototype[i]);
        }
    }

    public static String getJarName(String beanName) {
        return (String)beanToJar.get(beanName);
    }

    public String getJarName() {
        return this.jarName;
    }

    public int getCount() {
        return this.beanNames.length;
    }

    public BeanInfo getBeanInfo(int i) {
        if (this.beanInfos[i] != null) {
            return this.beanInfos[i];
        }
        Object b = this.getInstance(this.beanNames[i]);
        if (b != null) {
            BeanInfo bi;
            Class<?> c = b.getClass();
            try {
                bi = Introspector.getBeanInfo(c);
            }
            catch (Exception ex) {
                System.err.println("JarInfo: couldn't find BeanInfo for " + c + "; caught " + ex);
                return null;
            }
            this.beanInfos[i] = bi;
            return bi;
        }
        return null;
    }

    public String getName(int i) {
        return this.beanNames[i];
    }

    public boolean isFromPrototype(String name) {
        return this.fromPrototype[this.indexForName(name)];
    }

    public MessageHeader getManifestData(String name) {
        return this.manifestData[this.indexForName(name)];
    }

    public Object getInstance(String name) {
        try {
            return Beans.instantiate(this.classLoader, name);
        }
        catch (Throwable th) {
            this.diagnoseInstantiationException(this.classLoader, name, th);
            System.err.println("");
            if (name.indexOf(92) >= 0) {
                System.err.println("    Note that file names in manifests must use forward slashes \"/\" \n    rather than back-slashes \"\\\"");
            }
            return null;
        }
    }

    void diagnoseInstantiationException(SimpleClassLoader cl, String beanName, Throwable realx) {
        Class cls;
        System.err.print("\nWARNING: Could not instantiate bean \"" + beanName + "\"");
        if (cl == null) {
            System.err.println(" from the system class-loader");
            return;
        }
        System.err.println(" from JAR \"" + this.jarName + "\"");
        String serName = beanName.replace('.', '/').concat(".ser");
        InputStream ins = cl.getResourceAsStream(serName);
        if (ins != null) {
            System.err.println("    We found a serialized template file \"" + serName + "\"");
            try {
                ObjectInputStreamLoader oins = new ObjectInputStreamLoader(ins, cl);
                Object result = oins.readObject();
                System.err.println("    An object could be read from the serialized template OK.");
                System.err.println("    But an exception was generated in Beans.instantiate:");
                System.err.println("        " + realx);
            }
            catch (ObjectStreamException ex) {
                System.err.println("    But caught an ObjectStreamException while reading the serialized object:");
                System.err.println("        " + ex);
                System.err.println("    This indicates there is a problem with the contents of the template file.");
            }
            catch (IOException ex) {
                System.err.println("    But caught an IOException while reading the serialized object:");
                System.err.println("        " + ex);
            }
            catch (ClassNotFoundException ex) {
                System.err.println("    But caught a ClassNotFoundException while reading the serialized object:");
                System.err.println("        " + ex);
                System.err.println("    This indicates that there was a problem finding a .class file for one");
                System.err.println("    of the serialized objects");
            }
            catch (Throwable th) {
                System.err.println("    But caught an unexpected exception while reading the serialized object:");
                System.err.println("        " + th);
            }
            try {
                ins.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        try {
            String classFileName = beanName.replace('.', '/').concat(".class");
            ins = cl.getResourceAsStream(classFileName);
            if (ins == null) {
                System.err.println("    We couldn't open the class file \"" + classFileName + "\" in the JAR");
                return;
            }
            System.err.println("    We found the class file \"" + classFileName + "\"");
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        String pkg = "the default package";
        String className = beanName;
        if (beanName.lastIndexOf(46) > 0) {
            pkg = "the package \"" + beanName.substring(0, beanName.lastIndexOf(46)) + "\"";
            className = beanName.substring(beanName.lastIndexOf(46) + 1);
        }
        try {
            cls = cl.loadClass(beanName);
        }
        catch (Exception ex) {
            System.err.println("    But were unable to load the class \"" + beanName + "\" because of");
            System.err.println("        " + ex);
            System.err.println("    Common reasons for this failure include:");
            System.err.println("    (1) The class is not defined in the correct package");
            System.err.println("        it should be in " + pkg);
            System.err.println("    (2) The class has not been given the correct name");
            System.err.println("    it should be called \"" + className + "\"");
            System.err.println("    (3) The class file contains the wrong class or no class at all");
            return;
        }
        catch (Throwable th) {
            System.err.println("    But were unable to load the class \"" + beanName + "\" because of");
            System.err.println("        " + th);
            if (th instanceof ClassFormatError && th.getMessage().equals("Duplicate name")) {
                System.err.println("    This particular error is often caused by having a mismatch between the name of");
                System.err.println("    the .class file and the name of the contained class.");
                System.err.println("    In this case make sure that class file contains a class");
                System.err.println("    called \"" + className + "\" in " + pkg + ".");
            } else {
                th.printStackTrace();
            }
            return;
        }
        System.err.println("    We located the class \"" + beanName + "\" OK");
        int mods = cls.getModifiers();
        if (!Modifier.isPublic(mods)) {
            System.err.println("    But the class was not declared public, so we could not create a bean");
            return;
        }
        try {
            Class[] args = new Class[]{};
            Constructor cons = cls.getConstructor(args);
            if (cons == null) {
                System.err.println("    But the class did not have a zero-arg constructor.");
                System.err.println("    All beans must provide public zero-arg constructors.");
                return;
            }
            mods = cons.getModifiers();
            if (!Modifier.isPublic(mods)) {
                System.err.println("    But the class's zero-arg constructor was not declared public");
                System.err.println("    All beans must provide public zero-arg constructors.");
                return;
            }
        }
        catch (NoSuchMethodException ex) {
            System.err.println("    But the class did not have a zero-arg constructor.");
            System.err.println("    All beans must provide public zero-arg constructors.");
            return;
        }
        catch (Throwable th) {
            System.err.println("    Unexpected exception in disgnoseInstantiationException");
            System.err.println("    " + th);
            th.printStackTrace();
            return;
        }
        System.err.println("    The class provides a public zero-arg constructor");
        try {
            Object obj = cls.newInstance();
        }
        catch (Throwable th) {
            System.err.println("    But were unable to create an instance of the class because we");
            System.err.println("    got an exception while doing Class.newInstance() :");
            System.err.println("       " + th);
            System.err.println("    The stack backtrace at the time of this exception is");
            th.printStackTrace();
            return;
        }
        System.err.println("    But an exception was generated in Beans.instantiate:");
        System.err.println("        " + realx);
        realx.printStackTrace();
    }

    private int indexForName(String name) {
        for (int i = 0; i < this.beanNames.length; ++i) {
            if (!this.beanNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static void debug(String msg) {
        if (debug) {
            System.err.println("JarInfo:: " + msg);
        }
    }
}

