/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class JarEntrySource {
    private boolean markOnly;
    private String name;
    private InputStream is;
    private File file;
    private long modifiedTime;

    public JarEntrySource(File file) {
        this.markOnly = false;
        this.name = file.getPath().replace(File.separatorChar, '/');
        this.file = file;
    }

    public JarEntrySource(String name, File file) {
        this.markOnly = false;
        this.name = name;
        this.file = file;
    }

    public JarEntrySource(String name, InputStream is) {
        this.markOnly = false;
        this.name = name;
        this.is = is;
    }

    public JarEntrySource(String name) {
        this.markOnly = true;
        this.name = name;
    }

    public boolean isMarkOnly() {
        return this.markOnly;
    }

    public long getTime() {
        if (this.file != null) {
            return this.file.lastModified();
        }
        return 0L;
    }

    public long getLength() {
        if (this.file != null) {
            return this.file.length();
        }
        return 0L;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return this.is;
    }
}

