/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.plugin.AbstractPlugin;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.plugin.NotAPluginException;
import cytoscape.plugin.PluginAlreadyRegisteredException;
import cytoscape.plugin.PluginEvent;
import cytoscape.plugin.PluginListener;
import cytoscape.plugin.PluginUpdateList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PluginRegistry {
    protected List registry = Collections.synchronizedList(new ArrayList());
    protected List listeners = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginUpdateList getPluginsLoadedSince(long time) {
        long timestamp;
        LinkedList<Class> newPlugins = new LinkedList<Class>();
        List list = this.registry;
        synchronized (list) {
            timestamp = System.currentTimeMillis();
            Iterator iter = this.registry.iterator();
            while (iter.hasNext()) {
                PluginRegistryNode node = (PluginRegistryNode)iter.next();
                if (node.loadTime < time) continue;
                newPlugins.add(node.plugin);
            }
        }
        Class[] newPlugin = new Class[newPlugins.size()];
        newPlugins.toArray(newPlugin);
        return new PluginUpdateList(timestamp, newPlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginToRegistry(Class plugin) throws NotAPluginException, PluginAlreadyRegisteredException {
        long now;
        if (!AbstractPlugin.class.isAssignableFrom(plugin) && !CytoscapePlugin.class.isAssignableFrom(plugin)) {
            throw new NotAPluginException("class: " + plugin.getName() + "is not a plugin");
        }
        if (this.pluginRegistryContains(plugin.getName())) {
            throw new PluginAlreadyRegisteredException("plugin already loaded: " + plugin.getName());
        }
        PluginRegistryNode newNode = new PluginRegistryNode();
        newNode.plugin = plugin;
        newNode.loadTime = now = System.currentTimeMillis();
        List list = this.registry;
        synchronized (list) {
            this.registry.add(newNode);
        }
        list = this.listeners;
        synchronized (list) {
            long timestamp = System.currentTimeMillis();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((PluginListener)iter.next()).pluginRegistryChanged(new PluginEvent(timestamp, "Plugin Added"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pluginRegistryContains(String pluginName) {
        List list = this.registry;
        synchronized (list) {
            Iterator iter = this.registry.iterator();
            while (iter.hasNext()) {
                PluginRegistryNode node = (PluginRegistryNode)iter.next();
                if (!node.plugin.getName().equals(pluginName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginListener(PluginListener l) {
        List list = this.registry;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginListener(PluginListener l) {
        List list = this.registry;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    protected class PluginRegistryNode {
        public Class plugin;
        public long loadTime;

        protected PluginRegistryNode() {
        }
    }
}

