/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.CytoscapeObj;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class PluginLoader {
    protected CytoscapeObj cyObject;
    protected StringBuffer messageBuffer;

    public PluginLoader(CytoscapeObj cyObject) {
        this.cyObject = cyObject;
        this.messageBuffer = new StringBuffer();
    }

    public Vector getClassesToLoad(Properties props) {
        Vector<String> classesToLoad = new Vector<String>();
        Enumeration<?> enu = props.propertyNames();
        while (enu.hasMoreElements()) {
            String propName = (String)enu.nextElement();
            if (!propName.startsWith("plugin.") || !propName.endsWith(".load")) continue;
            String className = props.getProperty(propName);
            if (className == null || className.length() <= 0) {
                this.messageBuffer.append("PluginLoader ignoring empty plugin.*.load property\n");
                continue;
            }
            this.messageBuffer.append("PluginLoader loading class: " + className + "\n");
            classesToLoad.add(new String(className));
        }
        return classesToLoad;
    }

    public void load(Properties props) {
        Vector classNames = this.getClassesToLoad(props);
        Collections.sort(classNames);
        Iterator li = classNames.iterator();
        while (li.hasNext()) {
            String className = (String)li.next();
            this.loadPlugin(className);
        }
    }

    protected void loadPlugin(String className) {
        try {
            Class<?> pluginClass = Class.forName(className);
            this.cyObject.getPluginRegistry().addPluginToRegistry(pluginClass);
        }
        catch (Exception e) {
            System.err.println("Plugin Not Loaded: " + className);
        }
    }

    public String getMessages() {
        return this.messageBuffer.toString();
    }
}

