/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.CytoscapeObj;
import cytoscape.actions.LoadPluginDirectoryAction;
import cytoscape.actions.LoadPluginListAction;
import cytoscape.plugin.jar.JarLoader;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

public class JarLoaderCommandLineParser {
    protected CytoscapeObj cyObj;
    protected StringBuffer messageBuffer;

    public JarLoaderCommandLineParser(CytoscapeObj cyObj) {
        this.cyObj = cyObj;
        this.messageBuffer = new StringBuffer();
    }

    public void usage() {
        System.err.println("jarLoader command line arguments:");
        System.err.println("    --JLD  <string>   local directory containing .jar files");
        System.err.println("    --JLW  <URL>      URL of a .jar file to load");
        System.err.println("    --JLL  <URL>      URL of a list of .jar files to load");
        System.err.println("    --JLH             prints this help");
    }

    public void parseArgs(String[] args) {
        int c;
        if (args == null || args.length == 0) {
            return;
        }
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("JLD", 1, null, 0), new LongOpt("JLW", 1, null, 1), new LongOpt("JLL", 1, null, 2), new LongOpt("JLH", 0, null, 3)};
        Getopt g = new Getopt("jarLoader", args, "", longOpts);
        g.setOpterr(false);
        boolean helpRequested = false;
        block8: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 0: {
                    String tmp = g.getOptarg();
                    this.messageBuffer.append("Command line to load jars from directory: " + tmp);
                    LoadPluginDirectoryAction lpda = new LoadPluginDirectoryAction();
                    lpda.setDir(tmp);
                    lpda.tryDirectory();
                    continue block8;
                }
                case 1: {
                    String tmp = g.getOptarg();
                    try {
                        JarLoader.loadJar(tmp);
                    }
                    catch (Exception e) {
                        System.err.println("Error loading jar: " + e.getMessage());
                    }
                    continue block8;
                }
                case 2: {
                    String tmp = g.getOptarg();
                    LoadPluginListAction lpla = new LoadPluginListAction(this.cyObj);
                    lpla.parsePluginList(tmp);
                    continue block8;
                }
                case 3: {
                    String tmp = g.getOptarg();
                    helpRequested = true;
                    continue block8;
                }
            }
        }
        if (helpRequested) {
            this.usage();
        }
    }

    public String getMessages() {
        return this.messageBuffer.toString();
    }
}

