/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.data.GraphObjAttributes;
import cytoscape.util.GinyFactory;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import giny.util.SpringEmbeddedLayouter;
import giny.view.GraphView;
import giny.view.NodeView;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeLayout {
    public static final int DO_LAYOUT = 0;
    public static final int CREATE_EDGES = 1;
    public static final int CLEAR_OBJECTS = 2;
    CyNetworkView cyWindow;
    protected int[] categoryNodes;
    protected int[] createdEdges;

    public AttributeLayout(CyNetworkView cyWindow) {
        this.cyWindow = cyWindow;
    }

    public void doCallback(String attributeName, int functionToPerform) {
        if (functionToPerform == 0) {
            this.doLayout(attributeName);
        } else if (functionToPerform == 1) {
            this.createEdges(attributeName);
        } else if (functionToPerform == 2) {
            this.clearPreviousGraphObjects();
        }
    }

    public void clearPreviousGraphObjects() {
        int i;
        RootGraph rootGraph = this.cyWindow.getNetwork().getRootGraph();
        if (this.categoryNodes != null) {
            for (i = 0; i < this.categoryNodes.length; ++i) {
                rootGraph.removeNode(this.categoryNodes[i]);
            }
            this.categoryNodes = null;
        }
        if (this.createdEdges != null) {
            for (i = 0; i < this.createdEdges.length; ++i) {
                rootGraph.removeEdge(this.createdEdges[i]);
            }
            this.createdEdges = null;
        }
        this.cyWindow.redrawGraph(false, false);
    }

    public void doLayout(String attributeName) {
        NodeView nv;
        this.clearPreviousGraphObjects();
        Map valueMap = this.buildValueMap(attributeName);
        if (valueMap.size() == 0) {
            return;
        }
        GraphPerspective realGP = this.cyWindow.getNetwork().getGraphPerspective();
        GraphPerspective layoutGP = (GraphPerspective)realGP.clone();
        RootGraph rootGraph = realGP.getRootGraph();
        GraphObjAttributes nodeAttributes = this.cyWindow.getNetwork().getNodeAttributes();
        int[] currentEdges = layoutGP.getEdgeIndicesArray();
        layoutGP.hideEdges(currentEdges);
        int newNodeCount = valueMap.size();
        int newEdgeCount = 0;
        Iterator es = valueMap.keySet().iterator();
        while (es.hasNext()) {
            Object key = es.next();
            Set nodeSet = (Set)valueMap.get(key);
            newEdgeCount += nodeSet.size();
        }
        this.categoryNodes = new int[newNodeCount];
        int[] newEdges = new int[newEdgeCount];
        int nodeIndex = 0;
        int edgeIndex = 0;
        Iterator mi = valueMap.keySet().iterator();
        while (mi.hasNext()) {
            int categoryInt;
            Object category = mi.next();
            this.categoryNodes[nodeIndex] = categoryInt = rootGraph.createNode();
            ++nodeIndex;
            String categoryName = category.toString();
            if (categoryName.length() > 50) {
                categoryName = categoryName.substring(50) + "...";
            }
            Node node = rootGraph.getNode(categoryInt);
            nodeAttributes.addNameMapping(categoryName, node);
            nodeAttributes.set("commonName", categoryName, categoryName);
            Set nodeSet = (Set)valueMap.get(category);
            Iterator si = nodeSet.iterator();
            while (si.hasNext()) {
                int edge;
                Node targetNode = (Node)si.next();
                int index = rootGraph.getIndex(targetNode);
                newEdges[edgeIndex] = edge = rootGraph.createEdge(categoryInt, index);
                ++edgeIndex;
            }
        }
        layoutGP.restoreNodes(this.categoryNodes);
        layoutGP.restoreEdges(newEdges);
        GraphView layoutView = GinyFactory.createGraphView(layoutGP);
        SpringEmbeddedLayouter layouter = new SpringEmbeddedLayouter(layoutView);
        layouter.doLayout();
        rootGraph.removeEdges(newEdges);
        realGP.restoreNodes(this.categoryNodes);
        CyNetworkView realView = this.cyWindow;
        Iterator vi = realView.getNodeViewsIterator();
        while (vi.hasNext()) {
            nv = (NodeView)vi.next();
            NodeView layoutV = layoutView.getNodeView(nv.getNode());
            nv.setXPosition(layoutV.getXPosition(), false);
            nv.setYPosition(layoutV.getYPosition(), false);
        }
        vi = realView.getNodeViewsIterator();
        while (vi.hasNext()) {
            nv = (NodeView)vi.next();
            nv.setNodePosition(true);
        }
        this.cyWindow.redrawGraph(false, true);
        realView.fitContent();
    }

    public void createEdges(String attributeName) {
        this.clearPreviousGraphObjects();
        Map valueMap = this.buildValueMap(attributeName);
        if (valueMap.size() == 0) {
            return;
        }
        GraphPerspective gp = this.cyWindow.getNetwork().getGraphPerspective();
        RootGraph rootGraph = gp.getRootGraph();
        GraphObjAttributes nodeAttributes = this.cyWindow.getNetwork().getNodeAttributes();
        GraphObjAttributes edgeAttributes = this.cyWindow.getNetwork().getEdgeAttributes();
        int edgeCount = 0;
        Iterator mi = valueMap.keySet().iterator();
        while (mi.hasNext()) {
            Object key = mi.next();
            Set nodeSet = (Set)valueMap.get(key);
            int setSize = nodeSet.size();
            edgeCount += setSize * (setSize - 1) / 2;
        }
        this.createdEdges = new int[edgeCount];
        int edgeIndex = 0;
        Iterator mi2 = valueMap.keySet().iterator();
        while (mi2.hasNext()) {
            Object category = mi2.next();
            String categoryName = category.toString();
            if (categoryName.length() > 50) {
                categoryName = categoryName.substring(50) + "...";
            }
            Set nodeSet = (Set)valueMap.get(category);
            Node[] nodeArray = nodeSet.toArray(new Node[0]);
            for (int i = 0; i < nodeArray.length - 1; ++i) {
                Node firstNode = nodeArray[i];
                String firstName = nodeAttributes.getCanonicalName(firstNode);
                for (int j = i + 1; j < nodeArray.length; ++j) {
                    int edgeInt;
                    Node secondNode = nodeArray[j];
                    String secondName = nodeAttributes.getCanonicalName(secondNode);
                    this.createdEdges[edgeIndex] = edgeInt = rootGraph.createEdge(firstNode, secondNode);
                    ++edgeIndex;
                    String edgeName = firstName + " (" + categoryName + ") " + secondName;
                    Edge edge = rootGraph.getEdge(edgeInt);
                    gp.restoreEdge(edge);
                    edgeAttributes.addNameMapping(edgeName, edge);
                }
            }
        }
        this.cyWindow.redrawGraph(false, true);
    }

    public Map buildValueMap(String attributeName) {
        HashMap<Object, HashSet<Node>> returnMap = new HashMap<Object, HashSet<Node>>();
        if (attributeName == null) {
            return returnMap;
        }
        GraphObjAttributes nodeAttributes = this.cyWindow.getNetwork().getNodeAttributes();
        GraphPerspective gp = this.cyWindow.getNetwork().getGraphPerspective();
        HashMap attrMap = nodeAttributes.getAttribute(attributeName);
        if (attrMap == null || attrMap.size() == 0) {
            return returnMap;
        }
        Iterator ni = gp.nodesIterator();
        while (ni.hasNext()) {
            Object attrValue;
            Node node = (Node)ni.next();
            String canonicalName = nodeAttributes.getCanonicalName(node);
            if (canonicalName == null || canonicalName.length() == 0 || (attrValue = attrMap.get(canonicalName)) == null) continue;
            if (attrValue instanceof List) {
                List theList = (List)attrValue;
                Iterator li = theList.iterator();
                while (li.hasNext()) {
                    Object value = li.next();
                    if (value == null) continue;
                    HashSet<Node> nodeSet = (HashSet<Node>)returnMap.get(value);
                    if (nodeSet == null) {
                        nodeSet = new HashSet<Node>();
                        returnMap.put(value, nodeSet);
                    }
                    nodeSet.add(node);
                }
                continue;
            }
            HashSet<Node> nodeSet = (HashSet<Node>)returnMap.get(attrValue);
            if (nodeSet == null) {
                nodeSet = new HashSet<Node>();
                returnMap.put(attrValue, nodeSet);
            }
            nodeSet.add(node);
        }
        return returnMap;
    }
}

