/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.Cytoscape;
import cytoscape.layout.LayoutAlgorithm;
import cytoscape.util.CytoscapeProgressMonitor;
import cytoscape.util.SwingWorker;
import cytoscape.view.CyNetworkView;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractLayout
implements LayoutAlgorithm {
    protected Set staticNodes;
    protected CyNetworkView networkView;
    protected GraphPerspective network;
    protected Dimension currentSize = new Dimension(20, 20);
    protected int lengthOfTask;
    protected int currentProgress;
    protected boolean done;
    protected boolean canceled;
    protected String statMessage;
    protected String taskName;

    public AbstractLayout(CyNetworkView networkView) {
        this.networkView = networkView;
        this.staticNodes = new HashSet();
        this.network = networkView.getNetwork();
    }

    public abstract Object construct();

    public String getMessage() {
        return this.statMessage;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getName() {
        return "replace";
    }

    public boolean done() {
        return this.done;
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public void stop() {
        this.done = true;
    }

    public void incrementProgress() {
        ++this.currentProgress;
        double percent = this.currentProgress * 100 / this.lengthOfTask;
        this.statMessage = "Completed " + percent + "%";
    }

    public int getCurrent() {
        return this.currentProgress;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public void go(boolean wait) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return AbstractLayout.this.construct();
            }
        };
        worker.start();
        if (wait) {
            worker.get();
        }
    }

    public void doLayout() {
        this.currentProgress = 0;
        this.done = false;
        this.canceled = false;
        this.statMessage = "Completed 0%";
        CytoscapeProgressMonitor monitor = new CytoscapeProgressMonitor(this, Cytoscape.getDesktop());
        monitor.startMonitor(true);
        this.networkView.fitContent();
        this.done = true;
    }

    public boolean dontMove(NodeView nv) {
        return this.staticNodes.contains(nv);
    }

    public void initialize() {
        double node_count = this.network.getNodeCount();
        node_count = Math.sqrt(node_count);
        this.currentSize = new Dimension((int)(node_count *= 100.0), (int)node_count);
        this.initialize_local();
        this.initializeLocations();
    }

    protected void initialize_local() {
    }

    protected void initialize_local_node_view(NodeView nv) {
    }

    protected void initializeLocations() {
        boolean count = false;
        Iterator iter = this.network.nodesIterator();
        while (iter.hasNext()) {
            NodeView v = this.networkView.getNodeView((Node)iter.next());
            if (!this.staticNodes.contains(v)) {
                this.initializeLocation(v, this.currentSize);
            }
            this.initialize_local_node_view(v);
        }
    }

    protected void initializeLocation(NodeView v, Dimension d) {
    }

    public String getStatus() {
        return null;
    }

    public void advancePositions() {
    }

    public Dimension getCurrentSize() {
        return this.currentSize;
    }

    public void move(double x, double y) {
        int[] nodes = this.network.getNodeIndicesArray();
        for (int i = 0; i < nodes.length; ++i) {
            this.networkView.setNodeDoubleProperty(nodes[i], 0, x + this.networkView.getNodeDoubleProperty(nodes[i], 0));
            this.networkView.setNodeDoubleProperty(nodes[i], 1, y + this.networkView.getNodeDoubleProperty(nodes[i], 1));
        }
    }

    public void setSingle(double x, double y) {
        int[] nodes = this.network.getNodeIndicesArray();
        for (int i = 0; i < nodes.length; ++i) {
            this.networkView.setNodeDoubleProperty(nodes[i], 0, x);
            this.networkView.setNodeDoubleProperty(nodes[i], 1, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(Dimension size) {
        Dimension oldSize;
        Dimension dimension = this.currentSize;
        synchronized (dimension) {
            if (this.currentSize.equals(size)) {
                return;
            }
            oldSize = this.currentSize;
            this.currentSize = size;
        }
        int xOffset = (size.width - oldSize.width) / 2;
        int yOffset = (size.height - oldSize.height) / 2;
        Iterator iter = this.networkView.getNodeViewsIterator();
        while (iter.hasNext()) {
            NodeView e = (NodeView)iter.next();
            e.setOffset(e.getXPosition() + (double)xOffset, e.getYPosition() + (double)yOffset);
        }
    }

    public void restart() {
        this.initializeLocations();
        this.initialize_local();
    }

    public NodeView getNodeView(double x, double y) {
        double minDistance = Double.MAX_VALUE;
        NodeView closest = null;
        Iterator iter = this.network.nodesIterator();
        while (iter.hasNext()) {
            double dy;
            NodeView v = this.networkView.getNodeView((Node)iter.next());
            double dx = this.networkView.getNodeDoubleProperty(v.getRootGraphIndex(), 0) - x;
            double dist = dx * dx + (dy = this.networkView.getNodeDoubleProperty(v.getRootGraphIndex(), 1) - y) * dy;
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            closest = v;
        }
        return closest;
    }

    public void forceMove(NodeView picked, double x, double y) {
        picked.setOffset(x, y);
    }

    public void lockNodes(NodeView[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.staticNodes.add(nodes[i]);
        }
    }

    public void lockNode(NodeView v) {
        this.staticNodes.add(v);
    }

    public void unlockNode(NodeView v) {
        this.staticNodes.remove(v);
    }
}

