/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.giny;

import cern.colt.map.OpenIntIntHashMap;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.PrimeFinder;
import coltginy.ColtRootGraph;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.giny.ColtCyNetwork;
import cytoscape.giny.Node;
import giny.model.Edge;
import giny.model.GraphPerspective;

public class CytoscapeRootGraph
extends ColtRootGraph {
    protected OpenIntObjectHashMap nodeIndexObjectMap;
    protected OpenIntObjectHashMap edgeIndexObjectMap;

    public CytoscapeRootGraph() {
        this(10000, 100000);
    }

    public CytoscapeRootGraph(int node_capacity, int edge_capacity) {
        System.out.println("Initializing Root Graph with: " + node_capacity + " and " + edge_capacity);
        this.nodeIndexObjectMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(node_capacity));
        this.edgeIndexObjectMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(edge_capacity));
        this.initializeColtRootGraph(node_capacity, edge_capacity);
    }

    protected giny.model.Node createNode(int node_index) {
        if (this.nodeIndexObjectMap.containsKey(node_index)) {
            return (Node)this.nodeIndexObjectMap.get(node_index);
        }
        CyNode node = new CyNode(node_index, this);
        this.nodeIndexObjectMap.put(node_index, node);
        return node;
    }

    protected Edge createEdge(int edge_index) {
        if (this.edgeIndexObjectMap.containsKey(edge_index)) {
            return (Edge)this.edgeIndexObjectMap.get(edge_index);
        }
        CyEdge edge = new CyEdge(edge_index, this);
        this.edgeIndexObjectMap.put(edge_index, edge);
        return edge;
    }

    public int createNode(GraphPerspective perspective) {
        int[] node_indices_array = null;
        int[] edge_indices_array = null;
        if (perspective != null) {
            if (perspective.getRootGraph() != this) {
                throw new IllegalArgumentException("The given GraphPerspective is a perspective on a different RootGraph: " + perspective.getRootGraph() + ".");
            }
            node_indices_array = perspective.getNodeIndicesArray();
            edge_indices_array = perspective.getEdgeIndicesArray();
        }
        int new_node = this.createNode(node_indices_array, edge_indices_array);
        giny.model.Node cyto_node = this.createNode(new_node);
        ((CyNode)cyto_node).setGraphPerspective(perspective);
        return new_node;
    }

    public int createNode(CyNetwork network) {
        return this.createNode((GraphPerspective)network);
    }

    public CyNetwork createNetwork(giny.model.Node[] nodes, Edge[] edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        int[] node_indices = new int[nodes.length];
        for (int node_i = 0; node_i < nodes.length; ++node_i) {
            if (nodes[node_i] == null) {
                throw new IllegalArgumentException("All Nodes must not be null.  The node at index " + node_i + " into the given nodes array is null.");
            }
            if (nodes[node_i].getRootGraph() != this) {
                throw new IllegalArgumentException("All Nodes must be from this RootGraph.  The node at index " + node_i + " into the given nodes array is from a different RootGraph: " + nodes[node_i].getRootGraph() + ".");
            }
            int node_index = nodes[node_i].getRootGraphIndex();
            if (node_index == 0) {
                throw new IllegalArgumentException("All Nodes must be from this RootGraph.  The node at index " + node_i + " into the given nodes array is no longer in this RootGraph (its getRootGraphIndex() method has returned 0).");
            }
            node_indices[node_i] = node_index;
        }
        int[] edge_indices = new int[edges.length];
        for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
            if (edges[edge_i] == null) {
                throw new IllegalArgumentException("All Edges must not be null.  The edge at index " + edge_i + " into the given edges array is null.");
            }
            if (edges[edge_i].getRootGraph() != this) {
                throw new IllegalArgumentException("All Edges must be from this RootGraph.  The edge at index " + edge_i + " into the given edges array is from a different RootGraph: " + edges[edge_i].getRootGraph() + ".");
            }
            int edge_index = edges[edge_i].getRootGraphIndex();
            if (edge_index == 0) {
                throw new IllegalArgumentException("All Edges must be from this RootGraph.  The edge at index " + edge_i + " into the given edges array is no longer in this RootGraph (its getRootGraphIndex() method has returned 0).");
            }
            edge_indices[edge_i] = edge_index;
        }
        return this.createNetwork(node_indices, edge_indices);
    }

    public CyNetwork createNetwork(int[] node_indices, int[] edge_indices) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        OpenIntIntHashMap r_node_i_to_p_node_i_map = new OpenIntIntHashMap(node_indices.length);
        for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
            if (node_indices[node_index_i] >= 0) {
                throw new IllegalArgumentException("Node indices must be negative!  At index " + node_index_i + " into the given node_indices array, we find this: " + node_indices[node_index_i] + ".");
            }
            r_node_i_to_p_node_i_map.put(node_indices[node_index_i], node_index_i + 1);
        }
        OpenIntIntHashMap r_edge_i_to_p_edge_i_map = new OpenIntIntHashMap(edge_indices.length);
        for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
            if (edge_indices[edge_index_i] >= 0) {
                throw new IllegalArgumentException("Edge indices must be negative!  At index " + edge_index_i + " into the given edge_indices array, we find this: " + edge_indices[edge_index_i] + ".");
            }
            r_edge_i_to_p_edge_i_map.put(edge_indices[edge_index_i], edge_index_i + 1);
        }
        return new ColtCyNetwork(this, r_node_i_to_p_node_i_map, r_edge_i_to_p_edge_i_map);
    }
}

