/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.giny;

import cern.colt.map.OpenIntIntHashMap;
import coltginy.ColtGraphPerspective;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNetworkEvent;
import cytoscape.CyNetworkListener;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.ExpressionData;
import cytoscape.data.FlagEventListener;
import cytoscape.data.FlagFilter;
import cytoscape.data.GraphObjAttributes;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ColtCyNetwork
extends ColtGraphPerspective
implements CyNetwork {
    private static int uid_counter = 0;
    private String identifier;
    protected String title;
    protected Set listeners = new HashSet();
    protected Map clientData;
    protected FlagFilter flagger;
    int activityCount = 0;

    public ColtCyNetwork() {
        super(Cytoscape.getRootGraph(), new OpenIntIntHashMap(), new OpenIntIntHashMap());
        this.initialize();
    }

    public ColtCyNetwork(RootGraph root_graph, OpenIntIntHashMap r_node_i_to_p_node_i_map, OpenIntIntHashMap r_edge_i_to_p_edge_i_map) {
        super(root_graph, r_node_i_to_p_node_i_map, r_edge_i_to_p_edge_i_map);
        this.initialize();
    }

    protected void initialize() {
        Integer i = new Integer(uid_counter);
        this.identifier = i.toString();
        ++uid_counter;
        this.clientData = new HashMap();
        this.flagger = new FlagFilter(this);
    }

    public String getTitle() {
        if (this.title == null) {
            return this.identifier;
        }
        return this.title;
    }

    public void setTitle(String new_id) {
        this.title = new_id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String setIdentifier(String new_id) {
        this.identifier = new_id;
        return this.identifier;
    }

    public void putClientData(String data_name, Object data) {
        this.clientData.put(data_name, data);
    }

    public Collection getClientDataNames() {
        return this.clientData.keySet();
    }

    public Object getClientData(String data_name) {
        return this.clientData.get(data_name);
    }

    public void beginActivity(String callerID) {
        ++this.activityCount;
        if (this.activityCount == 1) {
            this.fireEvent(0);
        }
    }

    public void endActivity(String callerID) {
        if (this.activityCount == 0) {
            return;
        }
        --this.activityCount;
        if (this.activityCount == 0) {
            this.fireEvent(1);
        }
    }

    public boolean isStateClear() {
        return this.activityCount == 0;
    }

    public void forceClear(String callerID) {
        if (this.activityCount > 0) {
            this.activityCount = 0;
            this.fireEvent(1);
        }
    }

    public RootGraph getRootGraph() {
        return Cytoscape.getRootGraph();
    }

    public GraphPerspective getGraphPerspective() {
        return this;
    }

    public void setGraphPerspective(GraphPerspective perspective) {
        this.hideNodes(this.getNodeIndicesArray());
        this.hideEdges(this.getEdgeIndicesArray());
        this.restoreNodes(perspective.getNodeIndicesArray());
        this.restoreEdges(perspective.getEdgeIndicesArray());
        this.fireEvent(10);
    }

    public void setNewGraphFrom(CyNetwork newNetwork, boolean replaceAttributes) {
        this.setGraphPerspective(newNetwork);
    }

    public void appendNetwork(CyNetwork network) {
        int[] nodes = network.getNodeIndicesArray();
        int[] edges = network.getEdgeIndicesArray();
        this.restoreNodes(nodes);
        this.restoreEdges(edges);
    }

    public boolean getNeedsLayout() {
        return false;
    }

    public void setNeedsLayout(boolean needsLayout) {
    }

    public GraphObjAttributes getNodeAttributes() {
        return Cytoscape.getNodeNetworkData();
    }

    public void setNodeAttributes(GraphObjAttributes newNodeAttributes) {
    }

    public GraphObjAttributes getEdgeAttributes() {
        return Cytoscape.getEdgeNetworkData();
    }

    public void setEdgeAttributes(GraphObjAttributes newEdgeAttributes) {
    }

    public ExpressionData getExpressionData() {
        return Cytoscape.getExpressionData();
    }

    public void setExpressionData(ExpressionData newData) {
    }

    public FlagFilter getFlagger() {
        return this.flagger;
    }

    public void flagAllNodes() {
        this.flagger.flagAllNodes();
    }

    public void flagAllEdges() {
        this.flagger.flagAllEdges();
    }

    public void unFlagAllNodes() {
        this.flagger.flagAllNodes();
    }

    public void unFlagAllEdges() {
        this.flagger.flagAllEdges();
    }

    public void setFlagged(Node node, boolean state) {
        this.flagger.setFlagged(node, state);
    }

    public void setFlaggedNodes(Collection nodes, boolean state) {
        this.flagger.setFlaggedNodes(nodes, state);
    }

    public void setFlaggedNodes(int[] nodes, boolean state) {
        for (int i = 0; i < nodes.length; ++i) {
            this.flagger.setFlagged(this.getNode(nodes[i]), state);
        }
    }

    public void setFlagged(Edge edge, boolean state) {
        this.flagger.setFlagged(edge, state);
    }

    public void setFlaggedEdges(Collection edges, boolean state) {
        this.flagger.setFlaggedEdges(edges, state);
    }

    public void setFlaggedEdges(int[] edges, boolean state) {
        for (int i = 0; i < edges.length; ++i) {
            this.flagger.setFlagged(this.getEdge(edges[i]), state);
        }
    }

    public boolean isFlagged(Node node) {
        return this.flagger.isFlagged(node);
    }

    public boolean isFlagged(Edge edge) {
        return this.flagger.isFlagged(edge);
    }

    public Set getFlaggedNodes() {
        return this.flagger.getFlaggedNodes();
    }

    public Set getFlaggedEdges() {
        return this.flagger.getFlaggedEdges();
    }

    public int[] getFlaggedNodeIndicesArray() {
        Set set = this.flagger.getFlaggedNodes();
        int[] nodes = new int[set.size()];
        int count = 0;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            nodes[count] = ((Node)i.next()).getRootGraphIndex();
            ++count;
        }
        return nodes;
    }

    public int[] getFlaggedEdgeIndicesArray() {
        Set set = this.flagger.getFlaggedEdges();
        int[] edges = new int[set.size()];
        int count = 0;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            edges[count] = ((Edge)i.next()).getRootGraphIndex();
            ++count;
        }
        return edges;
    }

    public void addFlagEventListener(FlagEventListener listener) {
        this.flagger.addFlagEventListener(listener);
    }

    public void removeFlagEventListener(FlagEventListener listener) {
        this.flagger.removeFlagEventListener(listener);
    }

    public Object getNodeAttributeValue(Node node, String attribute) {
        return Cytoscape.getNodeNetworkData().get(attribute, Cytoscape.getNodeNetworkData().getCanonicalName(node));
    }

    public Object getNodeAttributeValue(int node, String attribute) {
        return Cytoscape.getNodeNetworkData().get(attribute, Cytoscape.getNodeNetworkData().getCanonicalName(this.getNode(node)));
    }

    public Object getEdgeAttributeValue(Edge edge, String attribute) {
        return Cytoscape.getEdgeNetworkData().get(attribute, Cytoscape.getEdgeNetworkData().getCanonicalName(edge));
    }

    public Object getEdgeAttributeValue(int edge, String attribute) {
        return Cytoscape.getEdgeNetworkData().get(attribute, Cytoscape.getEdgeNetworkData().getCanonicalName(this.getEdge(edge)));
    }

    public String[] getNodeAttributesList() {
        return Cytoscape.getNodeNetworkData().getAttributeNames();
    }

    public String[] getNodeAttributesList(Node[] nodes) {
        return Cytoscape.getNodeNetworkData().getAttributeNames();
    }

    public String[] getEdgeAttributesList() {
        return Cytoscape.getEdgeNetworkData().getAttributeNames();
    }

    public String[] getNodeAttributesList(Edge[] edges) {
        return Cytoscape.getEdgeNetworkData().getAttributeNames();
    }

    public boolean setNodeAttributeValue(Node node, String attribute, Object value) {
        return Cytoscape.getNodeNetworkData().set(attribute, Cytoscape.getNodeNetworkData().getCanonicalName(node), value);
    }

    public boolean setNodeAttributeValue(int node, String attribute, Object value) {
        return Cytoscape.getNodeNetworkData().set(attribute, Cytoscape.getNodeNetworkData().getCanonicalName(this.getNode(node)), value);
    }

    public boolean setEdgeAttributeValue(Edge edge, String attribute, Object value) {
        return Cytoscape.getEdgeNetworkData().set(attribute, Cytoscape.getEdgeNetworkData().getCanonicalName(edge), value);
    }

    public boolean setEdgeAttributeValue(int edge, String attribute, Object value) {
        return Cytoscape.getEdgeNetworkData().set(attribute, Cytoscape.getEdgeNetworkData().getCanonicalName(this.getEdge(edge)), value);
    }

    public void deleteNodeAttribute(String attribute) {
        Cytoscape.getNodeNetworkData().deleteAttribute(attribute);
    }

    public void deleteEdgeAttribute(String attribute) {
        Cytoscape.getEdgeNetworkData().deleteAttribute(attribute);
    }

    public void addCyNetworkListener(CyNetworkListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeCyNetworkListener(CyNetworkListener listener) {
        return this.listeners.remove(listener);
    }

    public Set getCyNetworkListeners() {
        return new HashSet(this.listeners);
    }

    protected void fireEvent(int type) {
        CyNetworkEvent event = new CyNetworkEvent(this, type);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            CyNetworkListener listener = (CyNetworkListener)i.next();
            listener.onCyNetworkEvent(event);
        }
    }

    public int createNode() {
        return this.restoreNode(Cytoscape.getRootGraph().createNode());
    }

    public int addNode(int cytoscape_node) {
        return this.restoreNode(cytoscape_node);
    }

    public CyNode addNode(Node cytoscape_node) {
        return (CyNode)this.restoreNode(cytoscape_node);
    }

    public int addNode(String attribute, Object value) {
        return 0;
    }

    public boolean removeNode(int node_index, boolean force) {
        this.hideNode(node_index);
        return true;
    }

    public int createEdge(int source, int target, boolean directed) {
        return this.restoreEdge(Cytoscape.getRootGraph().createEdge(source, target, directed));
    }

    public int addEdge(int cytoscape_edge) {
        return this.restoreEdge(cytoscape_edge);
    }

    public CyEdge addEdge(Edge cytoscape_edge) {
        return (CyEdge)this.restoreEdge(cytoscape_edge);
    }

    public int addEdge(String attribute, Object value) {
        return 0;
    }

    public boolean removeEdge(int edge_index, boolean force) {
        this.hideEdge(edge_index);
        return true;
    }
}

