/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phoebe.PGraphView;

public class PhoebeNodeControl {
    GraphView view;
    double Xmin;
    double Ymin;
    double Xmax;
    double Ymax;
    boolean setToCircle;
    double side;
    JSlider radius;
    JSlider rotation;
    JSlider twist;

    public PhoebeNodeControl(GraphView view) {
        JFrame frame = new JFrame("Node Control");
        JTabbedPane tabbed = new JTabbedPane();
        this.view = (PGraphView)view;
        tabbed.addTab("Align", this.createAlignTab());
        tabbed.addTab("Circular", this.createCircularTab());
        frame.getContentPane().add(tabbed);
        frame.pack();
        frame.setVisible(true);
    }

    public JComponent createAlignTab() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JPanel align = new JPanel();
        align.setBorder(new TitledBorder("Alignment"));
        JPanel dist = new JPanel();
        dist.setBorder(new TitledBorder("Distribution"));
        align.setLayout(new BorderLayout());
        dist.setLayout(new BorderLayout());
        JPanel aButtons = new JPanel();
        JPanel bButtons = new JPanel();
        JPanel dButtons = new JPanel();
        aButtons.add(this.createHorizontalAlignLeft());
        aButtons.add(this.createHorizontalAlignCenter());
        aButtons.add(this.createHorizontalAlignRight());
        bButtons.add(this.createVerticalAlignTop());
        bButtons.add(this.createVerticalAlignCenter());
        bButtons.add(this.createVerticalAlignBottom());
        align.add((Component)aButtons, "North");
        align.add((Component)bButtons, "South");
        dButtons.add(this.createHorizontalDistributeCenter());
        dButtons.add(this.createVerticalDistributeCenter());
        dist.add(dButtons);
        panel.add(align);
        panel.add(dist);
        return panel;
    }

    public JButton createHorizontalAlignLeft() {
        return new JButton(new AbstractAction("HorizontalAlignLeft"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Iterator<E> sel_nodes = 1.access$000(this.this$1).view.getSelectedNodes().iterator();
                        double h = ((NodeView)sel_nodes.next()).getXPosition();
                        while (sel_nodes.hasNext()) {
                            NodeView node_view = (NodeView)sel_nodes.next();
                            if (!(node_view.getXPosition() < h)) continue;
                            h = node_view.getXPosition();
                        }
                        sel_nodes = 1.access$000(this.this$1).view.getSelectedNodes().iterator();
                        while (sel_nodes.hasNext()) {
                            ((NodeView)sel_nodes.next()).setXPosition(h);
                        }
                    }
                });
            }

            static /* synthetic */ PhoebeNodeControl access$000(1 x0) {
                return x0.PhoebeNodeControl.this;
            }
        });
    }

    public JButton createHorizontalAlignRight() {
        return new JButton(new AbstractAction("HorizontalAlignRight"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Iterator<E> sel_nodes = 3.access$100(this.this$1).view.getSelectedNodes().iterator();
                        double h = ((NodeView)sel_nodes.next()).getXPosition();
                        while (sel_nodes.hasNext()) {
                            NodeView node_view = (NodeView)sel_nodes.next();
                            if (!(node_view.getXPosition() > h)) continue;
                            h = node_view.getXPosition();
                        }
                        sel_nodes = 3.access$100(this.this$1).view.getSelectedNodes().iterator();
                        while (sel_nodes.hasNext()) {
                            ((NodeView)sel_nodes.next()).setXPosition(h);
                        }
                    }
                });
            }

            static /* synthetic */ PhoebeNodeControl access$100(3 x0) {
                return x0.PhoebeNodeControl.this;
            }
        });
    }

    public JButton createHorizontalAlignCenter() {
        return new JButton(new AbstractAction("HorizontalAlignCenter"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        double min;
                        Iterator<E> sel_nodes = 5.access$200(this.this$1).view.getSelectedNodes().iterator();
                        double max = min = ((NodeView)sel_nodes.next()).getXPosition();
                        while (sel_nodes.hasNext()) {
                            NodeView node_view = (NodeView)sel_nodes.next();
                            if (node_view.getXPosition() > max) {
                                max = node_view.getXPosition();
                            }
                            if (!(node_view.getXPosition() < min)) continue;
                            min = node_view.getXPosition();
                        }
                        min += (max - min) / 2.0;
                        sel_nodes = 5.access$200(this.this$1).view.getSelectedNodes().iterator();
                        while (sel_nodes.hasNext()) {
                            ((NodeView)sel_nodes.next()).setXPosition(min);
                        }
                    }
                });
            }

            static /* synthetic */ PhoebeNodeControl access$200(5 x0) {
                return x0.PhoebeNodeControl.this;
            }
        });
    }

    public JButton createVerticalAlignBottom() {
        return new JButton(new AbstractAction("VerticalAlignBottom"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Iterator<E> sel_nodes = 7.access$300(this.this$1).view.getSelectedNodes().iterator();
                        double h = ((NodeView)sel_nodes.next()).getYPosition();
                        while (sel_nodes.hasNext()) {
                            NodeView node_view = (NodeView)sel_nodes.next();
                            if (!(node_view.getYPosition() > h)) continue;
                            h = node_view.getYPosition();
                        }
                        sel_nodes = 7.access$300(this.this$1).view.getSelectedNodes().iterator();
                        while (sel_nodes.hasNext()) {
                            ((NodeView)sel_nodes.next()).setYPosition(h);
                        }
                    }
                });
            }

            static /* synthetic */ PhoebeNodeControl access$300(7 x0) {
                return x0.PhoebeNodeControl.this;
            }
        });
    }

    public JButton createVerticalAlignCenter() {
        return new JButton(new AbstractAction("VerticalAlignCenter"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        double min;
                        Iterator<E> sel_nodes = 9.access$400(this.this$1).view.getSelectedNodes().iterator();
                        double max = min = ((NodeView)sel_nodes.next()).getYPosition();
                        while (sel_nodes.hasNext()) {
                            NodeView node_view = (NodeView)sel_nodes.next();
                            if (node_view.getYPosition() > max) {
                                max = node_view.getYPosition();
                            }
                            if (!(node_view.getYPosition() < min)) continue;
                            min = node_view.getYPosition();
                        }
                        min += (max - min) / 2.0;
                        sel_nodes = 9.access$400(this.this$1).view.getSelectedNodes().iterator();
                        while (sel_nodes.hasNext()) {
                            ((NodeView)sel_nodes.next()).setYPosition(min);
                        }
                    }
                });
            }

            static /* synthetic */ PhoebeNodeControl access$400(9 x0) {
                return x0.PhoebeNodeControl.this;
            }
        });
    }

    public JButton createVerticalAlignTop() {
        return new JButton(new AbstractAction("VerticalAlignTop"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Iterator<E> sel_nodes = 11.access$500(this.this$1).view.getSelectedNodes().iterator();
                        double h = ((NodeView)sel_nodes.next()).getYPosition();
                        while (sel_nodes.hasNext()) {
                            NodeView node_view = (NodeView)sel_nodes.next();
                            if (!(node_view.getYPosition() < h)) continue;
                            h = node_view.getYPosition();
                        }
                        sel_nodes = 11.access$500(this.this$1).view.getSelectedNodes().iterator();
                        while (sel_nodes.hasNext()) {
                            ((NodeView)sel_nodes.next()).setYPosition(h);
                        }
                    }
                });
            }

            static /* synthetic */ PhoebeNodeControl access$500(11 x0) {
                return x0.PhoebeNodeControl.this;
            }
        });
    }

    public JButton createVerticalDistributeCenter() {
        return new JButton(new AbstractAction("VerticalDistributeBottom"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        double min = 0.0;
                        double max = 0.0;
                        NodeView node_view = null;
                        List sel_nodes_list = 13.access$600(this.this$1).view.getSelectedNodes();
                        if (sel_nodes_list.size() == 0) {
                            return;
                        }
                        Iterator<E> sel_nodes = sel_nodes_list.iterator();
                        max = min = ((NodeView)sel_nodes.next()).getYPosition();
                        while (sel_nodes.hasNext()) {
                            node_view = (NodeView)sel_nodes.next();
                            if (node_view.getYPosition() > max) {
                                max = node_view.getYPosition();
                            }
                            if (!(node_view.getYPosition() < min)) continue;
                            min = node_view.getYPosition();
                        }
                        double diff = (min + (max - min) / 2.0) / (double)sel_nodes_list.size() + node_view.getHeight();
                        double loc = min + (max - min) / 2.0;
                        sel_nodes = sel_nodes_list.iterator();
                        while (sel_nodes.hasNext()) {
                            node_view = (NodeView)sel_nodes.next();
                            node_view.setYPosition(loc);
                            loc += diff;
                        }
                    }
                });
            }

            static /* synthetic */ PhoebeNodeControl access$600(13 x0) {
                return x0.PhoebeNodeControl.this;
            }
        });
    }

    public JButton createHorizontalDistributeCenter() {
        return new JButton(new AbstractAction("HorizontalDistributeCenter"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        double min = 0.0;
                        double max = 0.0;
                        NodeView node_view = null;
                        List sel_nodes_list = 15.access$700(this.this$1).view.getSelectedNodes();
                        if (sel_nodes_list.size() == 0) {
                            return;
                        }
                        Iterator<E> sel_nodes = sel_nodes_list.iterator();
                        max = min = ((NodeView)sel_nodes.next()).getXPosition();
                        while (sel_nodes.hasNext()) {
                            node_view = (NodeView)sel_nodes.next();
                            if (node_view.getXPosition() > max) {
                                max = node_view.getXPosition();
                            }
                            if (!(node_view.getXPosition() < min)) continue;
                            min = node_view.getXPosition();
                        }
                        double diff = (min + (max - min) / 2.0) / (double)sel_nodes_list.size() + node_view.getWidth();
                        double loc = min + (max - min) / 2.0;
                        sel_nodes = sel_nodes_list.iterator();
                        while (sel_nodes.hasNext()) {
                            node_view = (NodeView)sel_nodes.next();
                            node_view.setXPosition(loc);
                            loc += diff;
                        }
                    }
                });
            }

            static /* synthetic */ PhoebeNodeControl access$700(15 x0) {
                return x0.PhoebeNodeControl.this;
            }
        });
    }

    protected JComponent createCircularTab() {
        this.radius = new JSlider(0, 2000);
        this.radius.addChangeListener(new SliderListener());
        this.rotation = new JSlider(0, 360);
        this.rotation.addChangeListener(new SliderListener());
        this.twist = new JSlider(0, 50000);
        this.twist.addChangeListener(new SliderListener());
        this.rotation.setValue(90);
        this.radius.setValue(100);
        this.twist.setValue(0);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JPanel rad = new JPanel();
        rad.setLayout(new BorderLayout());
        rad.setBorder(new TitledBorder("Radius"));
        rad.add(this.radius);
        JPanel rot = new JPanel();
        rot.setBorder(new TitledBorder("Rotation"));
        rot.add(this.rotation);
        JPanel twt = new JPanel();
        twt.setBorder(new TitledBorder("Twist"));
        twt.add(this.twist);
        panel.add(rad);
        panel.add(rot);
        panel.add(twt);
        return panel;
    }

    protected void updateSliders() {
        double maxX;
        double maxY;
        int ra = this.radius.getValue();
        int ro = this.rotation.getValue();
        int tw = this.twist.getValue();
        double radius = new Integer(ra).doubleValue();
        double rotation = new Integer(ro).doubleValue();
        double radians = Math.toRadians(tw);
        List sel_nodes_list = this.view.getSelectedNodes();
        if (sel_nodes_list.size() == 0) {
            return;
        }
        Iterator sel_nodes = sel_nodes_list.iterator();
        NodeView node_view = (NodeView)sel_nodes.next();
        double minY = maxY = node_view.getYPosition();
        double minX = maxX = node_view.getXPosition();
        while (sel_nodes.hasNext()) {
            node_view = (NodeView)sel_nodes.next();
            if (node_view.getXPosition() > maxX) {
                maxX = node_view.getXPosition();
            }
            if (node_view.getXPosition() < minX) {
                minX = node_view.getXPosition();
            }
            if (node_view.getYPosition() > maxY) {
                maxY = node_view.getYPosition();
            }
            if (!(node_view.getYPosition() < minY)) continue;
            minY = node_view.getYPosition();
        }
        double midX = minX + (maxX - minX) / 2.0;
        double midY = minY + (maxY - minY) / 2.0;
        double theta = Math.acos((maxX - minX) / 2.0 / radius);
        double thetaIncr = (Math.PI - 2.0 * (theta += Math.toRadians(rotation))) / (double)sel_nodes_list.size();
        sel_nodes = sel_nodes_list.iterator();
        while (sel_nodes.hasNext()) {
            node_view = (NodeView)sel_nodes.next();
            node_view.setXPosition(Math.cos(theta + Math.toRadians(radians)) * radius + midX);
            node_view.setYPosition(Math.sin(theta + Math.toRadians(radians)) * radius + midY);
            theta += thetaIncr;
        }
    }

    public class SliderListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            PhoebeNodeControl.this.updateSliders();
        }
    }
}

