/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class IconPopupButton
extends JPanel
implements ActionListener {
    String title;
    String objectName;
    String currentIconName;
    Object currentIcon;
    JButton iconButton;
    JLabel iconSelectionForPanel;
    JFrame mainFrame;
    JDialog mainDialog;
    JPanel mainPanel;
    HashMap iconObjectToString;
    HashMap stringToIconObject;
    JList iconList;
    JDialog parentDialog;
    boolean alreadyConstructed;

    public IconPopupButton(String title, String objectName, HashMap iconObjectToString, HashMap stringToIconObject, ImageIcon[] icons, Object startIconObject, JDialog parentDialog) {
        this.title = title;
        if (icons.length == 0) {
            this.setupErrorWindow();
            return;
        }
        if (icons[0] == null || icons[0].getIconWidth() < 0) {
            System.out.println(icons[0].getImage().getWidth(parentDialog));
            this.setupErrorWindow();
            return;
        }
        this.alreadyConstructed = false;
        this.objectName = objectName;
        this.iconObjectToString = iconObjectToString;
        this.stringToIconObject = stringToIconObject;
        this.parentDialog = parentDialog;
        this.iconList = new JList<ImageIcon>(icons);
        if (startIconObject != null) {
            this.setIconObject(startIconObject);
        } else {
            System.out.println("starticon null " + title);
            ImageIcon icon = (ImageIcon)this.iconList.getModel().getElementAt(0);
            this.setIconName(icon.getDescription());
        }
        this.setupWindow();
    }

    private void setupWindow() {
        ListModel theModel = this.iconList.getModel();
        ImageIcon icon = (ImageIcon)theModel.getElementAt(0);
        int modelSize = theModel.getSize();
        for (int modelIndex = 0; modelIndex < modelSize; ++modelIndex) {
            ImageIcon indexedIcon = (ImageIcon)theModel.getElementAt(modelIndex);
            if (this.currentIconName != indexedIcon.getDescription()) continue;
            icon = indexedIcon;
            this.iconList.setSelectedValue(icon, true);
        }
        this.iconButton = new JButton(this.title);
        this.iconButton.addActionListener(this);
        this.mainPanel = new JPanel(new GridLayout(0, 1));
        this.iconSelectionForPanel = new JLabel(icon);
        this.add(this.iconButton);
        this.add(this.iconSelectionForPanel);
    }

    private void setupErrorWindow() {
        this.iconButton = new JButton(this.title + ": CYTOSCAPE_HOME error");
        this.iconSelectionForPanel = new JLabel(" X ");
        JLabel errorLabel = new JLabel("ERROR: No CYTOSCAPE_HOME specified on java command line.");
        this.add(errorLabel);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.alreadyConstructed) {
            this.mainDialog = new JDialog((Dialog)this.parentDialog, this.title);
            final JButton setButton = new JButton("Apply");
            JButton cancelButton = new JButton("Dismiss");
            setButton.addActionListener(new ApplyIconAction());
            cancelButton.addActionListener(new DismissIconAction());
            this.iconList.setLayoutOrientation(2);
            this.iconList.setVisibleRowCount(1);
            this.iconList.setBackground(Color.WHITE);
            this.iconList.setSelectionBackground(Color.RED);
            this.iconList.setSelectionForeground(Color.RED);
            this.iconList.setSelectionMode(0);
            this.iconList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        setButton.doClick();
                    }
                }
            });
            JScrollPane listScroller = new JScrollPane(this.iconList);
            listScroller.setPreferredSize(new Dimension(150, 50));
            listScroller.setMinimumSize(new Dimension(150, 50));
            listScroller.setAlignmentX(0.0f);
            listScroller.setAlignmentY(1.0f);
            this.iconList.ensureIndexIsVisible(this.iconList.getSelectedIndex());
            JPanel listPane = new JPanel();
            listPane.setLayout(new BoxLayout(listPane, 1));
            JLabel label = new JLabel("Set " + this.objectName);
            label.setLabelFor(this.iconList);
            listPane.add(label);
            listPane.add(Box.createRigidArea(new Dimension(0, 5)));
            listPane.add(listScroller);
            listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane, 0));
            buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            buttonPane.add(Box.createHorizontalGlue());
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(setButton);
            buttonPane.add(cancelButton);
            this.mainPanel.add((Component)listPane, "Center");
            this.mainPanel.add((Component)buttonPane, "South");
            this.mainDialog.setContentPane(this.mainPanel);
            this.alreadyConstructed = true;
        }
        this.mainDialog.pack();
        this.mainDialog.setLocationRelativeTo(this.parentDialog);
        this.mainDialog.setVisible(true);
    }

    public String getIconName() {
        return this.currentIconName;
    }

    public Object getIconObject() {
        return this.currentIcon;
    }

    public void setIconName(String iconName) {
        this.currentIconName = iconName;
        this.currentIcon = this.stringToIconObject.get(iconName);
    }

    public void setIconObject(Object iconObject) {
        this.currentIcon = iconObject;
        this.currentIconName = (String)this.iconObjectToString.get(iconObject);
    }

    public JLabel getLabel() {
        return this.iconSelectionForPanel;
    }

    public JButton getButton() {
        return this.iconButton;
    }

    public class DismissIconAction
    extends AbstractAction {
        DismissIconAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            IconPopupButton.this.mainDialog.dispose();
        }
    }

    public class ApplyIconAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            ImageIcon icon = (ImageIcon)IconPopupButton.this.iconList.getSelectedValue();
            IconPopupButton.this.setIconName(icon.getDescription());
            IconPopupButton.this.iconSelectionForPanel.setIcon(icon);
            IconPopupButton.this.mainDialog.dispose();
        }
    }
}

