/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import ViolinStrings.Strings;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.GraphObjAttributes;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import phoebe.PGraphView;

public class GraphObjectSelection
extends JPanel
implements ActionListener {
    JTextField searchField;
    JCheckBox regexpSearch;
    JCheckBox clearSelection;
    JRadioButton hideFailed;
    JRadioButton grayFailed;
    JRadioButton selectPassed;
    JList selectedAttributes;
    JList allAttributes;
    CyNetwork cyNetwork;
    GraphObjAttributes nodeAttributes;
    GraphObjAttributes edgeAttributes;
    PGraphView graphView;
    CyNetworkView networkView;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;

    public GraphObjectSelection() {
        this.initialize();
    }

    protected void initialize() {
        this.networkView = Cytoscape.getCurrentNetworkView();
        this.cyNetwork = this.networkView.getNetwork();
        this.nodeAttributes = Cytoscape.getNodeNetworkData();
        this.edgeAttributes = Cytoscape.getEdgeNetworkData();
        JPanel searchPanel = new JPanel();
        searchPanel.setBorder(new TitledBorder("Describe Filter"));
        searchPanel.add(new JLabel("Filter: "));
        this.searchField = new JTextField(30);
        this.searchField.addActionListener(this);
        searchPanel.add(this.searchField);
        this.regexpSearch = new JCheckBox("Regexp?");
        searchPanel.add(this.regexpSearch);
        searchPanel.add(new JButton(new AbstractAction("Go!"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).performSearch();
                    }
                });
            }

            static /* synthetic */ GraphObjectSelection access$000(1 x0) {
                return x0.GraphObjectSelection.this;
            }
        }));
        JPanel allAttributesPanel = new JPanel();
        allAttributesPanel.setBorder(new TitledBorder("All Available String Attributes"));
        String[] node_attribute_names = this.nodeAttributes.getAttributeNames();
        ArrayList<String> string_attributes = new ArrayList<String>(node_attribute_names.length);
        ArrayList<String> number_attributes = new ArrayList<String>(node_attribute_names.length);
        ArrayList<String> other_attributes = new ArrayList<String>(node_attribute_names.length);
        for (int i = 0; i < node_attribute_names.length; ++i) {
            Class type = GraphObjAttributes.deduceClass(node_attribute_names[i]);
            System.out.println("Attr: " + node_attribute_names[i] + " Class: " + type.getName());
            if (type.getName().equals((class$java$lang$String == null ? GraphObjectSelection.class$("java.lang.String") : class$java$lang$String).getName())) {
                string_attributes.add(node_attribute_names[i]);
                continue;
            }
            if (type.getName().equals((class$java$lang$Double == null ? GraphObjectSelection.class$("java.lang.Double") : class$java$lang$Double).getName())) {
                number_attributes.add(node_attribute_names[i]);
                continue;
            }
            other_attributes.add(node_attribute_names[i]);
        }
        DefaultListModel<String> model_nodes = new DefaultListModel<String>();
        Iterator string_atts = string_attributes.iterator();
        int i = 0;
        while (string_atts.hasNext()) {
            model_nodes.add(i, (String)string_atts.next());
            ++i;
        }
        this.allAttributes = new JList(model_nodes);
        JScrollPane scrollPaneAll = new JScrollPane();
        scrollPaneAll.getViewport().setView(this.allAttributes);
        allAttributesPanel.add(scrollPaneAll);
        JPanel selectedAttributesPanel = new JPanel();
        selectedAttributesPanel.setBorder(new TitledBorder("Selected Attributes"));
        this.selectedAttributes = new JList(new DefaultListModel());
        JScrollPane scrollPaneSel = new JScrollPane();
        scrollPaneSel.getViewport().setView(this.selectedAttributes);
        allAttributesPanel.add(scrollPaneSel);
        selectedAttributesPanel.add(scrollPaneSel);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(0, 1));
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(new TitledBorder("Control"));
        controlPanel.add(new JButton(new AbstractAction("+"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Object[] attributes = 3.access$100(this.this$1).allAttributes.getSelectedValues();
                        TreeSet<Object> current_selection = new TreeSet<Object>(Arrays.asList(((DefaultListModel)3.access$100(this.this$1).selectedAttributes.getModel()).toArray()));
                        current_selection.addAll(Arrays.asList(attributes));
                        DefaultListModel<E> new_model = new DefaultListModel<E>();
                        Iterator<E> sel = current_selection.iterator();
                        while (sel.hasNext()) {
                            new_model.addElement(sel.next());
                        }
                        3.access$100(this.this$1).selectedAttributes.setModel(new_model);
                    }
                });
            }

            static /* synthetic */ GraphObjectSelection access$100(3 x0) {
                return x0.GraphObjectSelection.this;
            }
        }));
        controlPanel.add(new JButton(new AbstractAction("-"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Object[] attributes = 5.access$200(this.this$1).selectedAttributes.getSelectedValues();
                        DefaultListModel dlm = (DefaultListModel)5.access$200(this.this$1).selectedAttributes.getModel();
                        for (int i = 0; i < attributes.length; ++i) {
                            dlm.removeElement(attributes[i]);
                        }
                    }
                });
            }

            static /* synthetic */ GraphObjectSelection access$200(5 x0) {
                return x0.GraphObjectSelection.this;
            }
        }));
        controlPanel.add(new JButton(new AbstractAction("Update"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                    }
                });
            }
        }));
        this.clearSelection = new JCheckBox("Clear", false);
        controlPanel.add(this.clearSelection);
        centerPanel.add(controlPanel);
        JPanel actionPanel = new JPanel();
        ButtonGroup actionGroup = new ButtonGroup();
        actionPanel.setBorder(new TitledBorder("Action to Take"));
        this.hideFailed = new JRadioButton("Hide Failed", true);
        actionGroup.add(this.hideFailed);
        actionPanel.add(this.hideFailed);
        this.grayFailed = new JRadioButton("Gray Failed", false);
        actionGroup.add(this.grayFailed);
        actionPanel.add(this.grayFailed);
        this.selectPassed = new JRadioButton("Select Passed", false);
        actionGroup.add(this.selectPassed);
        actionPanel.add(this.selectPassed);
        centerPanel.add(actionPanel);
        JSplitPane all_center_1 = new JSplitPane(1, true, centerPanel, allAttributesPanel);
        JSplitPane sel = new JSplitPane(1, true, selectedAttributesPanel, all_center_1);
        JSplitPane all = new JSplitPane(0, true, searchPanel, sel);
        this.add(all);
    }

    public Object[] getSelectionList() {
        return ((DefaultListModel)this.selectedAttributes.getModel()).toArray();
    }

    public void actionPerformed(ActionEvent event) {
        this.graphView = (PGraphView)((Object)this.networkView.getView());
        this.performSearch();
    }

    public void performSearch() {
        block13: {
            Node node;
            ArrayList<String> passes;
            block14: {
                block12: {
                    passes = new ArrayList<String>();
                    Object[] selected_attributes_o = this.getSelectionList();
                    String[] selected_attributes = new String[selected_attributes_o.length];
                    for (int i = 0; i < selected_attributes_o.length; ++i) {
                        selected_attributes[i] = (String)selected_attributes_o[i];
                    }
                    if (this.regexpSearch.isSelected()) {
                        System.out.println("not Implemented");
                    } else {
                        String[] pattern = this.searchField.getText().split("\\s");
                        for (int i = 0; i < selected_attributes.length; ++i) {
                            String[] nodes_with_attribute = this.nodeAttributes.getObjectNames(selected_attributes[i]);
                            for (int j = 0; j < nodes_with_attribute.length; ++j) {
                                String value = this.nodeAttributes.getStringValue(selected_attributes[i], nodes_with_attribute[j]);
                                for (int p = 0; p < pattern.length; ++p) {
                                    if (!Strings.isLike(value, pattern[p], 0, true)) continue;
                                    passes.add(nodes_with_attribute[j]);
                                }
                            }
                        }
                    }
                    if (!this.hideFailed.isSelected()) break block12;
                    this.graphView.showGraphObjects(this.graphView.getEdgeViewsList());
                    Iterator all_nodes = this.networkView.getView().getGraphPerspective().nodesList().iterator();
                    while (all_nodes.hasNext()) {
                        node = (Node)all_nodes.next();
                        if (passes.contains(node.getIdentifier())) {
                            this.graphView.showNodeView(this.graphView.getNodeView(node), false);
                            continue;
                        }
                        this.graphView.hideNodeView(this.graphView.getNodeView(node));
                    }
                    break block13;
                }
                if (!this.grayFailed.isSelected()) break block14;
                this.graphView.showGraphObjects(this.graphView.getEdgeViewsList());
                this.graphView.showGraphObjects(this.graphView.getNodeViewsList());
                Iterator all_nodes = this.graphView.getGraphPerspective().nodesList().iterator();
                while (all_nodes.hasNext()) {
                    node = (Node)all_nodes.next();
                    if (passes.contains(node.getIdentifier())) {
                        this.graphView.getNodeView(node).setTransparency(1.0f);
                        continue;
                    }
                    this.graphView.getNodeView(node).setTransparency(0.5f);
                }
                break block13;
            }
            if (!this.selectPassed.isSelected()) break block13;
            this.graphView.showGraphObjects(this.graphView.getEdgeViewsList());
            this.graphView.showGraphObjects(this.graphView.getNodeViewsList());
            Iterator all_nodes = this.graphView.getGraphPerspective().nodesList().iterator();
            while (all_nodes.hasNext()) {
                node = (Node)all_nodes.next();
                if (passes.contains(node.getIdentifier())) {
                    this.graphView.getNodeView(node).setSelected(true);
                    continue;
                }
                this.graphView.getNodeView(node).setSelected(false);
            }
        }
    }
}

